/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.client.impl.TopologyMember;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.BroadcastGroupImpl;
import org.hornetq.core.server.cluster.impl.ClusterConnectionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.UUID;

public class ClusterManagerImpl
implements ClusterManager {
    private static final Logger log = Logger.getLogger(ClusterManagerImpl.class);
    private final Map<String, BroadcastGroup> broadcastGroups = new HashMap<String, BroadcastGroup>();
    private final Map<String, Bridge> bridges = new HashMap<String, Bridge>();
    private final ExecutorFactory executorFactory;
    private final HornetQServer server;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledExecutor;
    private final ManagementService managementService;
    private final Configuration configuration;
    private final UUID nodeUUID;
    private volatile boolean started;
    private boolean backup;
    private final boolean clustered;
    private final Map<String, ClusterConnection> clusterConnections = new HashMap<String, ClusterConnection>();
    private Set<ClusterTopologyListener> clientListeners = new ConcurrentHashSet<ClusterTopologyListener>();
    private Set<ClusterTopologyListener> clusterConnectionListeners = new ConcurrentHashSet<ClusterTopologyListener>();
    private Topology topology = new Topology();
    private volatile ServerLocatorInternal backupServerLocator;
    private final List<ServerLocatorInternal> clusterLocators = new ArrayList<ServerLocatorInternal>();

    public ClusterManagerImpl(ExecutorFactory executorFactory, HornetQServer server, PostOffice postOffice, ScheduledExecutorService scheduledExecutor, ManagementService managementService, Configuration configuration, UUID nodeUUID, boolean backup, boolean clustered) {
        if (nodeUUID == null) {
            throw new IllegalArgumentException("Node uuid is null");
        }
        this.executorFactory = executorFactory;
        this.server = server;
        this.postOffice = postOffice;
        this.scheduledExecutor = scheduledExecutor;
        this.managementService = managementService;
        this.configuration = configuration;
        this.nodeUUID = nodeUUID;
        this.backup = backup;
        this.clustered = clustered;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.clustered) {
            for (BroadcastGroupConfiguration broadcastGroupConfiguration : this.configuration.getBroadcastGroupConfigurations()) {
                this.deployBroadcastGroup(broadcastGroupConfiguration);
            }
            for (ClusterConnectionConfiguration clusterConnectionConfiguration : this.configuration.getClusterConfigurations()) {
                this.deployClusterConnection(clusterConnectionConfiguration);
            }
        }
        for (BridgeConfiguration bridgeConfiguration : this.configuration.getBridgeConfigurations()) {
            this.deployBridge(bridgeConfiguration);
        }
        if (this.clusterConnections.size() > 0) {
            this.announceNode();
        }
        this.started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.clustered) {
            for (BroadcastGroup group : this.broadcastGroups.values()) {
                group.stop();
                this.managementService.unregisterBroadcastGroup(group.getName());
            }
            this.broadcastGroups.clear();
            for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
                clusterConnection.stop();
                this.managementService.unregisterCluster(clusterConnection.getName().toString());
            }
            this.clusterConnectionListeners.clear();
            this.clientListeners.clear();
            this.clusterConnections.clear();
            this.topology.clear();
        }
        for (Bridge bridge : this.bridges.values()) {
            bridge.stop();
            this.managementService.unregisterBridge(bridge.getName().toString());
        }
        this.bridges.clear();
        if (this.backupServerLocator != null) {
            this.backupServerLocator.close();
            this.backupServerLocator = null;
        }
        for (ServerLocatorInternal clusterLocator : this.clusterLocators) {
            clusterLocator.close();
        }
        this.clusterLocators.clear();
        this.started = false;
    }

    @Override
    public void notifyNodeDown(String nodeID) {
        if (nodeID.equals(this.nodeUUID.toString())) {
            return;
        }
        boolean removed = this.topology.removeMember(nodeID);
        if (removed) {
            for (ClusterTopologyListener listener : this.clientListeners) {
                listener.nodeDown(nodeID);
            }
            for (ClusterTopologyListener listener : this.clusterConnectionListeners) {
                listener.nodeDown(nodeID);
            }
        }
    }

    @Override
    public void notifyNodeUp(String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
        boolean updated = this.topology.addMember(nodeID, new TopologyMember(connectorPair));
        if (!updated) {
            return;
        }
        for (ClusterTopologyListener listener : this.clientListeners) {
            listener.nodeUP(nodeID, connectorPair, last);
        }
        for (ClusterTopologyListener listener : this.clusterConnectionListeners) {
            listener.nodeUP(nodeID, connectorPair, last);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Map<String, Bridge> getBridges() {
        return new HashMap<String, Bridge>(this.bridges);
    }

    @Override
    public Set<ClusterConnection> getClusterConnections() {
        return new HashSet<ClusterConnection>(this.clusterConnections.values());
    }

    @Override
    public Set<BroadcastGroup> getBroadcastGroups() {
        return new HashSet<BroadcastGroup>(this.broadcastGroups.values());
    }

    @Override
    public ClusterConnection getClusterConnection(SimpleString name) {
        return this.clusterConnections.get(name.toString());
    }

    @Override
    public synchronized void addClusterTopologyListener(ClusterTopologyListener listener, boolean clusterConnection) {
        if (clusterConnection) {
            this.clusterConnectionListeners.add(listener);
        } else {
            this.clientListeners.add(listener);
        }
        this.topology.fireListeners(listener);
    }

    @Override
    public synchronized void removeClusterTopologyListener(ClusterTopologyListener listener, boolean clusterConnection) {
        if (clusterConnection) {
            this.clusterConnectionListeners.remove(listener);
        } else {
            this.clientListeners.remove(listener);
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public synchronized void activate() {
        if (this.backup) {
            this.backup = false;
            String nodeID = this.server.getNodeID().toString();
            TopologyMember member = this.topology.getMember(nodeID);
            if (member != null) {
                member.getConnector().a = member.getConnector().b;
                member.getConnector().b = null;
            }
            if (this.backupServerLocator != null) {
                try {
                    this.backupServerLocator.close();
                }
                catch (Exception e) {
                    log.warn("problem closing backup session factory", e);
                }
                this.backupServerLocator = null;
            }
            for (BroadcastGroup broadcastGroup : this.broadcastGroups.values()) {
                try {
                    broadcastGroup.start();
                    broadcastGroup.activate();
                }
                catch (Exception e) {
                    log.warn("unable to start broadcast group " + broadcastGroup.getName(), e);
                }
            }
            for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
                try {
                    clusterConnection.activate();
                }
                catch (Exception e) {
                    log.warn("unable to start cluster connection " + clusterConnection.getName(), e);
                }
            }
            for (Bridge bridge : this.bridges.values()) {
                try {
                    bridge.start();
                }
                catch (Exception e) {
                    log.warn("unable to start bridge " + bridge.getName(), e);
                }
            }
            for (ClusterTopologyListener listener : this.clientListeners) {
                listener.nodeUP(nodeID, member.getConnector(), false);
            }
            for (ClusterTopologyListener listener : this.clusterConnectionListeners) {
                listener.nodeUP(nodeID, member.getConnector(), false);
            }
        }
    }

    @Override
    public void announceBackup() throws Exception {
        List<ClusterConnectionConfiguration> configs = this.configuration.getClusterConfigurations();
        if (!configs.isEmpty()) {
            ClusterConnectionConfiguration config = configs.get(0);
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(config.getConnectorName());
            if (connector == null) {
                log.warn("No connecor with name '" + config.getConnectorName() + "'. backup cannot be announced.");
                return;
            }
            this.announceBackup(config, connector);
        } else {
            log.warn("no cluster connections defined, unable to announce backup");
        }
    }

    private synchronized void announceNode() {
        ClusterConnection cc = this.clusterConnections.values().iterator().next();
        String nodeID = this.server.getNodeID().toString();
        TopologyMember member = this.topology.getMember(nodeID);
        if (member == null) {
            member = this.backup ? new TopologyMember(new Pair<Object, TransportConfiguration>(null, cc.getConnector())) : new TopologyMember(new Pair<TransportConfiguration, Object>(cc.getConnector(), null));
            this.topology.addMember(nodeID, member);
        } else if (this.backup) {
            // empty if block
        }
        for (ClusterTopologyListener listener : this.clientListeners) {
            listener.nodeUP(nodeID, member.getConnector(), false);
        }
        for (ClusterTopologyListener listener : this.clusterConnectionListeners) {
            listener.nodeUP(nodeID, member.getConnector(), false);
        }
    }

    private synchronized void deployBroadcastGroup(BroadcastGroupConfiguration config) throws Exception {
        if (this.broadcastGroups.containsKey(config.getName())) {
            log.warn("There is already a broadcast-group with name " + config.getName() + " deployed. This one will not be deployed.");
            return;
        }
        InetAddress localAddress = null;
        if (config.getLocalBindAddress() != null) {
            localAddress = InetAddress.getByName(config.getLocalBindAddress());
        }
        InetAddress groupAddress = InetAddress.getByName(config.getGroupAddress());
        BroadcastGroupImpl group = new BroadcastGroupImpl(this.nodeUUID.toString(), config.getName(), localAddress, config.getLocalBindPort(), groupAddress, config.getGroupPort(), !this.backup);
        for (String connectorInfo : config.getConnectorInfos()) {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorInfo);
            if (connector == null) {
                this.logWarnNoConnector(config.getName(), connectorInfo);
                return;
            }
            group.addConnector(connector);
        }
        ScheduledFuture<?> future = this.scheduledExecutor.scheduleWithFixedDelay(group, 0L, config.getBroadcastPeriod(), TimeUnit.MILLISECONDS);
        group.setScheduledFuture(future);
        this.broadcastGroups.put(config.getName(), group);
        this.managementService.registerBroadcastGroup(group, config);
        if (!this.backup) {
            group.start();
        }
    }

    private void logWarnNoConnector(String connectorName, String bgName) {
        log.warn("There is no connector deployed with name '" + connectorName + "'. The broadcast group with name '" + bgName + "' will not be deployed.");
    }

    private TransportConfiguration[] connectorNameListToArray(List<String> connectorNames) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                log.warn("No connector defined with name '" + connectorName + "'. The bridge will not be deployed.");
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }

    @Override
    public synchronized void deployBridge(BridgeConfiguration config) throws Exception {
        ServerLocatorInternal serverLocator;
        if (config.getName() == null) {
            log.warn("Must specify a unique name for each bridge. This one will not be deployed.");
            return;
        }
        if (config.getQueueName() == null) {
            log.warn("Must specify a queue name for each bridge. This one will not be deployed.");
            return;
        }
        if (config.getForwardingAddress() == null) {
            log.debug("Forward address is not specified. Will use original message address instead");
        }
        if (this.bridges.containsKey(config.getName())) {
            log.warn("There is already a bridge with name " + config.getName() + " deployed. This one will not be deployed.");
            return;
        }
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Binding binding = this.postOffice.getBinding(new SimpleString(config.getQueueName()));
        if (binding == null) {
            log.warn("No queue found with name " + config.getQueueName() + " bridge will not be deployed.");
            return;
        }
        Queue queue = (Queue)binding.getBindable();
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (discoveryGroupConfiguration == null) {
                log.warn("No discovery group configured with name '" + config.getDiscoveryGroupName() + "'. The bridge will not be deployed.");
                return;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA(discoveryGroupConfiguration) : (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA(discoveryGroupConfiguration);
        } else {
            TransportConfiguration[] tcConfigs = this.connectorNameListToArray(config.getStaticConnectors());
            if (tcConfigs == null) {
                return;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA(tcConfigs) : (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA(tcConfigs);
        }
        serverLocator.setConfirmationWindowSize(config.getConfirmationWindowSize());
        serverLocator.setReconnectAttempts(config.getReconnectAttempts());
        serverLocator.setRetryInterval(config.getRetryInterval());
        serverLocator.setRetryIntervalMultiplier(config.getRetryIntervalMultiplier());
        serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        serverLocator.setInitialConnectAttempts(config.getReconnectAttempts());
        this.clusterLocators.add(serverLocator);
        BridgeImpl bridge = new BridgeImpl(serverLocator, this.nodeUUID, new SimpleString(config.getName()), queue, this.executorFactory.getExecutor(), SimpleString.toSimpleString(config.getFilterString()), SimpleString.toSimpleString(config.getForwardingAddress()), this.scheduledExecutor, transformer, config.isUseDuplicateDetection(), config.getUser(), config.getPassword(), !this.backup, this.server.getStorageManager());
        this.bridges.put(config.getName(), bridge);
        this.managementService.registerBridge(bridge, config);
        if (!this.backup) {
            bridge.start();
        }
    }

    @Override
    public synchronized void destroyBridge(String name) throws Exception {
        Bridge bridge = this.bridges.remove(name);
        if (bridge != null) {
            bridge.stop();
            this.managementService.unregisterBridge(name);
        }
    }

    private synchronized void deployClusterConnection(ClusterConnectionConfiguration config) throws Exception {
        ClusterConnectionImpl clusterConnection;
        if (config.getName() == null) {
            log.warn("Must specify a unique name for each cluster. This one will not be deployed.");
            return;
        }
        if (config.getAddress() == null) {
            log.warn("Must specify an address for each cluster connection. This one will not be deployed.");
            return;
        }
        TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(config.getConnectorName());
        if (connector == null) {
            log.warn("No connecor with name '" + config.getConnectorName() + "'. The cluster connection will not be deployed.");
            return;
        }
        if (this.clusterConnections.containsKey(config.getName())) {
            log.warn("Clustwer Configuration  '" + config.getConnectorName() + "' already exists. The cluster connection will not be deployed.");
            return;
        }
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                log.warn("No discovery group with name '" + config.getDiscoveryGroupName() + "'. The cluster connection will not be deployed.");
            }
            clusterConnection = new ClusterConnectionImpl(dg, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getRetryInterval(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeUUID, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly());
        } else {
            TransportConfiguration[] tcConfigs = config.getStaticConnectors() != null ? this.connectorNameListToArray(config.getStaticConnectors()) : null;
            clusterConnection = new ClusterConnectionImpl(tcConfigs, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getRetryInterval(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeUUID, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly());
        }
        this.managementService.registerCluster(clusterConnection, config);
        this.clusterConnections.put(config.getName(), clusterConnection);
        clusterConnection.start();
        if (this.backup) {
            this.announceBackup(config, connector);
        }
    }

    private void announceBackup(ClusterConnectionConfiguration config, final TransportConfiguration connector) throws Exception {
        if (config.getStaticConnectors() != null) {
            TransportConfiguration[] tcConfigs = this.connectorNameListToArray(config.getStaticConnectors());
            this.backupServerLocator = (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA(tcConfigs);
            this.backupServerLocator.setReconnectAttempts(-1);
        } else if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                log.warn("No discovery group with name '" + config.getDiscoveryGroupName() + "'. The cluster connection will not be deployed.");
            }
            this.backupServerLocator = (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA(dg);
            this.backupServerLocator.setReconnectAttempts(-1);
        } else {
            return;
        }
        log.info("announcing backup");
        this.executorFactory.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientSessionFactory backupSessionFactory = ClusterManagerImpl.this.backupServerLocator.connect();
                    if (backupSessionFactory != null) {
                        backupSessionFactory.getConnection().getChannel(0L, -1).send(new NodeAnnounceMessage(ClusterManagerImpl.this.nodeUUID.toString(), true, connector));
                        log.info("backup announced");
                    }
                }
                catch (Exception e) {
                    log.warn("Unable to announce backup", e);
                }
            }
        });
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(transformerClassName);
                transformer = (Transformer)clz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + transformerClassName + "\"", e);
            }
        }
        return transformer;
    }

    public void clear() {
        this.bridges.clear();
        for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
            try {
                clusterConnection.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clusterConnections.clear();
    }
}

