/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class FileLockNodeManager
extends NodeManager {
    private static final Logger log = Logger.getLogger(FileLockNodeManager.class);
    private static final String SERVER_LOCK_NAME = "server.lock";
    private static final String ACCESS_MODE = "rw";
    private static final int LIVE_LOCK_POS = 1;
    private static final int BACKUP_LOCK_POS = 2;
    private static final int LOCK_LENGTH = 1;
    private static final byte LIVE = 76;
    private static final byte FAILINGBACK = 70;
    private static final byte PAUSED = 80;
    private static final byte NOT_STARTED = 78;
    private FileChannel channel;
    private FileLock liveLock;
    private FileLock backupLock;
    private final String directory;

    public FileLockNodeManager(String directory) {
        this.directory = directory;
    }

    @Override
    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        File file = new File(this.directory, SERVER_LOCK_NAME);
        if (!file.exists()) {
            file.createNewFile();
        }
        RandomAccessFile raFile = new RandomAccessFile(file, ACCESS_MODE);
        this.channel = raFile.getChannel();
        this.createNodeId();
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.channel.close();
        super.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.getState() == 70;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        FileLock liveAttemptLock = this.channel.tryLock(1L, 1L, false);
        if (liveAttemptLock == null) {
            return true;
        }
        liveAttemptLock.release();
        return false;
    }

    @Override
    public void releaseBackup() throws Exception {
        this.releaseBackupLock();
    }

    @Override
    public void awaitLiveNode() throws Exception {
        while (true) {
            byte state = this.getState();
            while (state == 78 || state == 0) {
                log.info("awaiting live node startup state='" + state + "'");
                Thread.sleep(2000L);
                state = this.getState();
            }
            this.liveLock = this.channel.lock(1L, 1L, false);
            state = this.getState();
            if (state == 80) {
                this.liveLock.release();
                log.info("awaiting live node restarting");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 70) {
                this.liveLock.release();
                log.info("awaiting live node failing back");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 76) break;
        }
    }

    @Override
    public void startBackup() throws Exception {
        log.info("Waiting to become backup node");
        this.backupLock = this.channel.lock(2L, 1L, false);
        log.info("** got backup lock");
        this.readNodeId();
    }

    @Override
    public void startLiveNode() throws Exception {
        this.setFailingBack();
        log.info("Waiting to obtain live lock");
        this.liveLock = this.channel.lock(1L, 1L, false);
        log.info("Live Server Obtained live lock");
        this.setLive();
    }

    @Override
    public void pauseLiveServer() throws Exception {
        this.setPaused();
        this.liveLock.release();
    }

    @Override
    public void crashLiveServer() throws Exception {
        this.setLive();
        this.liveLock.release();
    }

    @Override
    public void stopBackup() throws Exception {
        this.backupLock.release();
    }

    private void setLive() throws Exception {
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put((byte)76);
        bb.position(0);
        this.channel.write(bb, 0L);
        this.channel.force(true);
    }

    private void setFailingBack() throws Exception {
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put((byte)70);
        bb.position(0);
        this.channel.write(bb, 0L);
        this.channel.force(true);
    }

    private void setPaused() throws Exception {
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put((byte)80);
        bb.position(0);
        this.channel.write(bb, 0L);
        this.channel.force(true);
    }

    private byte getState() throws Exception {
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        int read = this.channel.read(bb, 0L);
        if (read <= 0) {
            return 78;
        }
        return bb.get(0);
    }

    private void releaseBackupLock() throws Exception {
        if (this.backupLock != null) {
            this.backupLock.release();
        }
    }

    private void createNodeId() throws Exception {
        ByteBuffer id = ByteBuffer.allocateDirect(16);
        int read = this.channel.read(id, 3L);
        if (read != 16) {
            this.uuid = UUIDGenerator.getInstance().generateUUID();
            this.nodeID = new SimpleString(this.uuid.toString());
            id.put(this.uuid.asBytes(), 0, 16);
            id.position(0);
            this.channel.write(id, 3L);
            this.channel.force(true);
        } else {
            byte[] bytes = new byte[16];
            id.position(0);
            id.get(bytes);
            this.uuid = new UUID(1, bytes);
            this.nodeID = new SimpleString(this.uuid.toString());
        }
    }

    private void readNodeId() throws Exception {
        ByteBuffer id = ByteBuffer.allocateDirect(16);
        int read = this.channel.read(id, 3L);
        if (read != 16) {
            throw new IllegalStateException("live server did not write id to file");
        }
        byte[] bytes = new byte[16];
        id.position(0);
        id.get(bytes);
        this.uuid = new UUID(1, bytes);
        this.nodeID = new SimpleString(this.uuid.toString());
    }
}

