/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientConsumerImpl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.Future;
import org.hornetq.utils.TypedProperties;

public class ServerConsumerImpl
implements ServerConsumer,
ReadyListener {
    private static final Logger log = Logger.getLogger(ServerConsumerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final long id;
    private final Queue messageQueue;
    private final Filter filter;
    private final int minLargeMessageSize;
    private final ServerSession session;
    private final Executor executor;
    private final Object lock = new Object();
    private volatile AtomicInteger availableCredits = new AtomicInteger(0);
    private boolean started;
    private volatile LargeMessageDeliverer largeMessageDeliverer = null;
    private boolean largeMessageInDelivery;
    private final boolean browseOnly;
    private Runnable browserDeliverer;
    private final boolean strictUpdateDeliveryCount;
    private final StorageManager storageManager;
    private final java.util.Queue<MessageReference> deliveringRefs = new ConcurrentLinkedQueue<MessageReference>();
    private final SessionCallback callback;
    private volatile boolean closed;
    private final boolean preAcknowledge;
    private final ManagementService managementService;
    private final Binding binding;
    private boolean transferring = false;
    private AtomicBoolean writeReady = new AtomicBoolean(true);
    private final long creationTime;
    private final Runnable resumeLargeMessageRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                try {
                    if (ServerConsumerImpl.this.largeMessageDeliverer == null || ServerConsumerImpl.this.largeMessageDeliverer.deliver()) {
                        if (ServerConsumerImpl.this.browseOnly) {
                            ServerConsumerImpl.this.executor.execute(ServerConsumerImpl.this.browserDeliverer);
                        } else {
                            ServerConsumerImpl.this.messageQueue.deliverAsync();
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Failed to run large message deliverer", e);
                }
            }
        }
    };

    private static void trace(String message) {
        log.trace(message);
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService) throws Exception {
        this.id = id;
        this.filter = filter;
        this.session = session;
        this.binding = binding;
        this.messageQueue = binding.getQueue();
        this.executor = this.messageQueue.getExecutor();
        this.started = browseOnly || started;
        this.browseOnly = browseOnly;
        this.storageManager = storageManager;
        this.callback = callback;
        this.preAcknowledge = preAcknowledge;
        this.managementService = managementService;
        this.minLargeMessageSize = session.getMinLargeMessageSize();
        this.strictUpdateDeliveryCount = strictUpdateDeliveryCount;
        this.callback.addReadyListener(this);
        this.creationTime = System.currentTimeMillis();
        if (browseOnly) {
            this.browserDeliverer = new BrowserDeliverer(this.messageQueue.iterator());
        } else {
            this.messageQueue.addConsumer(this);
        }
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getConnectionID() {
        return this.session.getConnectionID().toString();
    }

    @Override
    public String getSessionID() {
        return this.session.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (this.availableCredits != null && this.availableCredits.get() <= 0) {
            return HandleStatus.BUSY;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.started || this.transferring) {
                return HandleStatus.BUSY;
            }
            if (this.largeMessageInDelivery) {
                return HandleStatus.BUSY;
            }
            ServerMessage message = ref.getMessage();
            if (this.filter != null && !this.filter.match(message)) {
                return HandleStatus.NO_MATCH;
            }
            if (!this.browseOnly) {
                if (!this.preAcknowledge) {
                    this.deliveringRefs.add(ref);
                }
                ref.handled();
                ref.incrementDeliveryCount();
                if (this.strictUpdateDeliveryCount && ref.getMessage().isDurable() && ref.getQueue().isDurable()) {
                    this.storageManager.updateDeliveryCount(ref);
                }
                if (this.preAcknowledge) {
                    if (message.isLargeMessage()) {
                        ((LargeServerMessage)message).incrementDelayDeletionCount();
                    }
                    ref.getQueue().acknowledge(ref);
                }
            }
            if (message.isLargeMessage()) {
                this.deliverLargeMessage(ref, message);
            } else {
                this.deliverStandardMessage(ref, message);
            }
            return HandleStatus.HANDLED;
        }
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void close(boolean failed) throws Exception {
        this.callback.removeReadyListener(this);
        this.setStarted(false);
        if (this.largeMessageDeliverer != null) {
            this.largeMessageDeliverer.finish();
        }
        if (!this.browseOnly) {
            this.messageQueue.removeConsumer(this);
        }
        this.session.removeConsumer(this.id);
        List refs = this.cancelRefs(failed, false, null);
        Iterator iter = ((AbstractSequentialList)refs).iterator();
        this.closed = true;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        while (iter.hasNext()) {
            MessageReference ref = (MessageReference)iter.next();
            ref.getQueue().cancel(tx, ref);
        }
        tx.rollback();
        if (!this.browseOnly) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, this.binding.getClusterName());
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, this.binding.getRoutingName());
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, this.filter == null ? null : this.filter.getFilterString());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, this.binding.getDistance());
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, this.messageQueue.getConsumerCount());
            Notification notification = new Notification(null, NotificationType.CONSUMER_CLOSED, props);
            this.managementService.sendNotification(notification);
        }
    }

    @Override
    public synchronized void forceDelivery(long sequence) {
        this.promptDelivery();
        Future future = new Future();
        this.executor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Timed out waiting for executor");
        }
        try {
            ServerMessageImpl forcedDeliveryMessage = new ServerMessageImpl(this.storageManager.generateUniqueID(), 50);
            forcedDeliveryMessage.putLongProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE, sequence);
            forcedDeliveryMessage.setAddress(this.messageQueue.getName());
            this.callback.sendMessage(forcedDeliveryMessage, this.id, 0);
        }
        catch (Exception e) {
            log.error("Failed to send forced delivery message", e);
        }
    }

    public LinkedList<MessageReference> cancelRefs(boolean failed, boolean lastConsumedAsDelivered, Transaction tx) throws Exception {
        boolean performACK = lastConsumedAsDelivered;
        LinkedList<MessageReference> refs = new LinkedList<MessageReference>();
        if (!this.deliveringRefs.isEmpty()) {
            for (MessageReference ref : this.deliveringRefs) {
                if (performACK) {
                    this.acknowledge(false, tx, ref.getMessage().getMessageID());
                    performACK = false;
                    continue;
                }
                if (!failed) {
                    ref.decrementDeliveryCount();
                }
                refs.add(ref);
            }
            this.deliveringRefs.clear();
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStarted(boolean started) {
        Object object = this.lock;
        synchronized (object) {
            this.started = this.browseOnly || started;
        }
        if (started) {
            this.promptDelivery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransferring(boolean transferring) {
        Object object = this.lock;
        synchronized (object) {
            this.transferring = transferring;
            if (transferring) {
                while (this.largeMessageInDelivery) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
        }
        if (transferring) {
            Future future = new Future();
            this.executor.execute(future);
            boolean ok = future.await(10000L);
            if (!ok) {
                log.warn("Timed out waiting for executor to complete");
            }
        }
        if (!transferring) {
            this.promptDelivery();
        }
    }

    @Override
    public void receiveCredits(int credits) throws Exception {
        if (credits == -1) {
            this.availableCredits = null;
            this.promptDelivery();
        } else if (credits == 0) {
            this.availableCredits.set(0);
        } else {
            int previous = this.availableCredits.getAndAdd(credits);
            if (trace) {
                ServerConsumerImpl.trace("Received " + credits + " credits, previous value = " + previous + " currentValue = " + this.availableCredits.get());
            }
            if (previous <= 0 && previous + credits > 0) {
                this.promptDelivery();
            }
        }
    }

    @Override
    public Queue getQueue() {
        return this.messageQueue;
    }

    @Override
    public void acknowledge(boolean autoCommitAcks, Transaction tx, long messageID) throws Exception {
        MessageReference ref;
        if (this.browseOnly) {
            return;
        }
        do {
            if ((ref = this.deliveringRefs.poll()) == null) {
                throw new IllegalStateException(System.identityHashCode(this) + " Could not find reference on consumerID=" + this.id + ", messageId = " + messageID + " queue = " + this.messageQueue.getName() + " closed = " + this.closed);
            }
            if (autoCommitAcks || tx == null) {
                ref.acknowledge();
                continue;
            }
            ref.acknowledge(tx);
        } while (ref.getMessage().getMessageID() != messageID);
    }

    @Override
    public void individualAcknowledge(boolean autoCommitAcks, Transaction tx, long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        MessageReference ref = this.removeReferenceByID(messageID);
        if (ref == null) {
            throw new IllegalStateException("Cannot find ref to ack " + messageID);
        }
        if (autoCommitAcks) {
            ref.getQueue().acknowledge(ref);
        } else {
            ref.getQueue().acknowledge(tx, ref);
        }
    }

    @Override
    public MessageReference removeReferenceByID(long messageID) throws Exception {
        if (this.browseOnly) {
            return null;
        }
        Iterator iter = this.deliveringRefs.iterator();
        MessageReference ref = null;
        while (iter.hasNext()) {
            MessageReference theRef = (MessageReference)iter.next();
            if (theRef.getMessage().getMessageID() != messageID) continue;
            iter.remove();
            ref = theRef;
            break;
        }
        return ref;
    }

    @Override
    public void readyForWriting(boolean ready) {
        if (ready) {
            this.writeReady.set(true);
            this.promptDelivery();
        } else {
            this.writeReady.set(false);
        }
    }

    public AtomicInteger getAvailableCredits() {
        return this.availableCredits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptDelivery() {
        Object object = this.lock;
        synchronized (object) {
            if (this.largeMessageDeliverer != null) {
                this.resumeLargeMessage();
            } else if (this.browseOnly) {
                this.executor.execute(this.browserDeliverer);
            } else {
                this.messageQueue.deliverAsync();
            }
        }
    }

    private void resumeLargeMessage() {
        this.executor.execute(this.resumeLargeMessageRunnable);
    }

    private void deliverLargeMessage(MessageReference ref, ServerMessage message) throws Exception {
        LargeMessageDeliverer localDeliverer;
        this.largeMessageInDelivery = true;
        this.largeMessageDeliverer = localDeliverer = new LargeMessageDeliverer((LargeServerMessage)message, ref);
        this.largeMessageDeliverer.deliver();
    }

    private void deliverStandardMessage(MessageReference ref, ServerMessage message) {
        int packetSize = this.callback.sendMessage(message, this.id, ref.getDeliveryCount());
        if (this.availableCredits != null) {
            this.availableCredits.addAndGet(-packetSize);
        }
    }

    private class BrowserDeliverer
    implements Runnable {
        private MessageReference current = null;
        private final Iterator<MessageReference> iterator;

        public BrowserDeliverer(Iterator<MessageReference> iterator) {
            this.iterator = iterator;
        }

        @Override
        public synchronized void run() {
            if (this.current != null) {
                try {
                    HandleStatus status = ServerConsumerImpl.this.handle(this.current);
                    if (status == HandleStatus.BUSY) {
                        return;
                    }
                    this.current = null;
                }
                catch (Exception e) {
                    log.error("Exception while browser handled from " + ServerConsumerImpl.this.messageQueue + ": " + this.current, e);
                    return;
                }
            }
            while (this.iterator.hasNext()) {
                MessageReference ref = this.iterator.next();
                try {
                    HandleStatus status = ServerConsumerImpl.this.handle(ref);
                    if (status != HandleStatus.BUSY) continue;
                    this.current = ref;
                }
                catch (Exception e) {
                    log.error("Exception while browser handled from " + ServerConsumerImpl.this.messageQueue + ": " + ref, e);
                }
                break;
            }
        }
    }

    private final class LargeMessageDeliverer {
        private long sizePendingLargeMessage;
        private LargeServerMessage largeMessage;
        private final MessageReference ref;
        private boolean sentInitialPacket = false;
        private long positionPendingLargeMessage;
        private BodyEncoder context;

        public LargeMessageDeliverer(LargeServerMessage message, MessageReference ref) throws Exception {
            this.largeMessage = message;
            this.largeMessage.incrementDelayDeletionCount();
            this.ref = ref;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deliver() throws Exception {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                if (this.largeMessage == null) {
                    return true;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    return false;
                }
                if (!this.sentInitialPacket) {
                    this.context = this.largeMessage.getBodyEncoder();
                    this.sizePendingLargeMessage = this.context.getLargeBodySize();
                    this.context.open();
                    this.sentInitialPacket = true;
                    int packetSize = ServerConsumerImpl.this.callback.sendLargeMessage(this.largeMessage, ServerConsumerImpl.this.id, this.context.getLargeBodySize(), this.ref.getDeliveryCount());
                    if (ServerConsumerImpl.this.availableCredits != null) {
                        ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                    }
                    ServerConsumerImpl.this.resumeLargeMessage();
                    return false;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    if (trace) {
                        ServerConsumerImpl.trace("deliverLargeMessage: Leaving loop of send LargeMessage because of credits");
                    }
                    return false;
                }
                int localChunkLen = 0;
                localChunkLen = (int)Math.min(this.sizePendingLargeMessage - this.positionPendingLargeMessage, (long)ServerConsumerImpl.this.minLargeMessageSize);
                HornetQBuffer bodyBuffer = HornetQBuffers.fixedBuffer(localChunkLen);
                this.context.encode(bodyBuffer, localChunkLen);
                byte[] body = bodyBuffer.toByteBuffer().array();
                int packetSize = ServerConsumerImpl.this.callback.sendLargeMessageContinuation(ServerConsumerImpl.this.id, body, this.positionPendingLargeMessage + (long)localChunkLen < this.sizePendingLargeMessage, false);
                int chunkLen = body.length;
                if (trace) {
                    ServerConsumerImpl.trace("deliverLargeMessage: Sending " + packetSize + " availableCredits now is " + ServerConsumerImpl.this.availableCredits);
                }
                if (ServerConsumerImpl.this.availableCredits != null) {
                    ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                }
                this.positionPendingLargeMessage += (long)chunkLen;
                if (this.positionPendingLargeMessage < this.sizePendingLargeMessage) {
                    ServerConsumerImpl.this.resumeLargeMessage();
                    return false;
                }
                if (trace) {
                    ServerConsumerImpl.trace("Finished deliverLargeMessage");
                }
                this.finish();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() throws Exception {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                if (this.largeMessage == null) {
                    return;
                }
                this.context.close();
                this.largeMessage.releaseResources();
                this.largeMessage.decrementDelayDeletionCount();
                if (ServerConsumerImpl.this.preAcknowledge && !ServerConsumerImpl.this.browseOnly) {
                    this.largeMessage.decrementDelayDeletionCount();
                }
                ServerConsumerImpl.this.largeMessageDeliverer = null;
                ServerConsumerImpl.this.largeMessageInDelivery = false;
                this.largeMessage = null;
            }
        }
    }
}

