/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SoftValueHashMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<V> refQueue = new ReferenceQueue();
    private final Map<K, AggregatedSoftReference> mapDelegate = new HashMap<K, AggregatedSoftReference>();

    @Override
    public int size() {
        this.processQueue();
        return this.mapDelegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.mapDelegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.mapDelegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (AggregatedSoftReference valueIter : this.mapDelegate.values()) {
            Object valueElement = valueIter.get();
            if (valueElement == null || !value.equals(valueElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        AggregatedSoftReference value = this.mapDelegate.get(key);
        if (value != null) {
            return (V)value.get();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        AggregatedSoftReference refPut = this.mapDelegate.put(key, this.createReference(key, value));
        if (refPut != null) {
            return (V)refPut.get();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        AggregatedSoftReference ref = this.mapDelegate.remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.processQueue();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.mapDelegate.clear();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.mapDelegate.keySet();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        ArrayList list = new ArrayList();
        for (AggregatedSoftReference refs : this.mapDelegate.values()) {
            Object value = refs.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, AggregatedSoftReference> pair : this.mapDelegate.entrySet()) {
            Object value = pair.getValue().get();
            if (value == null) continue;
            set.add(new EntryElement(pair.getKey(), value));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        this.processQueue();
        return ((Object)this.mapDelegate).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.mapDelegate).hashCode();
    }

    private void processQueue() {
        AggregatedSoftReference ref = null;
        while ((ref = (AggregatedSoftReference)this.refQueue.poll()) != null) {
            this.mapDelegate.remove(ref.key);
        }
    }

    private AggregatedSoftReference createReference(K key, V value) {
        AggregatedSoftReference ref = new AggregatedSoftReference(key, value);
        return ref;
    }

    static final class EntryElement<K, V>
    implements Map.Entry<K, V> {
        final K key;
        volatile V value;

        EntryElement(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }
    }

    class AggregatedSoftReference
    extends SoftReference<V> {
        final K key;

        public AggregatedSoftReference(K key, V referent) {
            super(referent, SoftValueHashMap.this.refQueue);
            this.key = key;
        }
    }
}

