/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.version.Version;
import org.hornetq.core.version.impl.VersionImpl;

public class VersionLoader {
    private static final Logger log = Logger.getLogger(VersionLoader.class);
    public static final String PROP_FILE_NAME = "hornetq-version.properties";
    private static Version version;

    public static Version getVersion() {
        if (version == null) {
            throw new RuntimeException("hornetq-version.properties is not available");
        }
        return version;
    }

    private static Version load() {
        Properties versionProps = new Properties();
        InputStream in = VersionImpl.class.getClassLoader().getResourceAsStream(PROP_FILE_NAME);
        try {
            if (in == null) {
                throw new RuntimeException("hornetq-version.properties is not available");
            }
            try {
                versionProps.load(in);
                String versionName = versionProps.getProperty("hornetq.version.versionName");
                int majorVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.majorVersion"));
                int minorVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.minorVersion"));
                int microVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.microVersion"));
                int incrementingVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.incrementingVersion"));
                String versionSuffix = versionProps.getProperty("hornetq.version.versionSuffix");
                String nettyVersion = versionProps.getProperty("hornetq.netty.version");
                int[] compatibleVersionArray = VersionLoader.parseCompatibleVersionList(versionProps.getProperty("hornetq.version.compatibleVersionList"));
                VersionImpl versionImpl = new VersionImpl(versionName, majorVersion, minorVersion, microVersion, incrementingVersion, versionSuffix, nettyVersion, compatibleVersionArray);
                return versionImpl;
            }
            catch (IOException e) {
                throw new RuntimeException("unable to load hornetq-version.properties", e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable ignored) {}
        }
    }

    private static int[] parseCompatibleVersionList(String property) throws IOException {
        int[] verArray = new int[]{};
        StringTokenizer tokenizer = new StringTokenizer(property, ",");
        while (tokenizer.hasMoreTokens()) {
            int cursor;
            int from = -1;
            int to = -1;
            String token = tokenizer.nextToken();
            char firstChar = token.charAt(0);
            if (firstChar == '-') {
                from = 0;
                ++cursor;
                while (cursor < token.length() && Character.isDigit(token.charAt(cursor))) {
                    ++cursor;
                }
                if (cursor > 1) {
                    to = Integer.parseInt(token.substring(1, cursor));
                }
            } else if (Character.isDigit(firstChar)) {
                for (cursor = 0; cursor < token.length() && Character.isDigit(token.charAt(cursor)); ++cursor) {
                }
                from = Integer.parseInt(token.substring(0, cursor));
                if (cursor == token.length()) {
                    to = from;
                } else if (token.charAt(cursor) == '-') {
                    to = ++cursor == token.length() ? Integer.MAX_VALUE : Integer.parseInt(token.substring(cursor));
                }
            }
            if (from == -1 || to == -1) continue;
            int[] newArray = new int[verArray.length + to - from + 1];
            System.arraycopy(verArray, 0, newArray, 0, verArray.length);
            for (int i = 0; i < to - from + 1; ++i) {
                newArray[verArray.length + i] = from + i;
            }
            verArray = newArray;
        }
        return verArray;
    }

    static {
        try {
            version = VersionLoader.load();
        }
        catch (Throwable e) {
            version = null;
            log.error(e.getMessage(), e);
        }
    }
}

