/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import java.io.Serializable;
import java.util.List;

public class ClusterConnectionConfiguration
implements Serializable {
    private static final long serialVersionUID = 8948303813427795935L;
    private final String name;
    private final String address;
    private final String connectorName;
    private final long clientFailureCheckPeriod;
    private final long connectionTTL;
    private final long retryInterval;
    private final double retryIntervalMultiplier;
    private final long maxRetryInterval;
    private final int reconnectAttempts;
    private final long callTimeout;
    private final boolean duplicateDetection;
    private final boolean forwardWhenNoConsumers;
    private final List<String> staticConnectors;
    private final String discoveryGroupName;
    private final int maxHops;
    private final int confirmationWindowSize;
    private final boolean allowDirectConnectionsOnly;
    private final int minLargeMessageSize;

    public ClusterConnectionConfiguration(String name, String address, String connectorName, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, List<String> staticConnectors, boolean allowDirectConnectionsOnly) {
        this(name, address, connectorName, 102400, 30000L, 60000L, retryInterval, 1.0, 2000L, -1, 30000L, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, staticConnectors, allowDirectConnectionsOnly);
    }

    public ClusterConnectionConfiguration(String name, String address, String connectorName, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, long callTimeout, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, List<String> staticConnectors, boolean allowDirectConnectionsOnly) {
        this.name = name;
        this.address = address;
        this.connectorName = connectorName;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.staticConnectors = staticConnectors;
        this.duplicateDetection = duplicateDetection;
        this.callTimeout = callTimeout;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = null;
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
        this.allowDirectConnectionsOnly = allowDirectConnectionsOnly;
        this.minLargeMessageSize = minLargeMessageSize;
    }

    public ClusterConnectionConfiguration(String name, String address, String connectorName, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, String discoveryGroupName) {
        this(name, address, connectorName, 102400, 30000L, 60000L, retryInterval, 1.0, 2000L, -1, 30000L, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, discoveryGroupName);
    }

    public ClusterConnectionConfiguration(String name, String address, String connectorName, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, long callTimeout, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, String discoveryGroupName) {
        this.name = name;
        this.address = address;
        this.connectorName = connectorName;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.callTimeout = callTimeout;
        this.duplicateDetection = duplicateDetection;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = discoveryGroupName;
        this.staticConnectors = null;
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
        this.minLargeMessageSize = minLargeMessageSize;
        this.allowDirectConnectionsOnly = false;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public boolean isDuplicateDetection() {
        return this.duplicateDetection;
    }

    public boolean isForwardWhenNoConsumers() {
        return this.forwardWhenNoConsumers;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public boolean isAllowDirectConnectionsOnly() {
        return this.allowDirectConnectionsOnly;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }
}

