/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.RemoteQueueBinding;

public class RemoteQueueBindingImpl
implements RemoteQueueBinding {
    private static final Logger log = Logger.getLogger(RemoteQueueBindingImpl.class);
    private final SimpleString address;
    private final Queue storeAndForwardQueue;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final long remoteQueueID;
    private final Filter queueFilter;
    private final Set<Filter> filters = new HashSet<Filter>();
    private final Map<SimpleString, Integer> filterCounts = new HashMap<SimpleString, Integer>();
    private int consumerCount;
    private final SimpleString idsHeaderName;
    private final long id;
    private final int distance;

    public RemoteQueueBindingImpl(long id, SimpleString address, SimpleString uniqueName, SimpleString routingName, Long remoteQueueID, SimpleString filterString, Queue storeAndForwardQueue, SimpleString bridgeName, int distance) throws Exception {
        this.id = id;
        this.address = address;
        this.storeAndForwardQueue = storeAndForwardQueue;
        this.uniqueName = uniqueName;
        this.routingName = routingName;
        this.remoteQueueID = remoteQueueID;
        this.queueFilter = FilterImpl.createFilter(filterString);
        this.idsHeaderName = MessageImpl.HDR_ROUTE_TO_IDS.concat(bridgeName);
        this.distance = distance;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Bindable getBindable() {
        return this.storeAndForwardQueue;
    }

    @Override
    public Queue getQueue() {
        return this.storeAndForwardQueue;
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public SimpleString getClusterName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public BindingType getType() {
        return BindingType.REMOTE_QUEUE;
    }

    @Override
    public Filter getFilter() {
        return this.queueFilter;
    }

    @Override
    public int getDistance() {
        return this.distance;
    }

    @Override
    public synchronized boolean isHighAcceptPriority(ServerMessage message) {
        if (this.consumerCount == 0) {
            return false;
        }
        if (this.filters.isEmpty()) {
            return true;
        }
        for (Filter filter : this.filters) {
            if (!filter.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) {
        this.addRouteContextToMessage(message);
        List<Queue> durableQueuesOnContext = context.getDurableQueues(this.storeAndForwardQueue.getAddress());
        if (!durableQueuesOnContext.contains(this.storeAndForwardQueue)) {
            context.addQueue(this.storeAndForwardQueue.getAddress(), this.storeAndForwardQueue);
        }
    }

    @Override
    public synchronized void addConsumer(SimpleString filterString) throws Exception {
        if (filterString != null) {
            Integer i = this.filterCounts.get(filterString);
            if (i == null) {
                this.filterCounts.put(filterString, 1);
                this.filters.add(FilterImpl.createFilter(filterString));
            } else {
                this.filterCounts.put(filterString, i + 1);
            }
        }
        ++this.consumerCount;
    }

    @Override
    public synchronized void removeConsumer(SimpleString filterString) throws Exception {
        Integer i;
        if (filterString != null && (i = this.filterCounts.get(filterString)) != null) {
            int ii = i - 1;
            if (ii == 0) {
                this.filterCounts.remove(filterString);
                this.filters.remove(FilterImpl.createFilter(filterString));
            } else {
                this.filterCounts.put(filterString, ii);
            }
        }
        --this.consumerCount;
    }

    @Override
    public synchronized int consumerCount() {
        return this.consumerCount;
    }

    public String toString() {
        return "RemoteQueueBindingImpl [address=" + this.address + ", consumerCount=" + this.consumerCount + ", distance=" + this.distance + ", filters=" + this.filters + ", id=" + this.id + ", idsHeaderName=" + this.idsHeaderName + ", queueFilter=" + this.queueFilter + ", remoteQueueID=" + this.remoteQueueID + ", routingName=" + this.routingName + ", storeAndForwardQueue=" + this.storeAndForwardQueue + ", uniqueName=" + this.uniqueName + "]";
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public void close() throws Exception {
        this.storeAndForwardQueue.close();
    }

    private void addRouteContextToMessage(ServerMessage message) {
        byte[] ids = message.getBytesProperty(this.idsHeaderName);
        if (ids == null) {
            ids = new byte[8];
        } else {
            byte[] newIds = new byte[ids.length + 8];
            System.arraycopy(ids, 0, newIds, 8, ids.length);
            ids = newIds;
        }
        ByteBuffer buff = ByteBuffer.wrap(ids);
        buff.putLong(this.remoteQueueID);
        message.putBytesProperty(this.idsHeaderName, ids);
        if (log.isTraceEnabled()) {
            log.trace("Adding remoteQueue ID = " + this.remoteQueueID + " into message=" + message + " store-forward-queue=" + this.storeAndForwardQueue);
        }
    }
}

