/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.loadbalance.ConnectionLoadBalancingPolicy;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.client.impl.TopologyMember;
import org.hornetq.core.cluster.DiscoveryEntry;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.cluster.DiscoveryListener;
import org.hornetq.core.cluster.impl.DiscoveryGroupImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.UUIDGenerator;

public class ServerLocatorImpl
implements ServerLocatorInternal,
DiscoveryListener,
Serializable {
    private static final long serialVersionUID = -1615857864410205260L;
    private static final Logger log = Logger.getLogger(ServerLocatorImpl.class);
    private final boolean ha;
    private boolean finalizeCheck = true;
    private boolean clusterConnection;
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private Set<ClientSessionFactory> factories = new HashSet<ClientSessionFactory>();
    private TransportConfiguration[] initialConnectors;
    private DiscoveryGroupConfiguration discoveryGroupConfiguration;
    private StaticConnector staticConnector = new StaticConnector();
    private Topology topology = new Topology();
    private Pair<TransportConfiguration, TransportConfiguration>[] topologyArray;
    private boolean receivedTopology;
    private boolean compressLargeMessage;
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduledThreadPool;
    private DiscoveryGroup discoveryGroup;
    private ConnectionLoadBalancingPolicy loadBalancingPolicy;
    private boolean readOnly;
    private boolean cacheLargeMessagesClient;
    private long clientFailureCheckPeriod;
    private long connectionTTL;
    private long callTimeout;
    private int minLargeMessageSize;
    private int consumerWindowSize;
    private int consumerMaxRate;
    private int confirmationWindowSize;
    private int producerWindowSize;
    private int producerMaxRate;
    private boolean blockOnAcknowledge;
    private boolean blockOnDurableSend;
    private boolean blockOnNonDurableSend;
    private boolean autoGroup;
    private boolean preAcknowledge;
    private String connectionLoadBalancingPolicyClassName;
    private int ackBatchSize;
    private boolean useGlobalPools;
    private int scheduledThreadPoolMaxSize;
    private int threadPoolMaxSize;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private long maxRetryInterval;
    private int reconnectAttempts;
    private int initialConnectAttempts;
    private boolean failoverOnInitialConnection;
    private int initialMessagePacketSize;
    private volatile boolean closed;
    private volatile boolean closing;
    private final List<Interceptor> interceptors = new CopyOnWriteArrayList<Interceptor>();
    private static ExecutorService globalThreadPool;
    private static ScheduledExecutorService globalScheduledThreadPool;
    private String groupID;
    private String nodeID;
    private TransportConfiguration clusterTransportConfiguration;
    private boolean backup;
    private final Exception e = new Exception();
    public static Runnable finalizeCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clearThreadPools() {
        if (globalThreadPool != null) {
            globalThreadPool.shutdown();
            try {
                if (!globalThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't finish the globalThreadPool");
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                globalThreadPool = null;
            }
        }
        if (globalScheduledThreadPool != null) {
            globalScheduledThreadPool.shutdown();
            try {
                if (!globalScheduledThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't finish the globalScheduledThreadPool");
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                globalScheduledThreadPool = null;
            }
        }
    }

    private static synchronized ExecutorService getGlobalThreadPool() {
        if (globalThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-threads", true, ServerLocatorImpl.getThisClassLoader());
            globalThreadPool = Executors.newCachedThreadPool(factory);
        }
        return globalThreadPool;
    }

    public static synchronized ScheduledExecutorService getGlobalScheduledThreadPool() {
        if (globalScheduledThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-scheduled-threads", true, ServerLocatorImpl.getThisClassLoader());
            globalScheduledThreadPool = Executors.newScheduledThreadPool(5, factory);
        }
        return globalScheduledThreadPool;
    }

    private void setThreadPools() {
        if (this.useGlobalPools) {
            this.threadPool = ServerLocatorImpl.getGlobalThreadPool();
            this.scheduledThreadPool = ServerLocatorImpl.getGlobalScheduledThreadPool();
        } else {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-factory-threads-" + System.identityHashCode(this), true, ServerLocatorImpl.getThisClassLoader());
            this.threadPool = this.threadPoolMaxSize == -1 ? Executors.newCachedThreadPool(factory) : Executors.newFixedThreadPool(this.threadPoolMaxSize, factory);
            factory = new HornetQThreadFactory("HornetQ-client-factory-pinger-threads-" + System.identityHashCode(this), true, ServerLocatorImpl.getThisClassLoader());
            this.scheduledThreadPool = Executors.newScheduledThreadPool(this.scheduledThreadPoolMaxSize, factory);
        }
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private void instantiateLoadBalancingPolicy() {
        if (this.connectionLoadBalancingPolicyClassName == null) {
            throw new IllegalStateException("Please specify a load balancing policy class name on the session factory");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(ServerLocatorImpl.this.connectionLoadBalancingPolicyClassName);
                    ServerLocatorImpl.this.loadBalancingPolicy = (ConnectionLoadBalancingPolicy)clazz.newInstance();
                    return null;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to instantiate load balancing policy \"" + ServerLocatorImpl.this.connectionLoadBalancingPolicyClassName + "\"", e);
                }
            }
        });
    }

    private synchronized void initialise() throws Exception {
        if (!this.readOnly) {
            this.setThreadPools();
            this.instantiateLoadBalancingPolicy();
            if (this.discoveryGroupConfiguration != null) {
                InetAddress groupAddress = InetAddress.getByName(this.discoveryGroupConfiguration.getGroupAddress());
                InetAddress lbAddress = this.discoveryGroupConfiguration.getLocalBindAddress() != null ? InetAddress.getByName(this.discoveryGroupConfiguration.getLocalBindAddress()) : null;
                this.discoveryGroup = new DiscoveryGroupImpl(this.nodeID, this.discoveryGroupConfiguration.getName(), lbAddress, groupAddress, this.discoveryGroupConfiguration.getGroupPort(), this.discoveryGroupConfiguration.getRefreshTimeout());
                this.discoveryGroup.registerListener(this);
                this.discoveryGroup.start();
            }
            this.readOnly = true;
        }
    }

    private ServerLocatorImpl(boolean useHA, DiscoveryGroupConfiguration discoveryGroupConfiguration, TransportConfiguration[] transportConfigs) {
        this.e.fillInStackTrace();
        this.ha = useHA;
        this.discoveryGroupConfiguration = discoveryGroupConfiguration;
        this.initialConnectors = transportConfigs;
        this.nodeID = UUIDGenerator.getInstance().generateStringUUID();
        this.clientFailureCheckPeriod = 30000L;
        this.connectionTTL = 60000L;
        this.callTimeout = 30000L;
        this.minLargeMessageSize = 102400;
        this.consumerWindowSize = 0x100000;
        this.consumerMaxRate = -1;
        this.confirmationWindowSize = -1;
        this.producerWindowSize = 65536;
        this.producerMaxRate = -1;
        this.blockOnAcknowledge = false;
        this.blockOnDurableSend = true;
        this.blockOnNonDurableSend = false;
        this.autoGroup = false;
        this.preAcknowledge = false;
        this.ackBatchSize = 0x100000;
        this.connectionLoadBalancingPolicyClassName = HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
        this.useGlobalPools = true;
        this.scheduledThreadPoolMaxSize = 5;
        this.threadPoolMaxSize = -1;
        this.retryInterval = 2000L;
        this.retryIntervalMultiplier = 1.0;
        this.maxRetryInterval = 2000L;
        this.reconnectAttempts = 0;
        this.initialConnectAttempts = 1;
        this.failoverOnInitialConnection = false;
        this.cacheLargeMessagesClient = false;
        this.initialMessagePacketSize = 1500;
        this.cacheLargeMessagesClient = false;
        this.compressLargeMessage = false;
        this.clusterConnection = false;
    }

    public ServerLocatorImpl(boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(useHA, groupConfiguration, null);
    }

    public ServerLocatorImpl(boolean useHA, TransportConfiguration ... transportConfigs) {
        this(useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
    }

    private TransportConfiguration selectConnector() {
        if (this.receivedTopology) {
            int pos = this.loadBalancingPolicy.select(this.topologyArray.length);
            Pair<TransportConfiguration, TransportConfiguration> pair = this.topologyArray[pos];
            return (TransportConfiguration)pair.a;
        }
        int pos = this.loadBalancingPolicy.select(this.initialConnectors.length);
        return this.initialConnectors[pos];
    }

    @Override
    public void start(Executor executor) throws Exception {
        this.initialise();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ServerLocatorImpl.this.connect();
                    }
                    catch (Exception e) {
                        if (ServerLocatorImpl.this.closing) break block2;
                        log.warn("did not connect the cluster connection to other nodes", e);
                    }
                }
            }
        });
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public ClientSessionFactory connect() throws Exception {
        ClientSessionFactoryInternal sf = this.initialConnectors != null && this.discoveryGroup == null ? (ClientSessionFactoryInternal)this.staticConnector.connect() : (ClientSessionFactoryInternal)this.createSessionFactory();
        this.addFactory(sf);
        return sf;
    }

    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration) throws Exception {
        if (this.closed) {
            throw new IllegalStateException("Cannot create session factory, server locator is closed (maybe it has been garbage collected)");
        }
        try {
            this.initialise();
        }
        catch (Exception e) {
            throw new HornetQException(0, "Failed to initialise session factory", e);
        }
        ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(this, transportConfiguration, this.callTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.interceptors);
        factory.connect(this.reconnectAttempts, this.failoverOnInitialConnection);
        this.addFactory(factory);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory() throws Exception {
        long timeout;
        boolean ok;
        if (this.closed) {
            throw new IllegalStateException("Cannot create session factory, server locator is closed (maybe it has been garbage collected)");
        }
        try {
            this.initialise();
        }
        catch (Exception e) {
            throw new HornetQException(0, "Failed to initialise session factory", e);
        }
        if (this.initialConnectors == null && this.discoveryGroup != null && !(ok = this.discoveryGroup.waitForBroadcast(timeout = this.clusterConnection ? 0L : this.discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout()))) {
            throw new HornetQException(3, "Timed out waiting to receive initial broadcast from cluster");
        }
        ClientSessionFactory factory = null;
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            boolean retry;
            int attempts = 0;
            do {
                retry = false;
                TransportConfiguration tc = this.selectConnector();
                try {
                    factory = new ClientSessionFactoryImpl(this, tc, this.callTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.interceptors);
                    factory.connect(this.initialConnectAttempts, this.failoverOnInitialConnection);
                }
                catch (HornetQException e) {
                    factory.close();
                    factory = null;
                    if (e.getCode() == 2) {
                        if (this.topologyArray != null && ++attempts == this.topologyArray.length) {
                            throw new HornetQException(2, "Cannot connect to server(s). Tried with all available servers.");
                        }
                        if (this.topologyArray == null && this.initialConnectors != null && attempts == this.initialConnectors.length) {
                            throw new HornetQException(2, "Cannot connect to server(s). Tried with all available servers.");
                        }
                        retry = true;
                        continue;
                    }
                    throw e;
                }
            } while (retry);
            if (this.ha) {
                long toWait;
                long now;
                long start = System.currentTimeMillis();
                for (toWait = 30000L; !this.receivedTopology && toWait > 0L; toWait -= now - start) {
                    try {
                        this.wait(toWait);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                    start = now;
                }
                if (toWait <= 0L) {
                    throw new HornetQException(3, "Timed out waiting to receive cluster topology");
                }
            }
            this.addFactory((ClientSessionFactoryInternal)factory);
            return factory;
        }
    }

    @Override
    public synchronized boolean isHA() {
        return this.ha;
    }

    @Override
    public synchronized boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public synchronized void setCacheLargeMessagesClient(boolean cached) {
        this.cacheLargeMessagesClient = cached;
    }

    @Override
    public synchronized long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public synchronized void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    @Override
    public synchronized long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public synchronized void setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.connectionTTL = connectionTTL;
    }

    @Override
    public synchronized long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public synchronized void setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.callTimeout = callTimeout;
    }

    @Override
    public synchronized int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public synchronized void setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.minLargeMessageSize = minLargeMessageSize;
    }

    @Override
    public synchronized int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public synchronized void setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.consumerWindowSize = consumerWindowSize;
    }

    @Override
    public synchronized int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public synchronized void setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.consumerMaxRate = consumerMaxRate;
    }

    @Override
    public synchronized int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public synchronized void setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Override
    public synchronized int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public synchronized void setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.producerWindowSize = producerWindowSize;
    }

    @Override
    public synchronized int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public synchronized void setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.producerMaxRate = producerMaxRate;
    }

    @Override
    public synchronized boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public synchronized void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    @Override
    public synchronized boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public synchronized void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.blockOnDurableSend = blockOnDurableSend;
    }

    @Override
    public synchronized boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public synchronized void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    @Override
    public synchronized boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public synchronized void setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.autoGroup = autoGroup;
    }

    @Override
    public synchronized boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public synchronized void setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public synchronized int getAckBatchSize() {
        return this.ackBatchSize;
    }

    @Override
    public synchronized void setAckBatchSize(int ackBatchSize) {
        this.checkWrite();
        this.ackBatchSize = ackBatchSize;
    }

    @Override
    public synchronized boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public synchronized void setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.useGlobalPools = useGlobalPools;
    }

    @Override
    public synchronized int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public synchronized void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    @Override
    public synchronized int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public synchronized void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    @Override
    public synchronized long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public synchronized void setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.retryInterval = retryInterval;
    }

    @Override
    public synchronized long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public synchronized void setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.maxRetryInterval = retryInterval;
    }

    @Override
    public synchronized double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public synchronized void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    @Override
    public synchronized int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public void setInitialConnectAttempts(int initialConnectAttempts) {
        this.checkWrite();
        this.initialConnectAttempts = initialConnectAttempts;
    }

    @Override
    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    @Override
    public synchronized boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    @Override
    public synchronized void setFailoverOnInitialConnection(boolean failover) {
        this.checkWrite();
        this.failoverOnInitialConnection = failover;
    }

    @Override
    public synchronized String getConnectionLoadBalancingPolicyClassName() {
        return this.connectionLoadBalancingPolicyClassName;
    }

    @Override
    public synchronized void setConnectionLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.checkWrite();
        this.connectionLoadBalancingPolicyClassName = loadBalancingPolicyClassName;
    }

    @Override
    public TransportConfiguration[] getStaticTransportConfigurations() {
        return this.initialConnectors;
    }

    @Override
    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.discoveryGroupConfiguration;
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public boolean removeInterceptor(Interceptor interceptor) {
        return this.interceptors.remove(interceptor);
    }

    @Override
    public synchronized int getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    @Override
    public synchronized void setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.initialMessagePacketSize = size;
    }

    @Override
    public void setGroupID(String groupID) {
        this.checkWrite();
        this.groupID = groupID;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public boolean isCompressLargeMessage() {
        return this.compressLargeMessage;
    }

    @Override
    public void setCompressLargeMessage(boolean compress) {
        this.compressLargeMessage = compress;
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set attribute on SessionFactory after it has been used");
        }
    }

    @Override
    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public void setClusterConnection(boolean clusterConnection) {
        this.clusterConnection = clusterConnection;
    }

    @Override
    public boolean isClusterConnection() {
        return this.clusterConnection;
    }

    @Override
    public TransportConfiguration getClusterTransportConfiguration() {
        return this.clusterTransportConfiguration;
    }

    @Override
    public void setClusterTransportConfiguration(TransportConfiguration tc) {
        this.clusterTransportConfiguration = tc;
    }

    @Override
    public boolean isBackup() {
        return this.backup;
    }

    @Override
    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    protected void finalize() throws Throwable {
        if (this.finalizeCheck) {
            this.close();
        }
        super.finalize();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closing = true;
        if (this.discoveryGroup != null) {
            try {
                this.discoveryGroup.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop discovery group", e);
            }
        } else {
            this.staticConnector.disconnect();
        }
        for (ClientSessionFactory factory : this.factories) {
            factory.close();
        }
        this.factories.clear();
        if (!this.useGlobalPools) {
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        log.warn("Timed out waiting for pool to terminate");
                    }
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.scheduledThreadPool != null) {
                this.scheduledThreadPool.shutdown();
                try {
                    if (!this.scheduledThreadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        log.warn("Timed out waiting for scheduled pool to terminate");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.readOnly = false;
        this.closed = true;
    }

    @Override
    public synchronized void notifyNodeDown(String nodeID) {
        boolean removed = false;
        if (!this.ha) {
            return;
        }
        removed = this.topology.removeMember(nodeID);
        if (!this.topology.isEmpty()) {
            this.updateArraysAndPairs();
            if (this.topology.nodes() == 1 && this.topology.getMember(this.nodeID) != null) {
                this.receivedTopology = false;
            }
        } else {
            this.topologyArray = null;
            this.receivedTopology = false;
        }
        if (removed) {
            for (ClusterTopologyListener listener : this.topologyListeners) {
                listener.nodeDown(nodeID);
            }
        }
    }

    @Override
    public synchronized void notifyNodeUp(String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
        if (!this.ha) {
            return;
        }
        this.topology.addMember(nodeID, new TopologyMember(connectorPair));
        TopologyMember actMember = this.topology.getMember(nodeID);
        if (actMember.getConnector().a != null && actMember.getConnector().b != null) {
            for (ClientSessionFactory factory : this.factories) {
                ((ClientSessionFactoryInternal)factory).setBackupConnector((TransportConfiguration)actMember.getConnector().a, (TransportConfiguration)actMember.getConnector().b);
            }
        }
        if (connectorPair.a != null) {
            this.updateArraysAndPairs();
        }
        if (last) {
            this.receivedTopology = true;
        }
        for (ClusterTopologyListener listener : this.topologyListeners) {
            listener.nodeUP(nodeID, connectorPair, last);
        }
        this.notify();
    }

    private void updateArraysAndPairs() {
        this.topologyArray = (Pair[])Array.newInstance(Pair.class, this.topology.members());
        int count = 0;
        for (TopologyMember pair : this.topology.getMembers()) {
            this.topologyArray[count++] = pair.getConnector();
        }
    }

    @Override
    public synchronized void connectorsChanged() {
        List<DiscoveryEntry> newConnectors = this.discoveryGroup.getDiscoveryEntries();
        this.initialConnectors = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, newConnectors.size());
        int count = 0;
        for (DiscoveryEntry entry : newConnectors) {
            this.initialConnectors[count++] = entry.getConnector();
        }
        if (this.ha && this.clusterConnection && !this.receivedTopology && this.initialConnectors.length > 0) {
            try {
                this.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void factoryClosed(ClientSessionFactory factory) {
        this.factories.remove(factory);
        if (this.factories.isEmpty()) {
            this.receivedTopology = false;
            this.topology = null;
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        this.topologyListeners.add(listener);
        if (this.topology.members() > 0) {
            log.debug("ServerLocatorImpl.addClusterTopologyListener");
        }
    }

    @Override
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        this.topologyListeners.remove(listener);
    }

    public synchronized void addFactory(ClientSessionFactoryInternal factory) {
        if (factory != null) {
            TransportConfiguration backup = this.topology.getBackupForConnector(factory.getConnectorConfiguration());
            factory.setBackupConnector(factory.getConnectorConfiguration(), backup);
            this.factories.add(factory);
        }
    }

    public static void shutdown() {
        if (globalScheduledThreadPool != null) {
            globalScheduledThreadPool.shutdown();
            globalScheduledThreadPool = null;
        }
        if (globalThreadPool != null) {
            globalThreadPool.shutdown();
            globalThreadPool = null;
        }
    }

    static {
        finalizeCallback = null;
    }

    class StaticConnector
    implements Serializable {
        private List<Connector> connectors;

        StaticConnector() {
        }

        public ClientSessionFactory connect() throws HornetQException {
            if (ServerLocatorImpl.this.closed) {
                throw new IllegalStateException("Cannot create session factory, server locator is closed (maybe it has been garbage collected)");
            }
            try {
                ServerLocatorImpl.this.initialise();
            }
            catch (Exception e) {
                throw new HornetQException(0, "Failed to initialise session factory", e);
            }
            ClientSessionFactory csf = null;
            this.createConnectors();
            try {
                List futures = ServerLocatorImpl.this.threadPool.invokeAll(this.connectors);
                int futuresSize = futures.size();
                for (int i = 0; i < futuresSize; ++i) {
                    Future future = futures.get(i);
                    try {
                        csf = (ClientSessionFactory)future.get();
                        if (csf == null) continue;
                        break;
                    }
                    catch (Exception e) {
                        log.debug("unable to connect with static connector " + this.connectors.get(i).initialConnector);
                    }
                }
                if (csf == null && !ServerLocatorImpl.this.closed) {
                    throw new HornetQException(2, "Failed to connect to any static connectors");
                }
            }
            catch (InterruptedException e) {
                throw new HornetQException(2, "Failed to connect to any static connectors", e);
            }
            if (csf == null && !ServerLocatorImpl.this.closed) {
                throw new HornetQException(2, "Failed to connect to any static connectors");
            }
            return csf;
        }

        private synchronized void createConnectors() {
            this.connectors = new ArrayList<Connector>();
            for (TransportConfiguration initialConnector : ServerLocatorImpl.this.initialConnectors) {
                ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(ServerLocatorImpl.this, initialConnector, ServerLocatorImpl.this.callTimeout, ServerLocatorImpl.this.clientFailureCheckPeriod, ServerLocatorImpl.this.connectionTTL, ServerLocatorImpl.this.retryInterval, ServerLocatorImpl.this.retryIntervalMultiplier, ServerLocatorImpl.this.maxRetryInterval, ServerLocatorImpl.this.reconnectAttempts, ServerLocatorImpl.this.threadPool, ServerLocatorImpl.this.scheduledThreadPool, ServerLocatorImpl.this.interceptors);
                this.connectors.add(new Connector(initialConnector, factory));
            }
        }

        public synchronized void disconnect() {
            if (this.connectors != null) {
                for (Connector connector : this.connectors) {
                    connector.disconnect();
                }
            }
        }

        public void finalize() throws Throwable {
            if (!ServerLocatorImpl.this.closed && ServerLocatorImpl.this.finalizeCheck) {
                log.warn("I'm closing a core ServerLocator you left open. Please make sure you close all ServerLocators explicitly before letting them go out of scope! " + System.identityHashCode(this));
                log.warn("The ServerLocator you didn't close was created here:", ServerLocatorImpl.this.e);
                if (finalizeCallback != null) {
                    finalizeCallback.run();
                }
                ServerLocatorImpl.this.close();
            }
            super.finalize();
        }

        class Connector
        implements Callable<ClientSessionFactory> {
            private TransportConfiguration initialConnector;
            private volatile ClientSessionFactoryInternal factory;
            private boolean isConnected = false;
            private boolean interrupted = false;
            private Exception e;

            public Connector(TransportConfiguration initialConnector, ClientSessionFactoryInternal factory) {
                this.initialConnector = initialConnector;
                this.factory = factory;
            }

            @Override
            public ClientSessionFactory call() throws HornetQException {
                try {
                    this.factory.connect(ServerLocatorImpl.this.reconnectAttempts, ServerLocatorImpl.this.failoverOnInitialConnection);
                }
                catch (HornetQException e) {
                    if (!this.interrupted) {
                        this.e = e;
                        throw e;
                    }
                    return null;
                }
                this.isConnected = true;
                for (Connector connector : StaticConnector.this.connectors) {
                    if (connector.isConnected()) continue;
                    connector.disconnect();
                }
                return this.factory;
            }

            public boolean isConnected() {
                return this.isConnected;
            }

            public void disconnect() {
                this.interrupted = true;
                if (this.factory != null) {
                    this.factory.causeExit();
                    this.factory.close();
                    this.factory = null;
                }
            }
        }
    }
}

