/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.TopologyMember;
import org.hornetq.core.logging.Logger;

public class Topology
implements Serializable {
    private static final long serialVersionUID = -9037171688692471371L;
    private static final Logger log = Logger.getLogger(Topology.class);
    private Map<String, TopologyMember> topology = new HashMap<String, TopologyMember>();
    private boolean debug;

    public synchronized boolean addMember(String nodeId, TopologyMember member) {
        boolean replaced = false;
        TopologyMember currentMember = this.topology.get(nodeId);
        if (this.debug) {
            System.out.println("adding = " + nodeId + ":" + member.getConnector());
            System.out.println("before----------------------------------");
            System.out.println(this.describe());
        }
        if (currentMember == null) {
            this.topology.put(nodeId, member);
            replaced = true;
        } else {
            if (this.hasChanged((TransportConfiguration)currentMember.getConnector().a, (TransportConfiguration)member.getConnector().a) && member.getConnector().a != null) {
                currentMember.getConnector().a = member.getConnector().a;
                replaced = true;
            }
            if (this.hasChanged((TransportConfiguration)currentMember.getConnector().b, (TransportConfiguration)member.getConnector().b) && member.getConnector().b != null) {
                currentMember.getConnector().b = member.getConnector().b;
                replaced = true;
            }
            if (member.getConnector().a == null) {
                member.getConnector().a = currentMember.getConnector().a;
            }
            if (member.getConnector().b == null) {
                member.getConnector().b = currentMember.getConnector().b;
            }
        }
        if (this.debug) {
            System.out.println("after----------------------------------updated=" + replaced);
            System.out.println(this.describe());
        }
        return replaced;
    }

    public synchronized boolean removeMember(String nodeId) {
        TopologyMember member = this.topology.remove(nodeId);
        return member != null;
    }

    public void sendTopology(ClusterTopologyListener listener) {
        int count = 0;
        HashMap<String, TopologyMember> copy = new HashMap<String, TopologyMember>(this.topology);
        for (Map.Entry entry : copy.entrySet()) {
            listener.nodeUP((String)entry.getKey(), ((TopologyMember)entry.getValue()).getConnector(), ++count == copy.size());
        }
    }

    public TopologyMember getMember(String nodeID) {
        return this.topology.get(nodeID);
    }

    public boolean isEmpty() {
        return this.topology.isEmpty();
    }

    public Collection<TopologyMember> getMembers() {
        return this.topology.values();
    }

    public int nodes() {
        int count = 0;
        for (TopologyMember member : this.topology.values()) {
            if (member.getConnector().a != null) {
                ++count;
            }
            if (member.getConnector().b == null) continue;
            ++count;
        }
        return count;
    }

    public String describe() {
        String desc = "";
        for (Map.Entry<String, TopologyMember> entry : new HashMap<String, TopologyMember>(this.topology).entrySet()) {
            desc = desc + "\t" + entry.getKey() + " => " + entry.getValue() + "\n";
        }
        desc = desc + "\tnodes=" + this.nodes() + "\t" + "members=" + this.members();
        return desc;
    }

    public void clear() {
        this.topology.clear();
    }

    public int members() {
        return this.topology.size();
    }

    private boolean hasChanged(TransportConfiguration currentConnector, TransportConfiguration connector) {
        return currentConnector == null && connector != null || currentConnector != null && !currentConnector.equals(connector);
    }

    public TransportConfiguration getBackupForConnector(TransportConfiguration connectorConfiguration) {
        for (TopologyMember member : this.topology.values()) {
            if (member.getConnector().a == null || !((TransportConfiguration)member.getConnector().a).equals(connectorConfiguration)) continue;
            return (TransportConfiguration)member.getConnector().b;
        }
        return null;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }
}

