/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.MessageCounterInfo;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.impl.MessageCounterHelper;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.utils.LinkedListIterator;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class QueueControlImpl
extends AbstractControl
implements QueueControl {
    private static final Logger log = Logger.getLogger(QueueControlImpl.class);
    private final Queue queue;
    private final String address;
    private final PostOffice postOffice;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private MessageCounter counter;

    private static String toJSON(Map<String, Object>[] messages) {
        JSONArray array = new JSONArray();
        for (Map<String, Object> message : messages) {
            array.put(new JSONObject(message));
        }
        return array.toString();
    }

    public QueueControlImpl(Queue queue, String address, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        super(QueueControl.class, storageManager);
        this.queue = queue;
        this.address = address;
        this.postOffice = postOffice;
        this.addressSettingsRepository = addressSettingsRepository;
    }

    public void setMessageCounter(MessageCounter counter) {
        this.counter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        this.clearIO();
        try {
            String string = this.queue.getName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getAddress() {
        this.checkStarted();
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFilter() {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = this.queue.getFilter();
            String string = filter != null ? filter.getFilterString().toString() : null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDurable() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isDurable();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary() {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isTemporary();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMessageCount() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessageCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConsumerCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getConsumerCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDeliveringCount() {
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.queue.getDeliveringCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMessagesAdded() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getMessagesAdded();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getID() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getID();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getScheduledCount() {
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.queue.getScheduledCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeadLetterAddress() {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getDeadLetterAddress() != null) {
                String string = addressSettings.getDeadLetterAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeadLetterAddress(String deadLetterAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (deadLetterAddress != null) {
                addressSettings.setDeadLetterAddress(new SimpleString(deadLetterAddress));
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getExpiryAddress() {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            if (addressSettings != null && addressSettings.getExpiryAddress() != null) {
                String string = addressSettings.getExpiryAddress().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpiryAddress(String expiryAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address);
            SimpleString sExpiryAddress = new SimpleString(expiryAddress);
            if (expiryAddress != null) {
                addressSettings.setExpiryAddress(sExpiryAddress);
            }
            this.queue.setExpiryAddress(sExpiryAddress);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object>[] listScheduledMessages() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            List<MessageReference> refs = this.queue.getScheduledMessages();
            Map[] messages = new Map[refs.size()];
            int i = 0;
            for (MessageReference ref : refs) {
                ServerMessage message = ref.getMessage();
                messages[i++] = message.toMap();
            }
            Map[] mapArray = messages;
            return mapArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listScheduledMessagesAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listScheduledMessages());
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object>[] listMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            ArrayList<Map<String, Object>> messages = new ArrayList<Map<String, Object>>();
            this.queue.blockOnExecutorFuture();
            LinkedListIterator<MessageReference> iterator = this.queue.iterator();
            try {
                while (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    if (filter != null && !filter.match(ref.getMessage())) continue;
                    ServerMessage message = ref.getMessage();
                    messages.add(message.toMap());
                }
                Map[] mapArray = messages.toArray(new Map[messages.size()]);
                iterator.close();
                return mapArray;
            }
            catch (Throwable throwable) {
                try {
                    iterator.close();
                    throw throwable;
                }
                catch (HornetQException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listMessagesAsJSON(String filter) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = QueueControlImpl.toJSON(this.listMessages(filter));
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            if (filter == null) {
                long l = this.getMessageCount();
                return l;
            }
            LinkedListIterator<MessageReference> iterator = this.queue.iterator();
            try {
                int count = 0;
                while (iterator.hasNext()) {
                    MessageReference ref = (MessageReference)iterator.next();
                    if (!filter.match(ref.getMessage())) continue;
                    ++count;
                }
                long l = count;
                iterator.close();
                return l;
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean removeMessage(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.deleteReference(messageID);
            return bl;
        }
        catch (HornetQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.deleteMatchingReferences(filter);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expireMessage(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.expireReference(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int expireMessages(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.expireReferences(filter);
            return n;
        }
        catch (HornetQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean moveMessage(long messageID, String otherQueueName) throws Exception {
        return this.moveMessage(messageID, otherQueueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveMessage(long messageID, String otherQueueName, boolean rejectDuplicates) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Binding binding = this.postOffice.getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw new IllegalArgumentException("No queue found for " + otherQueueName);
            }
            boolean bl = this.queue.moveReference(messageID, binding.getAddress(), rejectDuplicates);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int moveMessages(String filterStr, String otherQueueName) throws Exception {
        return this.moveMessages(filterStr, otherQueueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveMessages(String filterStr, String otherQueueName, boolean rejectDuplicates) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            int retValue;
            Filter filter = FilterImpl.createFilter(filterStr);
            Binding binding = this.postOffice.getBinding(new SimpleString(otherQueueName));
            if (binding == null) {
                throw new IllegalArgumentException("No queue found for " + otherQueueName);
            }
            int n = retValue = this.queue.moveReferences(filter, binding.getAddress(), rejectDuplicates);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.sendMessagesToDeadLetterAddress(filter);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.sendMessageToDeadLetterAddress(messageID);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int changeMessagesPriority(String filterStr, int newPriority) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw new IllegalArgumentException("invalid newPriority value: " + newPriority + ". It must be between 0 and 9 (both included)");
            }
            Filter filter = FilterImpl.createFilter(filterStr);
            int n = this.queue.changeReferencesPriority(filter, (byte)newPriority);
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeMessagePriority(long messageID, int newPriority) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (newPriority < 0 || newPriority > 9) {
                throw new IllegalArgumentException("invalid newPriority value: " + newPriority + ". It must be between 0 and 9 (both included)");
            }
            boolean bl = this.queue.changeReferencePriority(messageID, (byte)newPriority);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String listMessageCounter() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterInfo.toJSon(this.counter);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetMessageCounter() {
        this.checkStarted();
        this.clearIO();
        try {
            this.counter.resetCounter();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listMessageCounterAsHTML() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listMessageCounterHistory() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistory(this.counter);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listMessageCounterHistoryAsHTML() {
        this.checkStarted();
        this.clearIO();
        try {
            String string = MessageCounterHelper.listMessageCounterHistoryAsHTML(new MessageCounter[]{this.counter});
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.pause();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.checkStarted();
        this.clearIO();
        try {
            this.queue.resume();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaused() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.queue.isPaused();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listConsumersAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Collection<Consumer> consumers = this.queue.getConsumers();
            JSONArray jsonArray = new JSONArray();
            for (Consumer consumer : consumers) {
                if (!(consumer instanceof ServerConsumer)) continue;
                ServerConsumer serverConsumer = (ServerConsumer)consumer;
                JSONObject obj = new JSONObject();
                obj.put("consumerID", serverConsumer.getID());
                obj.put("connectionID", serverConsumer.getConnectionID().toString());
                obj.put("sessionID", serverConsumer.getSessionID());
                obj.put("browseOnly", serverConsumer.isBrowseOnly());
                obj.put("creationTime", serverConsumer.getCreationTime());
                jsonArray.put(obj);
            }
            String string = jsonArray.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(QueueControl.class);
    }

    private void checkStarted() {
        if (!this.postOffice.isStarted()) {
            throw new IllegalStateException("HornetQ Server is not started. Queue can not be managed yet");
        }
    }
}

