/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor.impl;

import java.util.LinkedList;
import java.util.List;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.cursor.LivePageCache;

public class LivePageCacheImpl
implements LivePageCache {
    private final List<PagedMessage> messages = new LinkedList<PagedMessage>();
    private final Page page;
    private boolean isLive = true;

    public String toString() {
        return "LivePacheCacheImpl::page=" + this.page.getPageId() + " number of messages=" + this.messages.size() + " isLive = " + this.isLive;
    }

    public LivePageCacheImpl(Page page) {
        this.page = page;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public long getPageId() {
        return this.page.getPageId();
    }

    @Override
    public synchronized int getNumberOfMessages() {
        return this.messages.size();
    }

    @Override
    public synchronized void setMessages(PagedMessage[] messages) {
        for (PagedMessage msg : messages) {
            this.addLiveMessage(msg);
        }
    }

    @Override
    public synchronized PagedMessage getMessage(int messageNumber) {
        if (messageNumber < this.messages.size()) {
            return this.messages.get(messageNumber);
        }
        return null;
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public synchronized boolean isLive() {
        return this.isLive;
    }

    @Override
    public synchronized void addLiveMessage(PagedMessage message) {
        this.messages.add(message);
    }

    @Override
    public synchronized void close() {
        this.isLive = false;
    }
}

