/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.transaction.ResourceManager;

public interface StorageManager
extends HornetQComponent {
    public OperationContext getContext();

    public OperationContext newContext(Executor var1);

    public OperationContext newSingleThreadContext();

    public void setContext(OperationContext var1);

    public void pageClosed(SimpleString var1, int var2);

    public void pageDeleted(SimpleString var1, int var2);

    public void pageWrite(PagedMessage var1, int var2);

    public boolean isReplicated();

    public void afterCompleteOperations(IOAsyncTask var1);

    public boolean waitOnOperations(long var1) throws Exception;

    public void waitOnOperations() throws Exception;

    public void clearContext();

    public long generateUniqueID();

    public long getCurrentUniqueID();

    public void storeMessage(ServerMessage var1) throws Exception;

    public void storeReference(long var1, long var3, boolean var5) throws Exception;

    public void deleteMessage(long var1) throws Exception;

    public void storeAcknowledge(long var1, long var3) throws Exception;

    public void storeCursorAcknowledge(long var1, PagePosition var3) throws Exception;

    public void updateDeliveryCount(MessageReference var1) throws Exception;

    public void updateScheduledDeliveryTime(MessageReference var1) throws Exception;

    public void storeDuplicateID(SimpleString var1, byte[] var2, long var3) throws Exception;

    public void deleteDuplicateID(long var1) throws Exception;

    public void storeMessageTransactional(long var1, ServerMessage var3) throws Exception;

    public void storeReferenceTransactional(long var1, long var3, long var5) throws Exception;

    public void storeAcknowledgeTransactional(long var1, long var3, long var5) throws Exception;

    public void storeCursorAcknowledgeTransactional(long var1, long var3, PagePosition var5) throws Exception;

    public void deleteCursorAcknowledgeTransactional(long var1, long var3) throws Exception;

    public void updateScheduledDeliveryTimeTransactional(long var1, MessageReference var3) throws Exception;

    public void deleteMessageTransactional(long var1, long var3, long var5) throws Exception;

    public void storeDuplicateIDTransactional(long var1, SimpleString var3, byte[] var4, long var5) throws Exception;

    public void updateDuplicateIDTransactional(long var1, SimpleString var3, byte[] var4, long var5) throws Exception;

    public void deleteDuplicateIDTransactional(long var1, long var3) throws Exception;

    public LargeServerMessage createLargeMessage();

    public LargeServerMessage createLargeMessage(long var1, MessageInternal var3);

    public void prepare(long var1, Xid var3) throws Exception;

    public void commit(long var1) throws Exception;

    public void rollback(long var1) throws Exception;

    public void storePageTransaction(long var1, PageTransactionInfo var3) throws Exception;

    public void updatePageTransaction(long var1, PageTransactionInfo var3, int var4) throws Exception;

    public void updatePageTransaction(PageTransactionInfo var1, int var2) throws Exception;

    public void deletePageTransactional(long var1) throws Exception;

    public JournalLoadInformation[] loadInternalOnly() throws Exception;

    public JournalLoadInformation loadMessageJournal(PostOffice var1, PagingManager var2, ResourceManager var3, Map<Long, Queue> var4, Map<Long, QueueBindingInfo> var5, Map<SimpleString, List<Pair<byte[], Long>>> var6) throws Exception;

    public long storeHeuristicCompletion(Xid var1, boolean var2) throws Exception;

    public void deleteHeuristicCompletion(long var1) throws Exception;

    public void addQueueBinding(Binding var1) throws Exception;

    public void deleteQueueBinding(long var1) throws Exception;

    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> var1, List<GroupingInfo> var2) throws Exception;

    public void addGrouping(GroupBinding var1) throws Exception;

    public void deleteGrouping(GroupBinding var1) throws Exception;

    public void storeAddressSetting(PersistedAddressSetting var1) throws Exception;

    public void deleteAddressSetting(SimpleString var1) throws Exception;

    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception;

    public void storeSecurityRoles(PersistedRoles var1) throws Exception;

    public void deleteSecurityRoles(SimpleString var1) throws Exception;

    public List<PersistedRoles> recoverPersistedRoles() throws Exception;

    public long storePageCounter(long var1, long var3, long var5) throws Exception;

    public void deleteIncrementRecord(long var1, long var3) throws Exception;

    public void deletePageCounter(long var1, long var3) throws Exception;

    public long storePageCounterInc(long var1, long var3, int var5) throws Exception;

    public long storePageCounterInc(long var1, int var3) throws Exception;
}

