/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.impl.SimpleWaitIOCallback;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.utils.ExecutorFactory;

public class OperationContextImpl
implements OperationContext {
    private static final Logger log = Logger.getLogger(OperationContextImpl.class);
    private static final ThreadLocal<OperationContext> threadLocalContext = new ThreadLocal();
    private List<TaskHolder> tasks;
    private int minimalStore = Integer.MAX_VALUE;
    private int minimalReplicated = Integer.MAX_VALUE;
    private int minimalPage = Integer.MAX_VALUE;
    private volatile int storeLineUp = 0;
    private volatile int replicationLineUp = 0;
    private volatile int pageLineUp = 0;
    private int stored = 0;
    private int replicated = 0;
    private int paged = 0;
    private int errorCode = -1;
    private String errorMessage = null;
    private final Executor executor;
    private final AtomicInteger executorsPending = new AtomicInteger(0);

    public static void clearContext() {
        threadLocalContext.set(null);
    }

    public static OperationContext getContext() {
        return OperationContextImpl.getContext(null);
    }

    public static OperationContext getContext(ExecutorFactory executorFactory) {
        OperationContext token = threadLocalContext.get();
        if (token == null) {
            if (executorFactory == null) {
                return null;
            }
            token = new OperationContextImpl(executorFactory.getExecutor());
            threadLocalContext.set(token);
        }
        return token;
    }

    public static void setContext(OperationContext context) {
        threadLocalContext.set(context);
    }

    public OperationContextImpl(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void pageSyncLineUp() {
        ++this.pageLineUp;
    }

    @Override
    public synchronized void pageSyncDone() {
        ++this.paged;
        this.checkTasks();
    }

    @Override
    public void storeLineUp() {
        ++this.storeLineUp;
    }

    @Override
    public void replicationLineUp() {
        ++this.replicationLineUp;
    }

    @Override
    public synchronized void replicationDone() {
        ++this.replicated;
        this.checkTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOnCompletion(IOAsyncTask completion) {
        if (this.errorCode != -1) {
            completion.onError(this.errorCode, this.errorMessage);
            return;
        }
        boolean executeNow = false;
        OperationContextImpl operationContextImpl = this;
        synchronized (operationContextImpl) {
            if (this.tasks == null) {
                this.tasks = new LinkedList<TaskHolder>();
                this.minimalReplicated = this.replicationLineUp;
                this.minimalStore = this.storeLineUp;
                this.minimalPage = this.pageLineUp;
            }
            if (this.replicationLineUp == this.replicated && this.storeLineUp == this.stored && this.pageLineUp == this.paged) {
                if (this.executorsPending.get() == 0) {
                    executeNow = true;
                } else {
                    this.execute(completion);
                }
            } else {
                this.tasks.add(new TaskHolder(completion));
            }
        }
        if (executeNow) {
            completion.done();
        }
    }

    @Override
    public synchronized void done() {
        ++this.stored;
        this.checkTasks();
    }

    private void checkTasks() {
        if (this.stored >= this.minimalStore && this.replicated >= this.minimalReplicated && this.paged >= this.minimalPage) {
            Iterator<TaskHolder> iter = this.tasks.iterator();
            while (iter.hasNext()) {
                TaskHolder holder = iter.next();
                if (this.stored < holder.storeLined || this.replicated < holder.replicationLined || this.paged < holder.pageLined) break;
                this.execute(holder.task);
                iter.remove();
            }
        }
    }

    private void execute(final IOAsyncTask task) {
        this.executorsPending.incrementAndGet();
        try {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        OperationContextImpl.clearContext();
                        task.done();
                    }
                    finally {
                        OperationContextImpl.this.executorsPending.decrementAndGet();
                    }
                }
            });
        }
        catch (Throwable e) {
            log.warn("Error on executor's submit", e);
            this.executorsPending.decrementAndGet();
            task.onError(0, "It wasn't possible to complete IO operation - " + e.getMessage());
        }
    }

    public void complete() {
    }

    @Override
    public synchronized void onError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        if (this.tasks != null) {
            Iterator<TaskHolder> iter = this.tasks.iterator();
            while (iter.hasNext()) {
                TaskHolder holder = iter.next();
                holder.task.onError(errorCode, errorMessage);
                iter.remove();
            }
        }
    }

    @Override
    public void waitCompletion() throws Exception {
        this.waitCompletion(0L);
    }

    @Override
    public boolean waitCompletion(long timeout) throws Exception {
        SimpleWaitIOCallback waitCallback = new SimpleWaitIOCallback();
        this.executeOnCompletion(waitCallback);
        this.complete();
        if (timeout == 0L) {
            waitCallback.waitCompletion();
            return true;
        }
        return waitCallback.waitCompletion(timeout);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (TaskHolder hold : this.tasks) {
            buffer.append("Task = " + hold + "\n");
        }
        return "OperationContextImpl [minimalStore=" + this.minimalStore + ", storeLineUp=" + this.storeLineUp + ", stored=" + this.stored + ", minimalReplicated=" + this.minimalReplicated + ", replicationLineUp=" + this.replicationLineUp + ", replicated=" + this.replicated + ", paged=" + this.paged + ", minimalPage=" + this.minimalPage + ", pageLineUp=" + this.pageLineUp + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", executorsPending=" + this.executorsPending + ", executor=" + this.executor + "]" + buffer.toString();
    }

    class TaskHolder {
        int storeLined;
        int replicationLined;
        int pageLined;
        IOAsyncTask task;

        public String toString() {
            return "TaskHolder [storeLined=" + this.storeLined + ", replicationLined=" + this.replicationLined + ", pageLined=" + this.pageLined + ", task=" + this.task + "]";
        }

        TaskHolder(IOAsyncTask task) {
            this.storeLined = OperationContextImpl.this.storeLineUp;
            this.replicationLined = OperationContextImpl.this.replicationLineUp;
            this.pageLined = OperationContextImpl.this.pageLineUp;
            this.task = task;
        }
    }
}

