/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.stomp.StompException;
import org.hornetq.core.protocol.stomp.StompFrame;

public class StompDecoder {
    private static final Logger log = Logger.getLogger(StompDecoder.class);
    private static final boolean TRIM_LEADING_HEADER_VALUE_WHITESPACE = true;
    private static final String COMMAND_ABORT = "ABORT";
    private static final int COMMAND_ABORT_LENGTH = "ABORT".length();
    private static final String COMMAND_ACK = "ACK";
    private static final int COMMAND_ACK_LENGTH = "ACK".length();
    private static final String COMMAND_BEGIN = "BEGIN";
    private static final int COMMAND_BEGIN_LENGTH = "BEGIN".length();
    private static final String COMMAND_COMMIT = "COMMIT";
    private static final int COMMAND_COMMIT_LENGTH = "COMMIT".length();
    private static final String COMMAND_CONNECT = "CONNECT";
    private static final int COMMAND_CONNECT_LENGTH = "CONNECT".length();
    private static final String COMMAND_DISCONNECT = "DISCONNECT";
    private static final int COMMAND_DISCONNECT_LENGTH = "DISCONNECT".length();
    private static final String COMMAND_SEND = "SEND";
    private static final int COMMAND_SEND_LENGTH = "SEND".length();
    private static final String COMMAND_SUBSCRIBE = "SUBSCRIBE";
    private static final int COMMAND_SUBSCRIBE_LENGTH = "SUBSCRIBE".length();
    private static final String COMMAND_UNSUBSCRIBE = "UNSUBSCRIBE";
    private static final int COMMAND_UNSUBSCRIBE_LENGTH = "UNSUBSCRIBE".length();
    private static final byte A = 65;
    private static final byte B = 66;
    private static final byte C = 67;
    private static final byte D = 68;
    private static final byte E = 69;
    private static final byte M = 77;
    private static final byte S = 83;
    private static final byte U = 85;
    private static final byte HEADER_SEPARATOR = 58;
    private static final byte NEW_LINE = 10;
    private static final byte SPACE = 32;
    private static final byte TAB = 9;
    private static String CONTENT_LENGTH_HEADER_NAME = "content-length";
    private byte[] workingBuffer = new byte[1024];
    private int pos;
    private int data;
    private String command;
    private Map<String, Object> headers;
    private int headerBytesCopyStart;
    private boolean readingHeaders;
    private boolean headerValueWhitespace;
    private boolean inHeaderName;
    private String headerName;
    private boolean whiteSpaceOnly;
    private int contentLength;
    private int bodyStart;

    public StompDecoder() {
        this.init();
    }

    public boolean hasBytes() {
        return this.data > this.pos;
    }

    public synchronized StompFrame decode(HornetQBuffer buffer) throws Exception {
        byte[] content;
        long headersTime;
        long commandTime;
        long start;
        block43: {
            block42: {
                block41: {
                    start = System.nanoTime();
                    int readable = buffer.readableBytes();
                    if (this.data + readable >= this.workingBuffer.length) {
                        this.resizeWorking(this.data + readable);
                    }
                    buffer.readBytes(this.workingBuffer, this.data, readable);
                    this.data += readable;
                    if (this.command == null) {
                        if (this.data < 4) {
                            return null;
                        }
                        int offset = this.workingBuffer[0] == 10 ? 1 : 0;
                        byte b = this.workingBuffer[offset];
                        switch (b) {
                            case 65: {
                                if (this.workingBuffer[offset + 1] == 66) {
                                    if (!this.tryIncrement(offset + COMMAND_ABORT_LENGTH + 1)) {
                                        return null;
                                    }
                                    this.command = COMMAND_ABORT;
                                    break;
                                }
                                if (!this.tryIncrement(offset + COMMAND_ACK_LENGTH + 1)) {
                                    return null;
                                }
                                this.command = COMMAND_ACK;
                                break;
                            }
                            case 66: {
                                if (!this.tryIncrement(offset + COMMAND_BEGIN_LENGTH + 1)) {
                                    return null;
                                }
                                this.command = COMMAND_BEGIN;
                                break;
                            }
                            case 67: {
                                if (this.workingBuffer[offset + 2] == 77) {
                                    if (!this.tryIncrement(offset + COMMAND_COMMIT_LENGTH + 1)) {
                                        return null;
                                    }
                                    this.command = COMMAND_COMMIT;
                                    break;
                                }
                                if (!this.tryIncrement(offset + COMMAND_CONNECT_LENGTH + 1)) {
                                    return null;
                                }
                                this.command = COMMAND_CONNECT;
                                break;
                            }
                            case 68: {
                                if (!this.tryIncrement(offset + COMMAND_DISCONNECT_LENGTH + 1)) {
                                    return null;
                                }
                                this.command = COMMAND_DISCONNECT;
                                break;
                            }
                            case 83: {
                                if (this.workingBuffer[offset + 1] == 69) {
                                    if (!this.tryIncrement(offset + COMMAND_SEND_LENGTH + 1)) {
                                        return null;
                                    }
                                    this.command = COMMAND_SEND;
                                    break;
                                }
                                if (!this.tryIncrement(offset + COMMAND_SUBSCRIBE_LENGTH + 1)) {
                                    return null;
                                }
                                this.command = COMMAND_SUBSCRIBE;
                                break;
                            }
                            case 85: {
                                if (!this.tryIncrement(offset + COMMAND_UNSUBSCRIBE_LENGTH + 1)) {
                                    return null;
                                }
                                this.command = COMMAND_UNSUBSCRIBE;
                                break;
                            }
                            default: {
                                this.throwInvalid();
                            }
                        }
                        if (this.workingBuffer[this.pos - 1] != 10) {
                            this.throwInvalid();
                        }
                    }
                    commandTime = System.nanoTime() - start;
                    if (this.readingHeaders) {
                        if (this.headerBytesCopyStart == -1) {
                            this.headerBytesCopyStart = this.pos;
                        }
                        block13: do {
                            byte b = this.workingBuffer[this.pos++];
                            switch (b) {
                                case 58: {
                                    byte[] data;
                                    if (this.inHeaderName) {
                                        data = new byte[this.pos - this.headerBytesCopyStart - 1];
                                        System.arraycopy(this.workingBuffer, this.headerBytesCopyStart, data, 0, data.length);
                                        this.headerName = new String(data);
                                        this.inHeaderName = false;
                                        this.headerBytesCopyStart = this.pos;
                                        this.headerValueWhitespace = true;
                                    }
                                    this.whiteSpaceOnly = false;
                                    break;
                                }
                                case 10: {
                                    if (this.whiteSpaceOnly) {
                                        this.readingHeaders = false;
                                        break block41;
                                    }
                                    byte[] data = new byte[this.pos - this.headerBytesCopyStart - 1];
                                    System.arraycopy(this.workingBuffer, this.headerBytesCopyStart, data, 0, data.length);
                                    String headerValue = new String(data);
                                    this.headers.put(this.headerName, headerValue);
                                    if (this.headerName.equals(CONTENT_LENGTH_HEADER_NAME)) {
                                        this.contentLength = Integer.parseInt(headerValue.toString());
                                    }
                                    this.whiteSpaceOnly = true;
                                    this.headerBytesCopyStart = this.pos;
                                    this.inHeaderName = true;
                                    this.headerValueWhitespace = false;
                                    break;
                                }
                                case 9: 
                                case 32: {
                                    if (!this.headerValueWhitespace) continue block13;
                                    ++this.headerBytesCopyStart;
                                    break;
                                }
                                default: {
                                    this.whiteSpaceOnly = false;
                                    this.headerValueWhitespace = false;
                                }
                            }
                        } while (this.pos != this.data);
                        return null;
                    }
                }
                headersTime = System.nanoTime() - start - commandTime;
                content = null;
                if (this.contentLength == -1) break block42;
                if (this.pos + this.contentLength + 1 > this.data) break block43;
                content = new byte[this.contentLength];
                System.arraycopy(this.workingBuffer, this.pos, content, 0, this.contentLength);
                this.pos += this.contentLength + 1;
                break block43;
            }
            if (this.bodyStart == -1) {
                this.bodyStart = this.pos;
            }
            while (this.pos < this.data) {
                if (this.workingBuffer[this.pos++] != 0) continue;
                content = new byte[this.pos - this.bodyStart - 1];
                System.arraycopy(this.workingBuffer, this.bodyStart, content, 0, content.length);
                break;
            }
        }
        if (content != null) {
            if (this.data > this.pos) {
                if (this.workingBuffer[this.pos] == 10) {
                    ++this.pos;
                }
                if (this.data > this.pos) {
                    System.arraycopy(this.workingBuffer, this.pos, this.workingBuffer, 0, this.data - this.pos);
                }
            }
            this.data -= this.pos;
            StompFrame ret = new StompFrame(this.command, this.headers, content);
            this.init();
            long bodyTime = System.nanoTime() - start - headersTime - commandTime;
            return ret;
        }
        return null;
    }

    private void throwInvalid() throws StompException {
        throw new StompException("Invalid STOMP frame: " + this.dumpByteArray(this.workingBuffer));
    }

    private void init() {
        this.pos = 0;
        this.command = null;
        this.headers = new HashMap<String, Object>();
        this.headerBytesCopyStart = -1;
        this.readingHeaders = true;
        this.inHeaderName = true;
        this.headerValueWhitespace = false;
        this.headerName = null;
        this.whiteSpaceOnly = true;
        this.contentLength = -1;
        this.bodyStart = -1;
    }

    private void resizeWorking(int newSize) {
        byte[] oldBuffer = this.workingBuffer;
        this.workingBuffer = new byte[newSize];
        System.arraycopy(oldBuffer, 0, this.workingBuffer, 0, oldBuffer.length);
    }

    private boolean tryIncrement(int length) {
        if (this.pos + length >= this.data) {
            return false;
        }
        this.pos += length;
        return true;
    }

    private String dumpByteArray(byte[] bytes) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.data; ++i) {
            char b = (char)bytes[i];
            if (b < '!' || b > '\u0088') {
                str.append(bytes[i]);
            } else {
                str.append(b);
            }
            if (i == bytes.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }
}

