/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.LinkedListImpl;
import org.hornetq.utils.LinkedListIterator;
import org.hornetq.utils.PriorityLinkedList;

public class PriorityLinkedListImpl<T>
implements PriorityLinkedList<T> {
    private static final Logger log = Logger.getLogger(PriorityLinkedListImpl.class);
    protected LinkedListImpl<T>[] levels;
    protected final int priorities;
    private int size;
    private int lastReset;
    private int highestPriority = -1;

    public PriorityLinkedListImpl(int priorities) {
        this.priorities = priorities;
        this.levels = (LinkedListImpl[])Array.newInstance(LinkedListImpl.class, priorities);
        for (int i = 0; i < priorities; ++i) {
            this.levels[i] = new LinkedListImpl();
        }
    }

    private void checkHighest(int priority) {
        if (priority > this.highestPriority) {
            this.highestPriority = priority;
            ++this.lastReset;
        }
    }

    @Override
    public void addHead(T t, int priority) {
        this.checkHighest(priority);
        this.levels[priority].addHead(t);
        ++this.size;
    }

    @Override
    public void addTail(T t, int priority) {
        this.checkHighest(priority);
        this.levels[priority].addTail(t);
        ++this.size;
    }

    @Override
    public T poll() {
        T t = null;
        for (int i = this.highestPriority; i >= 0; --i) {
            LinkedListImpl<T> ll = this.levels[i];
            if (ll.size() == 0) continue;
            t = ll.poll();
            if (t == null) break;
            --this.size;
            if (ll.size() != 0 || this.highestPriority != i) break;
            --this.highestPriority;
            break;
        }
        return t;
    }

    @Override
    public void clear() {
        for (LinkedListImpl<T> list : this.levels) {
            list.clear();
        }
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public LinkedListIterator<T> iterator() {
        return new PriorityLinkedListIterator();
    }

    private class PriorityLinkedListIterator
    implements LinkedListIterator<T> {
        private int index;
        private LinkedListIterator<T>[] cachedIters;
        private LinkedListIterator<T> lastIter;
        private int resetCount;
        volatile boolean closed;

        PriorityLinkedListIterator() {
            this.cachedIters = new LinkedListIterator[PriorityLinkedListImpl.this.levels.length];
            this.resetCount = PriorityLinkedListImpl.this.lastReset;
            this.closed = false;
            this.index = PriorityLinkedListImpl.this.levels.length - 1;
        }

        protected void finalize() {
            this.close();
        }

        @Override
        public void repeat() {
            if (this.lastIter == null) {
                throw new NoSuchElementException();
            }
            this.lastIter.repeat();
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.lastIter = null;
                for (LinkedListIterator iter : this.cachedIters) {
                    if (iter == null) continue;
                    iter.close();
                }
            }
        }

        private void checkReset() {
            if (PriorityLinkedListImpl.this.lastReset > this.resetCount) {
                this.index = PriorityLinkedListImpl.this.highestPriority;
                this.resetCount = PriorityLinkedListImpl.this.lastReset;
            }
        }

        @Override
        public boolean hasNext() {
            this.checkReset();
            while (this.index >= 0) {
                boolean b;
                this.lastIter = this.cachedIters[this.index];
                if (this.lastIter == null) {
                    this.cachedIters[this.index] = PriorityLinkedListImpl.this.levels[this.index].iterator();
                    this.lastIter = this.cachedIters[this.index];
                }
                if (b = this.lastIter.hasNext()) {
                    return true;
                }
                --this.index;
                if (this.index >= 0) continue;
                this.index = PriorityLinkedListImpl.this.levels.length - 1;
                break;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.lastIter == null) {
                throw new NoSuchElementException();
            }
            return this.lastIter.next();
        }

        @Override
        public void remove() {
            if (this.lastIter == null) {
                throw new NoSuchElementException();
            }
            this.lastIter.remove();
            if (this.index == PriorityLinkedListImpl.this.highestPriority && PriorityLinkedListImpl.this.levels[this.index].size() == 0) {
                PriorityLinkedListImpl.this.highestPriority--;
            }
            PriorityLinkedListImpl.this.size--;
        }
    }
}

