/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import java.util.Arrays;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONException;
import org.hornetq.utils.json.JSONObject;

public class DayCounterInfo {
    private static final Logger log = Logger.getLogger(DayCounterInfo.class);
    private final String date;
    private final int[] counters;

    public static String toJSON(DayCounterInfo[] infos) throws JSONException {
        JSONObject json = new JSONObject();
        JSONArray counters = new JSONArray();
        for (DayCounterInfo info : infos) {
            JSONObject counter = new JSONObject();
            counter.put("date", info.getDate());
            counter.put("counters", Arrays.asList(new int[][]{info.getCounters()}));
            counters.put(counter);
        }
        json.put("dayCounters", counters);
        return json.toString();
    }

    public static DayCounterInfo[] fromJSON(String jsonString) throws JSONException {
        JSONObject json = new JSONObject(jsonString);
        JSONArray dayCounters = json.getJSONArray("dayCounters");
        DayCounterInfo[] infos = new DayCounterInfo[dayCounters.length()];
        for (int i = 0; i < dayCounters.length(); ++i) {
            DayCounterInfo info;
            JSONObject counter = (JSONObject)dayCounters.get(i);
            JSONArray hour = (JSONArray)counter.getJSONArray("counters").get(0);
            int[] hourCounters = new int[24];
            for (int j = 0; j < 24; ++j) {
                hourCounters[j] = hour.getInt(j);
            }
            infos[i] = info = new DayCounterInfo(counter.getString("date"), hourCounters);
        }
        return infos;
    }

    public DayCounterInfo(String date, int[] counters) {
        this.date = date;
        this.counters = counters;
    }

    public String getDate() {
        return this.date;
    }

    public int[] getCounters() {
        return this.counters;
    }
}

