/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.asyncio.AsynchronousFile;
import org.hornetq.core.asyncio.BufferCallback;
import org.hornetq.core.asyncio.IOExceptionListener;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractSequentialFile;
import org.hornetq.core.journal.impl.DummyCallback;
import org.hornetq.core.journal.impl.SimpleWaitIOCallback;
import org.hornetq.core.logging.Logger;

public class AIOSequentialFile
extends AbstractSequentialFile
implements IOExceptionListener {
    private static final Logger log = Logger.getLogger(AIOSequentialFile.class);
    private boolean opened = false;
    private final int maxIO;
    private AsynchronousFile aioFile;
    private final BufferCallback bufferCallback;
    private final Executor pollerExecutor;

    public AIOSequentialFile(SequentialFileFactory factory, int bufferSize, long bufferTimeoutMilliseconds, String directory, String fileName, int maxIO, BufferCallback bufferCallback, Executor writerExecutor, Executor pollerExecutor) {
        super(directory, new File(directory + "/" + fileName), factory, writerExecutor);
        this.maxIO = maxIO;
        this.bufferCallback = bufferCallback;
        this.pollerExecutor = pollerExecutor;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public int getAlignment() throws Exception {
        this.checkOpened();
        return this.aioFile.getBlockSize();
    }

    @Override
    public int calculateBlockStart(int position) throws Exception {
        int alignment = this.getAlignment();
        int pos = (position / alignment + (position % alignment != 0 ? 1 : 0)) * alignment;
        return pos;
    }

    @Override
    public SequentialFile cloneFile() {
        return new AIOSequentialFile(this.factory, -1, -1L, this.getFile().getParent(), this.getFileName(), this.maxIO, this.bufferCallback, this.writerExecutor, this.pollerExecutor);
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.opened) {
            return;
        }
        super.close();
        this.opened = false;
        this.timedBuffer = null;
        this.aioFile.close();
        this.aioFile = null;
        this.notifyAll();
    }

    @Override
    public synchronized void waitForClose() throws Exception {
        while (this.isOpen()) {
            this.wait();
        }
    }

    @Override
    public void fill(int position, int size, byte fillCharacter) throws Exception {
        int fileblockSize;
        this.checkOpened();
        int blockSize = fileblockSize = this.aioFile.getBlockSize();
        blockSize = size % 0x6400000 == 0 ? 0x6400000 : (size % 0xA00000 == 0 ? 0xA00000 : (size % 0x100000 == 0 ? 0x100000 : (size % 10240 == 0 ? 10240 : fileblockSize)));
        int blocks = size / blockSize;
        if (size % blockSize != 0) {
            ++blocks;
        }
        int filePosition = position;
        if (position % fileblockSize != 0) {
            filePosition = (position / fileblockSize + 1) * fileblockSize;
        }
        this.aioFile.fill(filePosition, blocks, blockSize, fillCharacter);
        this.fileSize = this.aioFile.size();
    }

    @Override
    public void open() throws Exception {
        this.open(this.maxIO, true);
    }

    @Override
    public synchronized void open(int maxIO, boolean useExecutor) throws Exception {
        this.opened = true;
        this.aioFile = new AsynchronousFileImpl(useExecutor ? this.writerExecutor : null, this.pollerExecutor, this);
        try {
            this.aioFile.open(this.getFile().getAbsolutePath(), maxIO);
        }
        catch (HornetQException e) {
            this.factory.onIOError(6, e.getMessage(), this);
            throw e;
        }
        this.position.set(0L);
        this.aioFile.setBufferCallback(this.bufferCallback);
        this.fileSize = this.aioFile.size();
    }

    public void setBufferCallback(BufferCallback callback) {
        this.aioFile.setBufferCallback(callback);
    }

    @Override
    public int read(ByteBuffer bytes, IOAsyncTask callback) throws Exception {
        int bytesToRead = bytes.limit();
        long positionToRead = this.position.getAndAdd(bytesToRead);
        bytes.rewind();
        this.aioFile.read(positionToRead, bytesToRead, bytes, callback);
        return bytesToRead;
    }

    @Override
    public int read(ByteBuffer bytes) throws Exception {
        SimpleWaitIOCallback waitCompletion = new SimpleWaitIOCallback();
        int bytesRead = this.read(bytes, waitCompletion);
        waitCompletion.waitCompletion();
        return bytesRead;
    }

    @Override
    public void sync() throws Exception {
        throw new IllegalArgumentException("This method is not supported on AIO");
    }

    @Override
    public long size() throws Exception {
        if (this.aioFile == null) {
            return this.getFile().length();
        }
        return this.aioFile.size();
    }

    public String toString() {
        return "AIOSequentialFile:" + this.getFile().getAbsolutePath();
    }

    @Override
    public void onIOException(int code, String message) {
        this.factory.onIOError(code, message, this);
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        if (sync) {
            SimpleWaitIOCallback completion = new SimpleWaitIOCallback();
            this.writeDirect(bytes, true, completion);
            completion.waitCompletion();
        } else {
            this.writeDirect(bytes, false, DummyCallback.getInstance());
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOAsyncTask callback) {
        int bytesToWrite = this.factory.calculateBlockSize(bytes.limit());
        long positionToWrite = this.position.getAndAdd(bytesToWrite);
        this.aioFile.write(positionToWrite, bytesToWrite, bytes, callback);
    }

    @Override
    public void writeInternal(ByteBuffer bytes) throws Exception {
        int bytesToWrite = this.factory.calculateBlockSize(bytes.limit());
        long positionToWrite = this.position.getAndAdd(bytesToWrite);
        this.aioFile.writeInternal(positionToWrite, bytesToWrite, bytes);
    }

    @Override
    protected ByteBuffer newBuffer(int size, int limit) {
        size = this.factory.calculateBlockSize(size);
        limit = this.factory.calculateBlockSize(limit);
        ByteBuffer buffer = this.factory.newBuffer(size);
        buffer.limit(limit);
        return buffer;
    }

    private void checkOpened() throws Exception {
        if (this.aioFile == null || !this.opened) {
            throw new IllegalStateException("File not opened");
        }
    }
}

