/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.TopologyMember;
import org.hornetq.core.server.HornetQLogger;

public final class Topology
implements Serializable {
    private static final long serialVersionUID = -9037171688692471371L;
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private transient Executor executor = null;
    private volatile Object owner;
    private final Map<String, TopologyMember> topology = new ConcurrentHashMap<String, TopologyMember>();
    private transient Map<String, Long> mapDelete;

    public Topology(Object owner) {
        this.owner = owner;
        if (HornetQLogger.LOGGER.isTraceEnabled()) {
            HornetQLogger.LOGGER.trace("Topology@" + Integer.toHexString(System.identityHashCode(this)) + " CREATE", new Exception("trace"));
        }
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        if (HornetQLogger.LOGGER.isDebugEnabled()) {
            HornetQLogger.LOGGER.debug(this + "::Adding topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        if (HornetQLogger.LOGGER.isDebugEnabled()) {
            HornetQLogger.LOGGER.debug(this + "::Removing topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsLive(String nodeId, TopologyMember memberInput) {
        Topology topology = this;
        synchronized (topology) {
            if (HornetQLogger.LOGGER.isDebugEnabled()) {
                HornetQLogger.LOGGER.debug(this + "::node " + nodeId + "=" + memberInput);
            }
            memberInput.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, memberInput);
            this.sendMemberUp(memberInput.getUniqueEventID(), nodeId, memberInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyMember updateBackup(String nodeId, TopologyMember memberInput) {
        if (HornetQLogger.LOGGER.isTraceEnabled()) {
            HornetQLogger.LOGGER.trace(this + "::updateBackup::" + nodeId + ", memberInput=" + memberInput);
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMember currentMember = this.getMember(nodeId);
            if (currentMember == null) {
                HornetQLogger.LOGGER.debug("There's no live to be updated on backup update, node=" + nodeId + " memberInput=" + memberInput, new Exception("trace"));
                currentMember = memberInput;
                this.topology.put(nodeId, currentMember);
            }
            TopologyMember newMember = new TopologyMember(currentMember.getA(), memberInput.getB());
            newMember.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, newMember);
            this.sendMemberUp(newMember.getUniqueEventID(), nodeId, newMember);
            return newMember;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMember(long uniqueEventID, String nodeId, TopologyMember memberInput) {
        Long deleteTme = this.getMapDelete().get(nodeId);
        if (deleteTme != null && uniqueEventID < deleteTme) {
            HornetQLogger.LOGGER.debug("Update uniqueEvent=" + uniqueEventID + ", nodeId=" + nodeId + ", memberInput=" + memberInput + " being rejected as there was a delete done after that");
            return false;
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMember currentMember = this.topology.get(nodeId);
            if (currentMember == null) {
                if (HornetQLogger.LOGGER.isDebugEnabled()) {
                    HornetQLogger.LOGGER.debug(this + "::NewMemeberAdd nodeId=" + nodeId + " member = " + memberInput, new Exception("trace"));
                }
                memberInput.setUniqueEventID(uniqueEventID);
                this.topology.put(nodeId, memberInput);
                this.sendMemberUp(uniqueEventID, nodeId, memberInput);
                return true;
            }
            if (uniqueEventID > currentMember.getUniqueEventID()) {
                TopologyMember newMember = new TopologyMember(memberInput.getA(), memberInput.getB());
                if (newMember.getA() == null && currentMember.getA() != null) {
                    newMember.setA(currentMember.getA());
                }
                if (newMember.getB() == null && currentMember.getB() != null) {
                    newMember.setB(currentMember.getB());
                }
                if (HornetQLogger.LOGGER.isDebugEnabled()) {
                    HornetQLogger.LOGGER.debug(this + "::updated currentMember=nodeID=" + nodeId + ", currentMember=" + currentMember + ", memberInput=" + memberInput + "newMember=" + newMember, new Exception("trace"));
                }
                newMember.setUniqueEventID(uniqueEventID);
                this.topology.remove(nodeId);
                this.topology.put(nodeId, newMember);
                this.sendMemberUp(uniqueEventID, nodeId, newMember);
                return true;
            }
            if (currentMember.getB() == null && memberInput.getB() != null) {
                currentMember.setB(memberInput.getB());
            }
            return false;
        }
    }

    private void sendMemberUp(final long uniqueEventID, final String nodeId, final TopologyMember memberToSend) {
        final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
        if (HornetQLogger.LOGGER.isTraceEnabled()) {
            HornetQLogger.LOGGER.trace(this + "::prepare to send " + nodeId + " to " + copy.size() + " elements");
        }
        if (copy.size() > 0) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (HornetQLogger.LOGGER.isTraceEnabled()) {
                            HornetQLogger.LOGGER.trace(Topology.this + " informing " + listener + " about node up = " + nodeId + " connector = " + memberToSend.getConnector());
                        }
                        try {
                            listener.nodeUP(uniqueEventID, nodeId, memberToSend.getConnector(), false);
                        }
                        catch (Throwable e) {
                            HornetQLogger.LOGGER.errorSendingTopology(e);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ClusterTopologyListener> copyListeners() {
        ArrayList<ClusterTopologyListener> listenersCopy;
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            listenersCopy = new ArrayList<ClusterTopologyListener>(this.topologyListeners);
        }
        return listenersCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeMember(final long uniqueEventID, final String nodeId) {
        TopologyMember member;
        Topology topology = this;
        synchronized (topology) {
            member = this.topology.get(nodeId);
            if (member != null) {
                if (member.getUniqueEventID() > uniqueEventID) {
                    HornetQLogger.LOGGER.debug("The removeMember was issued before the node " + nodeId + " was started, ignoring call");
                    member = null;
                } else {
                    this.getMapDelete().put(nodeId, uniqueEventID);
                    member = this.topology.remove(nodeId);
                }
            }
        }
        if (HornetQLogger.LOGGER.isDebugEnabled()) {
            HornetQLogger.LOGGER.debug("removeMember " + this + " removing nodeID=" + nodeId + ", result=" + member + ", size = " + this.topology.size(), new Exception("trace"));
        }
        if (member != null) {
            final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (HornetQLogger.LOGGER.isTraceEnabled()) {
                            HornetQLogger.LOGGER.trace(this + " informing " + listener + " about node down = " + nodeId);
                        }
                        try {
                            listener.nodeDown(uniqueEventID, nodeId);
                        }
                        catch (Exception e) {
                            HornetQLogger.LOGGER.errorSendingTopologyNodedown(e);
                        }
                    }
                }
            });
        }
        return member != null;
    }

    protected void execute(Runnable runnable) {
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public void sendMember(final String nodeID) {
        final TopologyMember member = this.getMember(nodeID);
        final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
        this.execute(new Runnable(){

            @Override
            public void run() {
                for (ClusterTopologyListener listener : copy) {
                    if (HornetQLogger.LOGGER.isDebugEnabled()) {
                        HornetQLogger.LOGGER.debug("Informing client listener " + listener + " about itself node " + nodeID + " with connector=" + member.getConnector());
                    }
                    listener.nodeUP(member.getUniqueEventID(), nodeID, member.getConnector(), false);
                }
            }
        });
    }

    public synchronized void sendTopology(final ClusterTopologyListener listener) {
        if (HornetQLogger.LOGGER.isDebugEnabled()) {
            HornetQLogger.LOGGER.debug(this + " is sending topology to " + listener);
        }
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap copy;
                int count = 0;
                Topology topology = Topology.this;
                synchronized (topology) {
                    copy = new HashMap(Topology.this.topology);
                }
                for (Map.Entry entry : copy.entrySet()) {
                    if (HornetQLogger.LOGGER.isDebugEnabled()) {
                        HornetQLogger.LOGGER.debug(Topology.this + " sending " + (String)entry.getKey() + " / " + ((TopologyMember)entry.getValue()).getConnector() + " to " + listener);
                    }
                    listener.nodeUP(((TopologyMember)entry.getValue()).getUniqueEventID(), (String)entry.getKey(), ((TopologyMember)entry.getValue()).getConnector(), ++count == copy.size());
                }
            }
        });
    }

    public synchronized TopologyMember getMember(String nodeID) {
        return this.topology.get(nodeID);
    }

    public synchronized boolean isEmpty() {
        return this.topology.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TopologyMember> getMembers() {
        ArrayList<TopologyMember> members;
        Topology topology = this;
        synchronized (topology) {
            members = new ArrayList<TopologyMember>(this.topology.values());
        }
        return members;
    }

    synchronized int nodes() {
        int count = 0;
        for (TopologyMember member : this.topology.values()) {
            if (member.getA() != null) {
                ++count;
            }
            if (member.getB() == null) continue;
            ++count;
        }
        return count;
    }

    public synchronized String describe() {
        return this.describe("");
    }

    private synchronized String describe(String text) {
        StringBuilder desc = new StringBuilder(text + "topology on " + this + ":\n");
        for (Map.Entry<String, TopologyMember> entry : new HashMap<String, TopologyMember>(this.topology).entrySet()) {
            desc.append("\t" + entry.getKey() + " => " + entry.getValue() + "\n");
        }
        desc.append("\tnodes=" + this.nodes() + "\t" + "members=" + this.members());
        if (this.topology.isEmpty()) {
            desc.append("\tEmpty");
        }
        return desc.toString();
    }

    private int members() {
        return this.topology.size();
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    TransportConfiguration getBackupForConnector(TransportConfiguration connectorConfiguration) {
        for (TopologyMember member : this.topology.values()) {
            if (member.getA() == null || !member.getA().equals(connectorConfiguration)) continue;
            return member.getB();
        }
        return null;
    }

    public String toString() {
        if (this.owner == null) {
            return "Topology@" + Integer.toHexString(System.identityHashCode(this));
        }
        return "Topology@" + Integer.toHexString(System.identityHashCode(this)) + "[owner=" + this.owner + "]";
    }

    private synchronized Map<String, Long> getMapDelete() {
        if (this.mapDelete == null) {
            this.mapDelete = new ConcurrentHashMap<String, Long>();
        }
        return this.mapDelete;
    }
}

