/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.cluster;

import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hornetq.core.cluster.BroadcastEndpoint;
import org.hornetq.core.cluster.impl.UDPBroadcastEndpoint;
import org.hornetq.utils.ClassloadingUtil;

public class BroadcastEndpointFactory {
    public static BroadcastEndpoint createUDPEndpoint(String groupAddress, int groupPort, String localBindAddress, int localBindPort) throws Exception {
        return BroadcastEndpointFactory.createUDPEndpoint(groupAddress != null ? InetAddress.getByName(groupAddress) : null, groupPort, localBindAddress != null ? InetAddress.getByName(localBindAddress) : null, localBindPort);
    }

    public static BroadcastEndpoint createUDPEndpoint(InetAddress groupAddress, int groupPort, InetAddress localBindAddress, int localBindPort) throws Exception {
        return new UDPBroadcastEndpoint(groupAddress, groupPort, localBindAddress, localBindPort);
    }

    public static BroadcastEndpoint createJGropusEndpoint(final String fileName, final String channelName) throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<BroadcastEndpoint>(){

            @Override
            public BroadcastEndpoint run() {
                BroadcastEndpoint endpoint = (BroadcastEndpoint)ClassloadingUtil.newInstanceFromClassLoader((String)"org.hornetq.core.cluster.impl.JGroupsBroadcastEndpoint", (Object[])new Object[]{fileName, channelName});
                return endpoint;
            }
        });
    }
}

