/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.cluster.impl;

import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.cluster.BroadcastEndpoint;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Util;

public class JGroupsBroadcastEndpoint
implements BroadcastEndpoint {
    private final String fileName;
    private final String channelName;
    private JChannel channel;
    private BlockingQueue<byte[]> dequeue = new LinkedBlockingDeque<byte[]>();
    private Message broadcastMsg;
    private boolean opened;

    public JGroupsBroadcastEndpoint(String fileName, String channelName) {
        this.fileName = fileName;
        this.channelName = channelName;
    }

    @Override
    public void broadcast(byte[] data) throws Exception {
        if (this.opened) {
            Message msg = new Message();
            msg.setBuffer(data);
            this.channel.send(msg);
        }
    }

    @Override
    public byte[] receiveBroadcast() throws Exception {
        if (this.opened) {
            byte[] msg = this.dequeue.take();
            return msg;
        }
        return null;
    }

    @Override
    public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
        if (this.opened) {
            byte[] msg = this.dequeue.poll(time, unit);
            return msg;
        }
        return null;
    }

    @Override
    public void openClient() throws Exception {
        if (this.opened) {
            return;
        }
        this.internalOpen();
        this.channel.setReceiver((Receiver)new JGroupsReceiver());
        this.opened = true;
    }

    @Override
    public void openBroadcaster() throws Exception {
        if (this.opened) {
            return;
        }
        this.internalOpen();
        this.opened = true;
    }

    private void internalOpen() throws Exception {
        URL configURL = Thread.currentThread().getContextClassLoader().getResource(this.fileName);
        if (configURL == null) {
            throw new RuntimeException("couldn't find JGroups configuration " + this.fileName);
        }
        this.channel = new JChannel(configURL);
        this.channel.connect(this.channelName);
    }

    @Override
    public void close() throws Exception {
        if (this.channel != null) {
            Util.shutdown((Channel)this.channel);
            this.channel = null;
        }
        this.opened = false;
    }

    private class JGroupsReceiver
    extends ReceiverAdapter {
        private JGroupsReceiver() {
        }

        public void receive(Message msg) {
            JGroupsBroadcastEndpoint.this.dequeue.add(msg.getBuffer());
        }
    }
}

