/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.io.InputStreamReader;
import java.net.URL;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.deployers.impl.FileConfigurationParser;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;

public class FileConfiguration
extends ConfigurationImpl {
    private static final long serialVersionUID = -4766689627675039596L;
    private static final String DEFAULT_CONFIGURATION_URL = "hornetq-configuration.xml";
    public static final int DEFAULT_CONFIRMATION_WINDOW_SIZE = 0x100000;
    private String configurationUrl = "hornetq-configuration.xml";
    private boolean started;

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        URL url = this.getClass().getClassLoader().getResource(this.configurationUrl);
        if (url == null) {
            url = new URL(this.configurationUrl);
        }
        HornetQLogger.LOGGER.debug("Loading server configuration from " + url);
        InputStreamReader reader = new InputStreamReader(url.openStream());
        String xml = XMLUtil.readerToString(reader);
        xml = XMLUtil.replaceSystemProps(xml);
        Element e = XMLUtil.stringToElement(xml);
        FileConfigurationParser parser = new FileConfigurationParser();
        parser.setValidateAIO(true);
        parser.parseMainConfig(e, this);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }

    public String getConfigurationUrl() {
        return this.configurationUrl;
    }

    public void setConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
    }
}

