/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;

public final class Validators {
    public static final Validator NO_CHECK = new Validator(){

        @Override
        public void validate(String name, Object value) {
        }
    };
    public static final Validator NOT_NULL_OR_EMPTY = new Validator(){

        @Override
        public void validate(String name, Object value) {
            String str = (String)value;
            if (str == null || str.length() == 0) {
                throw HornetQMessageBundle.BUNDLE.emptyOrNull(name);
            }
        }
    };
    public static final Validator GT_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (!(val.doubleValue() > 0.0)) {
                throw HornetQMessageBundle.BUNDLE.greaterThanZero(name, val);
            }
        }
    };
    public static final Validator PERCENTAGE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val == null || val.intValue() < 0 || val.intValue() > 100) {
                throw HornetQMessageBundle.BUNDLE.notPercent(name, val);
            }
        }
    };
    public static final Validator GE_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (!(val.doubleValue() >= 0.0)) {
                throw HornetQMessageBundle.BUNDLE.greaterThanZero(name, val);
            }
        }
    };
    public static final Validator MINUS_ONE_OR_GT_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val.doubleValue() != -1.0 && !(val.doubleValue() > 0.0)) {
                throw HornetQMessageBundle.BUNDLE.greaterThanMinusOne(name, val);
            }
        }
    };
    public static final Validator MINUS_ONE_OR_GE_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val.doubleValue() != -1.0 && !(val.doubleValue() >= 0.0)) {
                throw HornetQMessageBundle.BUNDLE.greaterThanZeroOrMinusOne(name, val);
            }
        }
    };
    public static final Validator THREAD_PRIORITY_RANGE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val.intValue() < 1 || val.intValue() > 10) {
                throw HornetQMessageBundle.BUNDLE.mustbeBetween(name, 1, 10, value);
            }
        }
    };
    public static final Validator JOURNAL_TYPE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            String val = (String)value;
            if (val == null || !val.equals(JournalType.NIO.toString()) && !val.equals(JournalType.ASYNCIO.toString())) {
                throw HornetQMessageBundle.BUNDLE.invalidJournalType(val);
            }
        }
    };
    public static final Validator ADDRESS_FULL_MESSAGE_POLICY_TYPE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            String val = (String)value;
            if (val == null || !val.equals(AddressFullMessagePolicy.PAGE.toString()) && !val.equals(AddressFullMessagePolicy.DROP.toString()) && !val.equals(AddressFullMessagePolicy.BLOCK.toString())) {
                throw HornetQMessageBundle.BUNDLE.invalidAddressFullPolicyType(val);
            }
        }
    };

    public static interface Validator {
        public void validate(String var1, Object var2);
    }
}

