/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import org.hornetq.api.core.Pair;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.FileConfigurationParser;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;

public class AddressSettingsDeployer
extends XmlDeployer {
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final FileConfigurationParser parser = new FileConfigurationParser();

    public AddressSettingsDeployer(DeploymentManager deploymentManager, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        super(deploymentManager);
        this.addressSettingsRepository = addressSettingsRepository;
    }

    @Override
    public String[] getElementTagName() {
        return new String[]{"address-setting"};
    }

    @Override
    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate(rootNode, "schema/hornetq-configuration.xsd");
    }

    @Override
    public void deploy(Node node) throws Exception {
        Pair<String, AddressSettings> setting = this.parser.parseAddressSettings(node);
        this.addressSettingsRepository.addMatch((String)setting.getA(), (AddressSettings)setting.getB());
    }

    @Override
    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-configuration.xml", "hornetq-queues.xml"};
    }

    @Override
    public void undeploy(Node node) throws Exception {
        String match = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        this.addressSettingsRepository.removeMatch(match);
    }

    @Override
    public String getKeyAttribute() {
        return "match";
    }
}

