/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.filter.impl;

import java.util.HashSet;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.impl.Identifier;
import org.hornetq.core.filter.impl.RegExp;
import org.hornetq.core.server.HornetQMessageBundle;

public final class Operator {
    int operation;
    Object oper1;
    Object oper2;
    Object oper3;
    private Object arg1;
    Object arg2;
    Object arg3;
    int class1;
    int class2;
    int class3;
    RegExp re = null;
    public static final int EQUAL = 0;
    public static final int NOT = 1;
    public static final int AND = 2;
    public static final int OR = 3;
    public static final int GT = 4;
    public static final int GE = 5;
    public static final int LT = 6;
    public static final int LE = 7;
    public static final int DIFFERENT = 8;
    static final int ADD = 9;
    public static final int SUB = 10;
    public static final int NEG = 11;
    public static final int MUL = 12;
    public static final int DIV = 13;
    public static final int BETWEEN = 14;
    public static final int NOT_BETWEEN = 15;
    public static final int LIKE = 16;
    public static final int NOT_LIKE = 17;
    public static final int LIKE_ESCAPE = 18;
    public static final int NOT_LIKE_ESCAPE = 19;
    public static final int IS_NULL = 20;
    public static final int IS_NOT_NULL = 21;
    public static final int IN = 22;
    public static final int NOT_IN = 23;
    public static final int DOUBLE = 1;
    public static final int LONG = 2;
    public static final int BOOLEAN = 3;
    public static final int SIMPLE_STRING = 4;

    public Operator(int operation, Object oper1, Object oper2, Object oper3) {
        this.operation = operation;
        this.oper1 = oper1;
        this.oper2 = oper2;
        this.oper3 = oper3;
    }

    public Operator(int operation, Object oper1, Object oper2) {
        this.operation = operation;
        this.oper1 = oper1;
        this.oper2 = oper2;
        this.oper3 = null;
    }

    public Operator(int operation, Object oper1) {
        this.operation = operation;
        this.oper1 = oper1;
        this.oper2 = null;
        this.oper3 = null;
    }

    public String toString() {
        return this.print("");
    }

    public String print(String level) {
        String st = level + this.operation + ":" + Operator.operationString(this.operation) + "(\n";
        String nextLevel = level + "  ";
        st = this.oper1 == null ? st + nextLevel + "null\n" : (this.oper1 instanceof Operator ? st + ((Operator)this.oper1).print(nextLevel) : st + nextLevel + this.oper1.toString() + "\n");
        if (this.oper2 != null) {
            st = this.oper2 instanceof Operator ? st + ((Operator)this.oper2).print(nextLevel) : st + nextLevel + this.oper2.toString() + "\n";
        }
        if (this.oper3 != null) {
            st = this.oper3 instanceof Operator ? st + ((Operator)this.oper3).print(nextLevel) : st + nextLevel + this.oper3.toString() + "\n";
        }
        st = st + level + ")\n";
        return st;
    }

    Object is_null() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Object is_not_null() throws Exception {
        this.computeArgument1();
        if (this.arg1 != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Object equal() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.FALSE;
        }
        switch (this.class1) {
            case 2: {
                this.computeArgument1();
                if (this.arg1 == null) {
                    return null;
                }
                this.computeArgument2();
                if (this.arg2 == null) {
                    return null;
                }
                if (this.class2 == 2) {
                    return ((Number)this.arg1).longValue() == ((Number)this.arg2).longValue();
                }
                if (this.class2 == 1) {
                    return (double)((Number)this.arg1).longValue() == ((Number)this.arg2).doubleValue();
                }
                return Boolean.FALSE;
            }
            case 1: {
                this.computeArgument1();
                if (this.arg1 == null) {
                    return null;
                }
                this.computeArgument2();
                if (this.arg2 == null) {
                    return null;
                }
                if (this.class2 == 2) {
                    return ((Number)this.arg1).doubleValue() == (double)((Number)this.arg2).longValue();
                }
                if (this.class2 == 1) {
                    return ((Number)this.arg1).doubleValue() == ((Number)this.arg2).doubleValue();
                }
                return Boolean.FALSE;
            }
            case 3: 
            case 4: {
                this.computeArgument2();
                if (this.arg2 == null) {
                    return Boolean.FALSE;
                }
                if (this.class2 != this.class1) {
                    this.throwBadObjectException(this.class1, this.class2);
                }
                return this.arg1.equals(this.arg2);
            }
        }
        this.throwBadObjectException(this.class1);
        return null;
    }

    Object not() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 != 3) {
            this.throwBadObjectException(this.class1);
        }
        if (((Boolean)this.arg1).booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    Object and() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 != 3) {
                this.throwBadObjectException(this.class2);
            }
            if (!((Boolean)this.arg2).booleanValue()) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.class1 == 3) {
            if (!((Boolean)this.arg1).booleanValue()) {
                return Boolean.FALSE;
            }
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 != 3) {
                this.throwBadObjectException(this.class2);
            }
            return this.arg2;
        }
        this.throwBadObjectException(this.class1);
        return null;
    }

    Object or() throws Exception {
        int falseCounter = 0;
        this.computeArgument1();
        if (this.arg1 != null) {
            if (this.class1 != 3) {
                this.throwBadObjectException(this.class1);
            }
            if (((Boolean)this.arg1).booleanValue()) {
                return Boolean.TRUE;
            }
            falseCounter = (short)(falseCounter + 1);
        }
        this.computeArgument2();
        if (this.arg2 != null) {
            if (this.class2 != 3) {
                this.throwBadObjectException(this.class2);
            }
            if (((Boolean)this.arg2).booleanValue()) {
                return Boolean.TRUE;
            }
            falseCounter = (short)(falseCounter + 1);
        }
        if (falseCounter == 2) {
            return Boolean.FALSE;
        }
        return null;
    }

    Object gt() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).longValue() > ((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return (double)((Number)this.arg1).longValue() > ((Number)this.arg2).doubleValue();
            }
        } else if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).doubleValue() > (double)((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return ((Number)this.arg1).doubleValue() > ((Number)this.arg2).doubleValue();
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    Object ge() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).longValue() >= ((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return (double)((Number)this.arg1).longValue() >= ((Number)this.arg2).doubleValue();
            }
        } else if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).longValue() >= ((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return ((Number)this.arg1).doubleValue() >= ((Number)this.arg2).doubleValue();
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    Object lt() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).longValue() < ((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return (double)((Number)this.arg1).longValue() < ((Number)this.arg2).doubleValue();
            }
        } else if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).doubleValue() < (double)((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return ((Number)this.arg1).doubleValue() < ((Number)this.arg2).doubleValue();
            }
        }
        return Boolean.FALSE;
    }

    Object le() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).longValue() <= ((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return (double)((Number)this.arg1).longValue() <= ((Number)this.arg2).doubleValue();
            }
        } else if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 == 2) {
                return ((Number)this.arg1).doubleValue() <= (double)((Number)this.arg2).longValue();
            }
            if (this.class2 == 1) {
                return ((Number)this.arg1).doubleValue() <= ((Number)this.arg2).doubleValue();
            }
        }
        return Boolean.FALSE;
    }

    Object different() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        switch (this.class1) {
            case 2: {
                this.computeArgument1();
                if (this.arg1 == null) {
                    return null;
                }
                this.computeArgument2();
                if (this.arg2 == null) {
                    return null;
                }
                if (this.class2 == 2) {
                    return ((Number)this.arg1).longValue() != ((Number)this.arg2).longValue();
                }
                if (this.class2 == 1) {
                    return (double)((Number)this.arg1).longValue() != ((Number)this.arg2).doubleValue();
                }
                return Boolean.FALSE;
            }
            case 1: {
                this.computeArgument1();
                if (this.arg1 == null) {
                    return null;
                }
                this.computeArgument2();
                if (this.arg2 == null) {
                    return null;
                }
                if (this.class2 == 2) {
                    return ((Number)this.arg1).doubleValue() != (double)((Number)this.arg2).longValue();
                }
                if (this.class2 == 1) {
                    return ((Number)this.arg1).doubleValue() != ((Number)this.arg2).doubleValue();
                }
                return Boolean.FALSE;
            }
            case 3: 
            case 4: {
                this.computeArgument2();
                if (this.arg2 == null) {
                    return null;
                }
                if (this.class2 != this.class1) {
                    this.throwBadObjectException(this.class1, this.class2);
                }
                return !this.arg1.equals(this.arg2);
            }
        }
        this.throwBadObjectException(this.class1);
        return null;
    }

    Object add() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() + ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).doubleValue() + ((Number)this.arg2).doubleValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() + ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).longValue() + ((Number)this.arg2).longValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            default: {
                this.throwBadObjectException(this.class1);
            }
        }
        return null;
    }

    Object sub() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() - ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).doubleValue() - ((Number)this.arg2).doubleValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() - ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).longValue() - ((Number)this.arg2).longValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            default: {
                this.throwBadObjectException(this.class1);
            }
        }
        return null;
    }

    Object neg() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                return -((Number)this.arg1).doubleValue();
            }
            case 2: {
                return -((Number)this.arg1).longValue();
            }
        }
        this.throwBadObjectException(this.class1);
        return null;
    }

    Object mul() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() * ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).doubleValue() * ((Number)this.arg2).doubleValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() * ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).longValue() * ((Number)this.arg2).longValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            default: {
                this.throwBadObjectException(this.class1);
            }
        }
        return null;
    }

    Object div() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() / ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).doubleValue() / ((Number)this.arg2).doubleValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return ((Number)this.arg1).doubleValue() / ((Number)this.arg2).doubleValue();
                    }
                    case 2: {
                        return ((Number)this.arg1).longValue() / ((Number)this.arg2).longValue();
                    }
                }
                this.throwBadObjectException(this.class2);
                break;
            }
            default: {
                this.throwBadObjectException(this.class1);
            }
        }
        return null;
    }

    Object between() throws Exception {
        Object res = this.ge();
        if (res == null) {
            return null;
        }
        if (!((Boolean)res).booleanValue()) {
            return res;
        }
        Object oper4 = this.oper2;
        this.oper2 = this.oper3;
        res = this.le();
        this.oper2 = oper4;
        return res;
    }

    Object not_between() throws Exception {
        Object res = this.lt();
        if (res == null) {
            return null;
        }
        if (((Boolean)res).booleanValue()) {
            return res;
        }
        Object oper4 = this.oper2;
        this.oper2 = this.oper3;
        res = this.gt();
        this.oper2 = oper4;
        return res;
    }

    Object like(boolean not, boolean use_escape) throws Exception {
        Character escapeChar = null;
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 != 4) {
            this.throwBadObjectException(this.class1);
        }
        this.computeArgument2();
        if (this.arg2 == null) {
            return Boolean.FALSE;
        }
        if (this.class2 != 4) {
            this.throwBadObjectException(this.class2);
        }
        if (use_escape) {
            SimpleString escapeString;
            this.computeArgument3();
            if (this.arg3 == null) {
                return null;
            }
            if (this.class3 != 4) {
                this.throwBadObjectException(this.class3);
            }
            if ((escapeString = (SimpleString)this.arg3).length() != 1) {
                throw new Exception("LIKE ESCAPE: Bad escape character " + escapeString.toString());
            }
            escapeChar = Character.valueOf(escapeString.charAt(0));
        }
        if (this.re == null) {
            this.re = new RegExp(this.arg2.toString(), escapeChar);
        }
        boolean result = this.re.isMatch(this.arg1);
        if (not) {
            boolean bl = result = !result;
        }
        if (result) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Object in() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return false;
        }
        if (this.class1 != 4) {
            this.throwBadObjectException(this.class1);
        }
        if (((HashSet)this.oper2).contains(this.arg1)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Object not_in() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 != 4) {
            this.throwBadObjectException(this.class1);
        }
        if (((HashSet)this.oper2).contains(this.arg1)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    void computeArgument1() throws Exception {
        if (this.oper1 == null) {
            this.class1 = 0;
            return;
        }
        Class<?> className = this.oper1.getClass();
        this.arg1 = className == Identifier.class ? ((Identifier)this.oper1).getValue() : (className == Operator.class ? ((Operator)this.oper1).apply() : this.oper1);
        if (this.arg1 == null) {
            this.class1 = 0;
            return;
        }
        className = this.arg1.getClass();
        if (className == SimpleString.class) {
            this.class1 = 4;
        } else if (className == Double.class) {
            this.class1 = 1;
        } else if (className == Long.class) {
            this.class1 = 2;
        } else if (className == Integer.class) {
            this.class1 = 2;
            this.arg1 = ((Integer)this.arg1).longValue();
        } else if (className == Short.class) {
            this.class1 = 2;
            this.arg1 = ((Short)this.arg1).longValue();
        } else if (className == Byte.class) {
            this.class1 = 2;
            this.arg1 = ((Byte)this.arg1).longValue();
        } else if (className == Float.class) {
            this.class1 = 1;
            this.arg1 = ((Float)this.arg1).doubleValue();
        } else if (className == Boolean.class) {
            this.class1 = 3;
        } else {
            this.throwBadObjectException(className);
        }
    }

    void computeArgument2() throws Exception {
        if (this.oper2 == null) {
            this.class2 = 0;
            return;
        }
        Class<?> className = this.oper2.getClass();
        this.arg2 = className == Identifier.class ? ((Identifier)this.oper2).getValue() : (className == Operator.class ? ((Operator)this.oper2).apply() : this.oper2);
        if (this.arg2 == null) {
            this.class2 = 0;
            return;
        }
        className = this.arg2.getClass();
        if (className == SimpleString.class) {
            this.class2 = 4;
        } else if (className == Double.class) {
            this.class2 = 1;
        } else if (className == Long.class) {
            this.class2 = 2;
        } else if (className == Integer.class) {
            this.class2 = 2;
            this.arg2 = ((Integer)this.arg2).longValue();
        } else if (className == Short.class) {
            this.class2 = 2;
            this.arg2 = ((Short)this.arg2).longValue();
        } else if (className == Byte.class) {
            this.class2 = 2;
            this.arg2 = ((Byte)this.arg2).longValue();
        } else if (className == Float.class) {
            this.class2 = 1;
            this.arg2 = ((Float)this.arg2).doubleValue();
        } else if (className == Boolean.class) {
            this.class2 = 3;
        } else {
            this.throwBadObjectException(className);
        }
    }

    void computeArgument3() throws Exception {
        if (this.oper3 == null) {
            this.class3 = 0;
            return;
        }
        Class<?> className = this.oper3.getClass();
        this.arg3 = className == Identifier.class ? ((Identifier)this.oper3).getValue() : (className == Operator.class ? ((Operator)this.oper3).apply() : this.oper3);
        if (this.arg3 == null) {
            this.class3 = 0;
            return;
        }
        className = this.arg3.getClass();
        if (className == SimpleString.class) {
            this.class3 = 4;
        } else if (className == Double.class) {
            this.class3 = 1;
        } else if (className == Long.class) {
            this.class3 = 2;
        } else if (className == Integer.class) {
            this.class3 = 2;
            this.arg3 = ((Integer)this.arg3).longValue();
        } else if (className == Short.class) {
            this.class3 = 2;
            this.arg3 = ((Short)this.arg3).longValue();
        } else if (className == Byte.class) {
            this.class3 = 2;
            this.arg3 = ((Byte)this.arg3).longValue();
        } else if (className == Float.class) {
            this.class3 = 1;
            this.arg3 = ((Float)this.arg3).doubleValue();
        } else if (className == Boolean.class) {
            this.class3 = 3;
        } else {
            this.throwBadObjectException(className);
        }
    }

    public Object apply() throws Exception {
        switch (this.operation) {
            case 0: {
                return this.equal();
            }
            case 1: {
                return this.not();
            }
            case 2: {
                return this.and();
            }
            case 3: {
                return this.or();
            }
            case 4: {
                return this.gt();
            }
            case 5: {
                return this.ge();
            }
            case 6: {
                return this.lt();
            }
            case 7: {
                return this.le();
            }
            case 8: {
                return this.different();
            }
            case 9: {
                return this.add();
            }
            case 10: {
                return this.sub();
            }
            case 11: {
                return this.neg();
            }
            case 12: {
                return this.mul();
            }
            case 13: {
                return this.div();
            }
            case 14: {
                return this.between();
            }
            case 15: {
                return this.not_between();
            }
            case 16: {
                return this.like(false, false);
            }
            case 17: {
                return this.like(true, false);
            }
            case 18: {
                return this.like(false, true);
            }
            case 19: {
                return this.like(true, true);
            }
            case 20: {
                return this.is_null();
            }
            case 21: {
                return this.is_not_null();
            }
            case 22: {
                return this.in();
            }
            case 23: {
                return this.not_in();
            }
        }
        throw HornetQMessageBundle.BUNDLE.noOperationMapped(this.operation);
    }

    public void throwBadObjectException(Class<?> class1) throws Exception {
        throw new Exception("Bad Object: '" + class1.getName() + "' for operation: " + this.toString());
    }

    public void throwBadObjectException(int class1) throws Exception {
        throw new Exception("Bad Object: '" + Operator.getClassName(class1) + "' for operation: " + this.toString());
    }

    public void throwBadObjectException(int class1, int class2) throws Exception {
        throw new Exception("Bad Object: expected '" + Operator.getClassName(class1) + "' got '" + Operator.getClassName(class2) + "' for operation: " + this.toString());
    }

    static String getClassName(int class1) {
        switch (class1) {
            case 4: {
                return "SimpleString";
            }
            case 2: {
                return "Long";
            }
            case 1: {
                return "Double";
            }
            case 3: {
                return "Boolean";
            }
        }
        return "Unknown";
    }

    static String operationString(int operation) {
        switch (operation) {
            case 0: {
                return "EQUAL";
            }
            case 1: {
                return "NOT";
            }
            case 2: {
                return "AND";
            }
            case 3: {
                return "OR";
            }
            case 4: {
                return "GT";
            }
            case 5: {
                return "GE";
            }
            case 6: {
                return "LT";
            }
            case 7: {
                return "LE";
            }
            case 8: {
                return "DIFFERENT";
            }
            case 9: {
                return "ADD";
            }
            case 10: {
                return "SUB";
            }
            case 11: {
                return "NEG";
            }
            case 12: {
                return "MUL";
            }
            case 13: {
                return "DIV";
            }
            case 14: {
                return "BETWEEN";
            }
            case 15: {
                return "NOT_BETWEEN";
            }
            case 16: {
                return "LIKE";
            }
            case 17: {
                return "NOT_LIKE";
            }
            case 18: {
                return "LIKE_ESCAPE";
            }
            case 19: {
                return "NOT_LIKE_ESCAPE";
            }
            case 20: {
                return "IS_NULL";
            }
            case 21: {
                return "IS_NOT_NULL";
            }
            case 22: {
                return "IN";
            }
            case 23: {
                return "NOT_IN";
            }
        }
        return "Unknown";
    }
}

