/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.filter.impl;

import java.io.IOException;
import java.io.Reader;
import org.hornetq.api.core.SimpleString;

public class SimpleStringReader
extends Reader {
    private final SimpleString simpleString;
    private int next = 0;

    public SimpleStringReader(SimpleString simpleString) {
        this.simpleString = simpleString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        SimpleString simpleString = this.simpleString;
        synchronized (simpleString) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int length = this.simpleString.length();
            if (this.next >= length) {
                return -1;
            }
            int n = Math.min(length - this.next, len);
            this.simpleString.getChars(this.next, this.next + n, cbuf, off);
            this.next += n;
            return n;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

