/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.message.impl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQPropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.buffers.impl.ResetLimitWrappedHornetQBuffer;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUID;

public abstract class MessageImpl
implements MessageInternal {
    public static final SimpleString HDR_ROUTE_TO_IDS = new SimpleString("_HQ_ROUTE_TO");
    public static final SimpleString HDR_BRIDGE_DUPLICATE_ID = new SimpleString("_HQ_BRIDGE_DUP");
    public static final int BUFFER_HEADER_SPACE = 13;
    public static final int BODY_OFFSET = 17;
    protected long messageID;
    protected SimpleString address;
    protected byte type;
    protected boolean durable;
    private long expiration;
    protected long timestamp;
    protected TypedProperties properties;
    protected byte priority;
    protected HornetQBuffer buffer;
    protected ResetLimitWrappedHornetQBuffer bodyBuffer;
    protected volatile boolean bufferValid;
    private int endOfBodyPosition = -1;
    private int endOfMessagePosition;
    private boolean copied = true;
    private boolean bufferUsed;
    private UUID userID;

    protected MessageImpl() {
        this.properties = new TypedProperties();
    }

    protected MessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize) {
        this();
        this.type = type;
        this.durable = durable;
        this.expiration = expiration;
        this.timestamp = timestamp;
        this.priority = priority;
        this.createBody(initialMessageBufferSize);
    }

    protected MessageImpl(long messageID, int initialMessageBufferSize) {
        this(initialMessageBufferSize);
        this.messageID = messageID;
    }

    protected MessageImpl(int initialMessageBufferSize) {
        this();
        this.createBody(initialMessageBufferSize);
    }

    protected MessageImpl(MessageImpl other) {
        this(other, other.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageImpl(MessageImpl other, TypedProperties properties) {
        this.messageID = other.getMessageID();
        this.userID = other.getUserID();
        this.address = other.getAddress();
        this.type = other.getType();
        this.durable = other.isDurable();
        this.expiration = other.getExpiration();
        this.timestamp = other.getTimestamp();
        this.priority = other.getPriority();
        this.properties = new TypedProperties(properties);
        MessageImpl messageImpl = other;
        synchronized (messageImpl) {
            this.bufferValid = other.bufferValid;
            this.endOfBodyPosition = other.endOfBodyPosition;
            this.endOfMessagePosition = other.endOfMessagePosition;
            this.copied = other.copied;
            if (other.buffer != null) {
                this.createBody(other.buffer.capacity());
                this.buffer = other.buffer.copy(0, other.buffer.capacity());
                this.buffer.setIndex(other.buffer.readerIndex(), other.buffer.writerIndex());
            }
        }
    }

    @Override
    public int getEncodeSize() {
        int headersPropsSize = this.getHeadersAndPropertiesEncodeSize();
        int bodyPos = this.endOfBodyPosition == -1 ? this.buffer.writerIndex() : this.endOfBodyPosition;
        int bodySize = bodyPos - 13 - 4;
        return 4 + bodySize + 4 + headersPropsSize;
    }

    @Override
    public int getHeadersAndPropertiesEncodeSize() {
        return 9 + (this.userID == null ? 0 : 16) + SimpleString.sizeofNullableString((SimpleString)this.address) + 1 + 1 + 8 + 8 + 1 + this.properties.getEncodeSize();
    }

    @Override
    public void encodeHeadersAndProperties(HornetQBuffer buffer) {
        buffer.writeLong(this.messageID);
        buffer.writeNullableSimpleString(this.address);
        if (this.userID == null) {
            buffer.writeByte((byte)0);
        } else {
            buffer.writeByte((byte)1);
            buffer.writeBytes(this.userID.asBytes());
        }
        buffer.writeByte(this.type);
        buffer.writeBoolean(this.durable);
        buffer.writeLong(this.expiration);
        buffer.writeLong(this.timestamp);
        buffer.writeByte(this.priority);
        this.properties.encode(buffer);
    }

    @Override
    public void decodeHeadersAndProperties(HornetQBuffer buffer) {
        this.messageID = buffer.readLong();
        this.address = buffer.readNullableSimpleString();
        if (buffer.readByte() == 1) {
            byte[] bytes = new byte[16];
            buffer.readBytes(bytes);
            this.userID = new UUID(1, bytes);
        } else {
            this.userID = null;
        }
        this.type = buffer.readByte();
        this.durable = buffer.readBoolean();
        this.expiration = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.priority = buffer.readByte();
        this.properties.decode(buffer);
    }

    public void copyHeadersAndProperties(MessageInternal msg) {
        this.messageID = msg.getMessageID();
        this.address = msg.getAddress();
        this.userID = msg.getUserID();
        this.type = msg.getType();
        this.durable = msg.isDurable();
        this.expiration = msg.getExpiration();
        this.timestamp = msg.getTimestamp();
        this.priority = msg.getPriority();
        this.properties = msg.getTypedProperties();
    }

    @Override
    public HornetQBuffer getBodyBuffer() {
        if (this.bodyBuffer == null) {
            this.bodyBuffer = new ResetLimitWrappedHornetQBuffer(17, this.buffer, this);
        }
        return this.bodyBuffer;
    }

    @Override
    public long getMessageID() {
        return this.messageID;
    }

    @Override
    public UUID getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(UUID userID) {
        this.userID = userID;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAddress(SimpleString address) {
        MessageImpl messageImpl = this;
        synchronized (messageImpl) {
            if (this.address != address) {
                this.address = address;
                this.bufferValid = false;
            }
        }
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public void setDurable(boolean durable) {
        if (this.durable != durable) {
            this.durable = durable;
            this.bufferValid = false;
        }
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public void setExpiration(long expiration) {
        if (this.expiration != expiration) {
            this.expiration = expiration;
            this.bufferValid = false;
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        if (this.timestamp != timestamp) {
            this.timestamp = timestamp;
            this.bufferValid = false;
        }
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        if (this.priority != priority) {
            this.priority = priority;
            this.bufferValid = false;
        }
    }

    @Override
    public boolean isExpired() {
        if (this.expiration == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.expiration >= 0L;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageID", this.messageID);
        if (this.userID != null) {
            map.put("userID", "ID:" + this.userID.toString());
        }
        map.put("address", this.address.toString());
        map.put("type", this.type);
        map.put("durable", this.durable);
        map.put("expiration", this.expiration);
        map.put("timestamp", this.timestamp);
        map.put("priority", this.priority);
        for (SimpleString propName : this.properties.getPropertyNames()) {
            map.put(propName.toString(), this.properties.getProperty(propName));
        }
        return map;
    }

    @Override
    public void decodeFromBuffer(HornetQBuffer buffer) {
        this.buffer = buffer;
        this.decode();
    }

    @Override
    public void bodyChanged() {
        this.checkCopy();
        this.bufferValid = false;
        this.endOfBodyPosition = -1;
    }

    @Override
    public synchronized void checkCopy() {
        if (!this.copied) {
            this.forceCopy();
            this.copied = true;
        }
    }

    @Override
    public synchronized void resetCopied() {
        this.copied = false;
    }

    @Override
    public int getEndOfMessagePosition() {
        return this.endOfMessagePosition;
    }

    @Override
    public int getEndOfBodyPosition() {
        return this.endOfBodyPosition;
    }

    public void encode(HornetQBuffer buff) {
        this.encodeToBuffer();
        buff.writeBytes(this.buffer, 13, this.endOfMessagePosition - 13);
    }

    public void decode(HornetQBuffer buff) {
        int start = buff.readerIndex();
        this.endOfBodyPosition = buff.readInt();
        this.endOfMessagePosition = buff.getInt(this.endOfBodyPosition - 13 + start);
        int length = this.endOfMessagePosition - 13;
        this.buffer.setIndex(0, 13);
        this.buffer.writeBytes(buff, start, length);
        this.decode();
        buff.readerIndex(start + length);
    }

    @Override
    public synchronized HornetQBuffer getEncodedBuffer() {
        HornetQBuffer buff = this.encodeToBuffer();
        if (this.bufferUsed) {
            HornetQBuffer copied = buff.copy(0, buff.capacity());
            copied.setIndex(0, this.endOfMessagePosition);
            return copied;
        }
        this.buffer.setIndex(0, this.endOfMessagePosition);
        this.bufferUsed = true;
        return this.buffer;
    }

    @Override
    public void setAddressTransient(SimpleString address) {
        this.address = address;
    }

    @Override
    public void putBooleanProperty(SimpleString key, boolean value) {
        this.properties.putBooleanProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putByteProperty(SimpleString key, byte value) {
        this.properties.putByteProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putBytesProperty(SimpleString key, byte[] value) {
        this.properties.putBytesProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putShortProperty(SimpleString key, short value) {
        this.properties.putShortProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putIntProperty(SimpleString key, int value) {
        this.properties.putIntProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putLongProperty(SimpleString key, long value) {
        this.properties.putLongProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putFloatProperty(SimpleString key, float value) {
        this.properties.putFloatProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putDoubleProperty(SimpleString key, double value) {
        this.properties.putDoubleProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putStringProperty(SimpleString key, SimpleString value) {
        this.properties.putSimpleStringProperty(key, value);
        this.bufferValid = false;
    }

    @Override
    public void putObjectProperty(SimpleString key, Object value) throws HornetQPropertyConversionException {
        if (value == null) {
            this.properties.putNullValue(key);
        } else if (value instanceof Boolean) {
            this.properties.putBooleanProperty(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            this.properties.putByteProperty(key, ((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.properties.putShortProperty(key, ((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.properties.putIntProperty(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.properties.putLongProperty(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            this.properties.putFloatProperty(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.properties.putDoubleProperty(key, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            this.properties.putSimpleStringProperty(key, new SimpleString((String)value));
        } else if (value instanceof SimpleString) {
            this.properties.putSimpleStringProperty(key, (SimpleString)value);
        } else {
            throw new HornetQPropertyConversionException(value.getClass() + " is not a valid property type");
        }
        this.bufferValid = false;
    }

    @Override
    public void putObjectProperty(String key, Object value) throws HornetQPropertyConversionException {
        this.putObjectProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putBooleanProperty(String key, boolean value) {
        this.properties.putBooleanProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putByteProperty(String key, byte value) {
        this.properties.putByteProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putBytesProperty(String key, byte[] value) {
        this.properties.putBytesProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putShortProperty(String key, short value) {
        this.properties.putShortProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putIntProperty(String key, int value) {
        this.properties.putIntProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putLongProperty(String key, long value) {
        this.properties.putLongProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putFloatProperty(String key, float value) {
        this.properties.putFloatProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putDoubleProperty(String key, double value) {
        this.properties.putDoubleProperty(new SimpleString(key), value);
        this.bufferValid = false;
    }

    @Override
    public void putStringProperty(String key, String value) {
        this.properties.putSimpleStringProperty(new SimpleString(key), SimpleString.toSimpleString((String)value));
        this.bufferValid = false;
    }

    public void putTypedProperties(TypedProperties otherProps) {
        this.properties.putTypedProperties(otherProps);
        this.bufferValid = false;
    }

    @Override
    public Object getObjectProperty(SimpleString key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Boolean getBooleanProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getBooleanProperty(key);
    }

    @Override
    public Boolean getBooleanProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getBooleanProperty(new SimpleString(key));
    }

    @Override
    public Byte getByteProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getByteProperty(key);
    }

    @Override
    public Byte getByteProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getByteProperty(new SimpleString(key));
    }

    @Override
    public byte[] getBytesProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getBytesProperty(key);
    }

    @Override
    public byte[] getBytesProperty(String key) throws HornetQPropertyConversionException {
        return this.getBytesProperty(new SimpleString(key));
    }

    @Override
    public Double getDoubleProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getDoubleProperty(key);
    }

    @Override
    public Double getDoubleProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getDoubleProperty(new SimpleString(key));
    }

    @Override
    public Integer getIntProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getIntProperty(key);
    }

    @Override
    public Integer getIntProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getIntProperty(new SimpleString(key));
    }

    @Override
    public Long getLongProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getLongProperty(key);
    }

    @Override
    public Long getLongProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getLongProperty(new SimpleString(key));
    }

    @Override
    public Short getShortProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getShortProperty(key);
    }

    @Override
    public Short getShortProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getShortProperty(new SimpleString(key));
    }

    @Override
    public Float getFloatProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getFloatProperty(key);
    }

    @Override
    public Float getFloatProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getFloatProperty(new SimpleString(key));
    }

    @Override
    public String getStringProperty(SimpleString key) throws HornetQPropertyConversionException {
        SimpleString str = this.getSimpleStringProperty(key);
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    @Override
    public String getStringProperty(String key) throws HornetQPropertyConversionException {
        return this.getStringProperty(new SimpleString(key));
    }

    @Override
    public SimpleString getSimpleStringProperty(SimpleString key) throws HornetQPropertyConversionException {
        return this.properties.getSimpleStringProperty(key);
    }

    @Override
    public SimpleString getSimpleStringProperty(String key) throws HornetQPropertyConversionException {
        return this.properties.getSimpleStringProperty(new SimpleString(key));
    }

    @Override
    public Object getObjectProperty(String key) {
        return this.properties.getProperty(new SimpleString(key));
    }

    @Override
    public Object removeProperty(SimpleString key) {
        this.bufferValid = false;
        return this.properties.removeProperty(key);
    }

    @Override
    public Object removeProperty(String key) {
        this.bufferValid = false;
        return this.properties.removeProperty(new SimpleString(key));
    }

    @Override
    public boolean containsProperty(SimpleString key) {
        return this.properties.containsProperty(key);
    }

    @Override
    public boolean containsProperty(String key) {
        return this.properties.containsProperty(new SimpleString(key));
    }

    @Override
    public Set<SimpleString> getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    @Override
    public HornetQBuffer getWholeBuffer() {
        return this.buffer;
    }

    @Override
    public BodyEncoder getBodyEncoder() throws HornetQException {
        return new DecodingContext();
    }

    @Override
    public TypedProperties getTypedProperties() {
        return this.properties;
    }

    private TypedProperties getProperties() {
        return this.properties;
    }

    private synchronized HornetQBuffer encodeToBuffer() {
        if (!this.bufferValid) {
            if (this.bufferUsed) {
                this.forceCopy();
            }
            if (this.endOfBodyPosition == -1) {
                this.endOfBodyPosition = this.buffer.writerIndex();
            }
            this.buffer.setInt(13, this.endOfBodyPosition);
            if (this.endOfBodyPosition + 4 > this.buffer.capacity()) {
                this.buffer.setIndex(0, this.endOfBodyPosition);
                this.buffer.writeInt(0);
            } else {
                this.buffer.setIndex(0, this.endOfBodyPosition + 4);
            }
            this.encodeHeadersAndProperties(this.buffer);
            this.endOfMessagePosition = this.buffer.writerIndex();
            this.buffer.setInt(this.endOfBodyPosition, this.endOfMessagePosition);
            this.bufferValid = true;
        }
        return this.buffer;
    }

    private void decode() {
        this.endOfBodyPosition = this.buffer.getInt(13);
        this.buffer.readerIndex(this.endOfBodyPosition + 4);
        this.decodeHeadersAndProperties(this.buffer);
        this.endOfMessagePosition = this.buffer.readerIndex();
        this.bufferValid = true;
    }

    protected void createBody(int initialMessageBufferSize) {
        this.buffer = HornetQBuffers.dynamicBuffer((int)initialMessageBufferSize);
        this.buffer.writeByte((byte)0);
        int limit = 17;
        this.buffer.setIndex(limit, limit);
    }

    private void forceCopy() {
        this.buffer = this.buffer.copy(0, this.buffer.capacity());
        this.buffer.setIndex(0, this.endOfBodyPosition);
        if (this.bodyBuffer != null) {
            this.bodyBuffer.setBuffer(this.buffer);
        }
        this.bufferUsed = false;
    }

    private final class DecodingContext
    implements BodyEncoder {
        private int lastPos = 0;

        @Override
        public void open() {
        }

        @Override
        public void close() {
        }

        @Override
        public long getLargeBodySize() {
            return MessageImpl.this.buffer.writerIndex();
        }

        @Override
        public int encode(ByteBuffer bufferRead) throws HornetQException {
            HornetQBuffer buffer = HornetQBuffers.wrappedBuffer((ByteBuffer)bufferRead);
            return this.encode(buffer, bufferRead.capacity());
        }

        @Override
        public int encode(HornetQBuffer bufferOut, int size) {
            bufferOut.writeBytes(MessageImpl.this.getWholeBuffer(), this.lastPos, size);
            this.lastPos += size;
            return size;
        }
    }
}

