/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.messagecounter.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.MessageCounterManager;

public class MessageCounterManagerImpl
implements MessageCounterManager {
    public static final long DEFAULT_SAMPLE_PERIOD = 10000L;
    public static final long MIN_SAMPLE_PERIOD = 1000L;
    public static final int DEFAULT_MAX_DAY_COUNT = 10;
    private final Map<String, MessageCounter> messageCounters = new HashMap<String, MessageCounter>();
    private boolean started;
    private long period = 10000L;
    private MessageCountersPinger messageCountersPinger;
    private int maxDayCount = 10;
    private final ScheduledExecutorService scheduledThreadPool;

    public MessageCounterManagerImpl(ScheduledExecutorService scheduledThreadPool) {
        this.scheduledThreadPool = scheduledThreadPool;
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.messageCountersPinger = new MessageCountersPinger();
        ScheduledFuture<?> future = this.scheduledThreadPool.scheduleAtFixedRate(this.messageCountersPinger, 0L, this.period, TimeUnit.MILLISECONDS);
        this.messageCountersPinger.setFuture(future);
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.messageCountersPinger.stop();
        this.started = false;
    }

    @Override
    public synchronized void clear() {
        this.messageCounters.clear();
    }

    @Override
    public synchronized void reschedule(long newPeriod) {
        boolean wasStarted = this.started;
        if (wasStarted) {
            this.stop();
        }
        this.period = newPeriod;
        if (wasStarted) {
            this.start();
        }
    }

    @Override
    public long getSamplePeriod() {
        return this.period;
    }

    @Override
    public int getMaxDayCount() {
        return this.maxDayCount;
    }

    @Override
    public void setMaxDayCount(int count) {
        this.maxDayCount = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessageCounter(String name, MessageCounter counter) {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            this.messageCounters.put(name, counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageCounter unregisterMessageCounter(String name) {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            return this.messageCounters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageCounter> getMessageCounters() {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            return new HashSet<MessageCounter>(this.messageCounters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageCounter getMessageCounter(String name) {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            return this.messageCounters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllCounters() {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            for (MessageCounter counter : this.messageCounters.values()) {
                counter.resetCounter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllCounterHistories() {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            for (MessageCounter counter : this.messageCounters.values()) {
                counter.resetHistory();
            }
        }
    }

    class MessageCountersPinger
    implements Runnable {
        private boolean closed = false;
        private Future<?> future;

        MessageCountersPinger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            if (this.closed) {
                return;
            }
            Map map = MessageCounterManagerImpl.this.messageCounters;
            synchronized (map) {
                for (MessageCounter counter : MessageCounterManagerImpl.this.messageCounters.values()) {
                    counter.onTimer();
                }
            }
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.closed = true;
        }
    }
}

