/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.PagingStoreFactory;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;

public class PagingManagerImpl
implements PagingManager {
    private volatile boolean started = false;
    private final ReentrantReadWriteLock syncLock = new ReentrantReadWriteLock();
    private final ConcurrentMap<SimpleString, PagingStore> stores = new ConcurrentHashMap<SimpleString, PagingStore>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final PagingStoreFactory pagingStoreFactory;
    private final StorageManager storageManager;
    private final ConcurrentMap<Long, PageTransactionInfo> transactions = new ConcurrentHashMap<Long, PageTransactionInfo>();
    private static boolean isTrace = HornetQLogger.LOGGER.isTraceEnabled();

    public PagingManagerImpl(PagingStoreFactory pagingSPI, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this.pagingStoreFactory = pagingSPI;
        this.addressSettingsRepository = addressSettingsRepository;
        addressSettingsRepository.registerListener(this);
        this.storageManager = storageManager;
    }

    @Override
    public void onChange() {
        this.reaplySettings();
    }

    private void reaplySettings() {
        for (PagingStore store : this.stores.values()) {
            AddressSettings settings = this.addressSettingsRepository.getMatch(store.getAddress().toString());
            store.applySetting(settings);
        }
    }

    @Override
    public SimpleString[] getStoreNames() {
        Set names = this.stores.keySet();
        return names.toArray(new SimpleString[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadStores() throws Exception {
        this.lock();
        try {
            List<PagingStore> reloadedStores = this.pagingStoreFactory.reloadStores(this.addressSettingsRepository);
            for (PagingStore store : reloadedStores) {
                store.start();
                this.stores.put(store.getStoreName(), store);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePageStore(SimpleString storeName) throws Exception {
        this.syncLock.readLock().lock();
        try {
            PagingStore store = (PagingStore)this.stores.remove(storeName);
            if (store != null) {
                store.stop();
            }
        }
        finally {
            this.syncLock.readLock().unlock();
        }
    }

    @Override
    public PagingStore getPageStore(SimpleString storeName) throws Exception {
        PagingStore store = (PagingStore)this.stores.get(storeName);
        if (store != null) {
            return store;
        }
        return this.newStore(storeName);
    }

    @Override
    public void setPostOffice(PostOffice postOffice) {
        this.pagingStoreFactory.setPostOffice(postOffice);
    }

    @Override
    public void addTransaction(PageTransactionInfo pageTransaction) {
        if (isTrace) {
            HornetQLogger.LOGGER.trace("Adding pageTransaction " + pageTransaction.getTransactionID());
        }
        this.transactions.put(pageTransaction.getTransactionID(), pageTransaction);
    }

    @Override
    public void removeTransaction(long id) {
        if (isTrace) {
            HornetQLogger.LOGGER.trace("Removing pageTransaction " + id);
        }
        this.transactions.remove(id);
    }

    @Override
    public PageTransactionInfo getTransaction(long id) {
        if (isTrace) {
            HornetQLogger.LOGGER.trace("looking up pageTX = " + id);
        }
        return (PageTransactionInfo)this.transactions.get(id);
    }

    @Override
    public Map<Long, PageTransactionInfo> getTransactions() {
        return this.transactions;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.lock();
        try {
            if (this.started) {
                return;
            }
            this.pagingStoreFactory.setPagingManager(this);
            this.pagingStoreFactory.setStorageManager(this.storageManager);
            this.reloadStores();
            this.started = true;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.lock();
        try {
            for (PagingStore store : this.stores.values()) {
                store.stop();
            }
            this.pagingStoreFactory.stop();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void processReload() throws Exception {
        for (PagingStore store : this.stores.values()) {
            store.processReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PagingStore newStore(SimpleString address) throws Exception {
        this.syncLock.readLock().lock();
        try {
            PagingStore store = (PagingStore)this.stores.get(address);
            if (store == null) {
                store = this.pagingStoreFactory.newStore(address, this.addressSettingsRepository.getMatch(address.toString()));
                store.start();
                this.stores.put(address, store);
            }
            PagingStore pagingStore = store;
            return pagingStore;
        }
        finally {
            this.syncLock.readLock().unlock();
        }
    }

    protected PagingStoreFactory getStoreFactory() {
        return this.pagingStoreFactory;
    }

    @Override
    public void unlock() {
        this.syncLock.writeLock().unlock();
    }

    @Override
    public void lock() {
        this.syncLock.writeLock().lock();
    }
}

