/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.remoting.ReadyListener;

public final class CoreSessionCallback
implements SessionCallback {
    private final Channel channel;
    private ProtocolManager protocolManager;
    private String name;

    public CoreSessionCallback(String name, ProtocolManager protocolManager, Channel channel) {
        this.name = name;
        this.protocolManager = protocolManager;
        this.channel = channel;
    }

    @Override
    public int sendLargeMessage(ServerMessage message, long consumerID, long bodySize, int deliveryCount) {
        SessionReceiveLargeMessage packet = new SessionReceiveLargeMessage(consumerID, message, bodySize, deliveryCount);
        this.channel.send(packet);
        int size = packet.getPacketSize();
        return size;
    }

    @Override
    public int sendLargeMessageContinuation(long consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        SessionReceiveContinuationMessage packet = new SessionReceiveContinuationMessage(consumerID, body, continues, requiresResponse);
        this.channel.send(packet);
        return packet.getPacketSize();
    }

    @Override
    public int sendMessage(ServerMessage message, long consumerID, int deliveryCount) {
        SessionReceiveMessage packet = new SessionReceiveMessage(consumerID, message, deliveryCount);
        this.channel.sendBatched(packet);
        int size = packet.getPacketSize();
        return size;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        SessionProducerCreditsMessage packet = new SessionProducerCreditsMessage(credits, address);
        this.channel.send(packet);
    }

    @Override
    public void closed() {
        this.protocolManager.removeHandler(this.name);
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
        this.channel.getConnection().getTransportConnection().addReadyListener(listener);
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
        this.channel.getConnection().getTransportConnection().removeReadyListener(listener);
    }
}

