/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.hornetq.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.LiveIsStoppingMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.PacketsConfirmedMessage;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationCompareDataMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeginMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationStartSyncMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.hornetq.core.protocol.core.impl.wireformat.RollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAddMetaDataMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCloseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.hornetq.core.server.HornetQMessageBundle;

public final class PacketDecoder {
    private PacketDecoder() {
    }

    public static Packet decode(HornetQBuffer in) {
        PacketImpl packet;
        byte packetType = in.readByte();
        switch (packetType) {
            case 10: {
                packet = new Ping();
                break;
            }
            case 11: {
                packet = new DisconnectMessage();
                break;
            }
            case 20: {
                packet = new HornetQExceptionMessage();
                break;
            }
            case 22: {
                packet = new PacketsConfirmedMessage();
                break;
            }
            case 30: {
                packet = new CreateSessionMessage();
                break;
            }
            case 31: {
                packet = new CreateSessionResponseMessage();
                break;
            }
            case 32: {
                packet = new ReattachSessionMessage();
                break;
            }
            case 33: {
                packet = new ReattachSessionResponseMessage();
                break;
            }
            case 69: {
                packet = new SessionCloseMessage();
                break;
            }
            case 40: {
                packet = new SessionCreateConsumerMessage();
                break;
            }
            case 41: {
                packet = new SessionAcknowledgeMessage();
                break;
            }
            case 42: {
                packet = new SessionExpireMessage();
                break;
            }
            case 43: {
                packet = new SessionCommitMessage();
                break;
            }
            case 44: {
                packet = new RollbackMessage();
                break;
            }
            case 45: {
                packet = new SessionQueueQueryMessage();
                break;
            }
            case 46: {
                packet = new SessionQueueQueryResponseMessage();
                break;
            }
            case 34: {
                packet = new CreateQueueMessage();
                break;
            }
            case 35: {
                packet = new SessionDeleteQueueMessage();
                break;
            }
            case 49: {
                packet = new SessionBindingQueryMessage();
                break;
            }
            case 50: {
                packet = new SessionBindingQueryResponseMessage();
                break;
            }
            case 51: {
                packet = new SessionXAStartMessage();
                break;
            }
            case 52: {
                packet = new SessionXAEndMessage();
                break;
            }
            case 53: {
                packet = new SessionXACommitMessage();
                break;
            }
            case 54: {
                packet = new SessionXAPrepareMessage();
                break;
            }
            case 55: {
                packet = new SessionXAResponseMessage();
                break;
            }
            case 56: {
                packet = new SessionXARollbackMessage();
                break;
            }
            case 57: {
                packet = new SessionXAJoinMessage();
                break;
            }
            case 58: {
                packet = new PacketImpl(58);
                break;
            }
            case 59: {
                packet = new SessionXAResumeMessage();
                break;
            }
            case 60: {
                packet = new SessionXAForgetMessage();
                break;
            }
            case 61: {
                packet = new PacketImpl(61);
                break;
            }
            case 62: {
                packet = new SessionXAGetInDoubtXidsResponseMessage();
                break;
            }
            case 63: {
                packet = new SessionXASetTimeoutMessage();
                break;
            }
            case 64: {
                packet = new SessionXASetTimeoutResponseMessage();
                break;
            }
            case 65: {
                packet = new PacketImpl(65);
                break;
            }
            case 66: {
                packet = new SessionXAGetTimeoutResponseMessage();
                break;
            }
            case 67: {
                packet = new PacketImpl(67);
                break;
            }
            case 68: {
                packet = new PacketImpl(68);
                break;
            }
            case 70: {
                packet = new SessionConsumerFlowCreditMessage();
                break;
            }
            case 71: {
                packet = new SessionSendMessage();
                break;
            }
            case 72: {
                packet = new SessionSendLargeMessage();
                break;
            }
            case 75: {
                packet = new SessionReceiveMessage();
                break;
            }
            case 76: {
                packet = new SessionReceiveLargeMessage();
                break;
            }
            case 74: {
                packet = new SessionConsumerCloseMessage();
                break;
            }
            case 81: {
                packet = new SessionIndividualAcknowledgeMessage();
                break;
            }
            case 21: {
                packet = new NullResponseMessage();
                break;
            }
            case 77: {
                packet = new SessionReceiveContinuationMessage();
                break;
            }
            case 73: {
                packet = new SessionSendContinuationMessage();
                break;
            }
            case 79: {
                packet = new SessionRequestProducerCreditsMessage();
                break;
            }
            case 80: {
                packet = new SessionProducerCreditsMessage();
                break;
            }
            case 91: {
                packet = new ReplicationAddMessage();
                break;
            }
            case 92: {
                packet = new ReplicationAddTXMessage();
                break;
            }
            case 93: {
                packet = new ReplicationDeleteMessage();
                break;
            }
            case 94: {
                packet = new ReplicationDeleteTXMessage();
                break;
            }
            case 95: {
                packet = new ReplicationPrepareMessage();
                break;
            }
            case 96: {
                packet = new ReplicationCommitMessage();
                break;
            }
            case 90: {
                packet = new ReplicationResponseMessage();
                break;
            }
            case 97: {
                packet = new ReplicationPageWriteMessage();
                break;
            }
            case 98: {
                packet = new ReplicationPageEventMessage();
                break;
            }
            case 99: {
                packet = new ReplicationLargeMessageBeginMessage();
                break;
            }
            case 100: {
                packet = new ReplicationLargeMessageEndMessage();
                break;
            }
            case 101: {
                packet = new ReplicationLargeMessageWriteMessage();
                break;
            }
            case 102: {
                packet = new ReplicationCompareDataMessage();
                break;
            }
            case 78: {
                packet = new SessionForceConsumerDelivery();
                break;
            }
            case 110: {
                packet = new ClusterTopologyChangeMessage();
                break;
            }
            case 114: {
                packet = new ClusterTopologyChangeMessage_V2();
                break;
            }
            case 111: {
                packet = new NodeAnnounceMessage();
                break;
            }
            case 112: {
                packet = new SubscribeClusterTopologyUpdatesMessage();
                break;
            }
            case 113: {
                packet = new SubscribeClusterTopologyUpdatesMessageV2();
                break;
            }
            case 104: {
                packet = new SessionAddMetaDataMessage();
                break;
            }
            case 105: {
                packet = new SessionAddMetaDataMessageV2();
                break;
            }
            case 106: {
                packet = new SessionUniqueAddMetaDataMessage();
                break;
            }
            case 115: {
                packet = new BackupRegistrationMessage();
                break;
            }
            case 116: {
                packet = new BackupReplicationStartFailedMessage();
                break;
            }
            case 120: {
                packet = new ReplicationStartSyncMessage();
                break;
            }
            case 103: {
                packet = new ReplicationSyncFileMessage();
                break;
            }
            case 121: {
                packet = new LiveIsStoppingMessage();
                break;
            }
            default: {
                throw HornetQMessageBundle.BUNDLE.invalidType(packetType);
            }
        }
        packet.decode(in);
        return packet;
    }
}

