/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public final class BackupReplicationStartFailedMessage
extends PacketImpl {
    private HornetQExceptionType errorCode;
    private BackupRegistrationProblem problem;
    private String msg;

    public BackupReplicationStartFailedMessage(HornetQException e) {
        super((byte)116);
        if (e != null) {
            this.msg = e.getMessage();
            this.errorCode = e.getType();
            this.problem = BackupRegistrationProblem.EXCEPTION;
        } else {
            this.problem = BackupRegistrationProblem.AUTHENTICATION;
        }
    }

    public BackupReplicationStartFailedMessage() {
        super((byte)116);
    }

    public HornetQExceptionType getCause() {
        return this.errorCode;
    }

    public HornetQException getException() {
        if (this.errorCode == null) {
            return null;
        }
        return HornetQExceptionType.createException((int)this.errorCode.getCode(), (String)this.msg);
    }

    public BackupRegistrationProblem getRegistrationProblem() {
        return this.problem;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.problem.code);
        if (this.problem == BackupRegistrationProblem.EXCEPTION) {
            buffer.writeInt(this.errorCode != null ? this.errorCode.getCode() : -1);
            buffer.writeNullableString(this.msg);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        if (buffer.readInt() == BackupRegistrationProblem.AUTHENTICATION.code) {
            this.problem = BackupRegistrationProblem.AUTHENTICATION;
        } else {
            this.problem = BackupRegistrationProblem.EXCEPTION;
            this.errorCode = HornetQExceptionType.getType((int)buffer.readInt());
            this.msg = buffer.readNullableString();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
        result = 31 * result + (this.problem == null ? 0 : this.problem.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BackupReplicationStartFailedMessage)) {
            return false;
        }
        BackupReplicationStartFailedMessage other = (BackupReplicationStartFailedMessage)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.msg == null ? other.msg != null : !this.msg.equals(other.msg)) {
            return false;
        }
        return this.problem == other.problem;
    }

    static enum BackupRegistrationProblem {
        EXCEPTION(0),
        AUTHENTICATION(1);

        final int code;

        private BackupRegistrationProblem(int code) {
            this.code = code;
        }
    }
}

