/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp.v11;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.protocol.stomp.StompFrame;

public class StompFrameV11
extends StompFrame {
    private final List<StompFrame.Header> allHeaders = new ArrayList<StompFrame.Header>();

    public StompFrameV11(String command, Map<String, String> headers, byte[] content) {
        super(command, headers, content);
    }

    public StompFrameV11(String command) {
        super(command);
    }

    @Override
    public HornetQBuffer toHornetQBuffer() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.bytesBody != null ? HornetQBuffers.dynamicBuffer((int)(this.bytesBody.length + 512)) : HornetQBuffers.dynamicBuffer((int)512);
            StringBuffer head = new StringBuffer();
            head.append(this.command);
            head.append("\n");
            for (StompFrame.Header h : this.allHeaders) {
                head.append(h.getEscapedKey());
                head.append(":");
                head.append(h.getEscapedValue());
                head.append("\n");
            }
            head.append("\n");
            this.buffer.writeBytes(head.toString().getBytes("UTF-8"));
            if (this.bytesBody != null) {
                this.buffer.writeBytes(this.bytesBody);
            }
            this.buffer.writeBytes(END_OF_FRAME);
            this.size = this.buffer.writerIndex();
        }
        return this.buffer;
    }

    @Override
    public void addHeader(String key, String val) {
        if (!this.headers.containsKey(key)) {
            this.headers.put(key, val);
            this.allHeaders.add(new StompFrame.Header(key, val));
        } else if (!key.equals("content-length")) {
            this.allHeaders.add(new StompFrame.Header(key, val));
        }
    }
}

