/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQDisconnectedException;
import org.hornetq.api.core.HornetQDuplicateMetaDataException;
import org.hornetq.api.core.HornetQIOErrorException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQIncompatibleClientServerException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQInvalidFilterExpressionException;
import org.hornetq.api.core.HornetQLargeMessageException;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.HornetQObjectClosedException;
import org.hornetq.api.core.HornetQQueueExistsException;
import org.hornetq.api.core.HornetQSecurityException;
import org.hornetq.api.core.HornetQSessionCreationException;
import org.hornetq.api.core.HornetQTransactionOutcomeUnknownException;
import org.hornetq.api.core.HornetQTransactionRolledBackException;
import org.hornetq.api.core.HornetQUnBlockedException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Connection;
import org.w3c.dom.Node;

public class HornetQMessageBundle_$bundle
implements Serializable,
HornetQMessageBundle {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "HQ";
    public static final HornetQMessageBundle_$bundle INSTANCE = new HornetQMessageBundle_$bundle();
    private static final String attsDontMatch = "attribute {0}={1} doesn't match";
    private static final String noGetterMethod = "no getter method for {0}";
    private static final String mustBeDouble = "Element {0} requires a valid Double value, but '{1}' cannot be parsed as a Double";
    private static final String addressIsNull = "Address is null";
    private static final String errorWritingLargeMessage = "Error writing body of message";
    private static final String journalsNotInSync = "Cannot compare journals if not in sync!";
    private static final String consumerDoesntExist = "Consumer {0} doesn't exist on the server";
    private static final String txOutcomeUnknown = "The transaction was rolled back on failover however commit may have been succesful";
    private static final String cannotFindResource = "Cannot find resource with name {0}";
    private static final String oneNodeHasChildren = "one node has children and the other doesn't";
    private static final String noQueueFound = "No queue found for {0}";
    private static final String failedToInitialiseSessionFactory = "Failed to initialise session factory";
    private static final String messageIdNotAssigned = "MessageId was not assigned to Message";
    private static final String noSuchQueue = "Queue {0}does not exist";
    private static final String routeNameIsNull = "Routing name is null";
    private static final String groupingQueueRemoved = "queue {0} has been removed cannot deliver message, queues should not be removed when grouping is used";
    private static final String connectionExists = "Connection already exists with id {0}";
    private static final String greaterThanZero2 = "{0}  must be greater than 0 (actual value: {1})";
    private static final String nodeHasDifferentChildNumber = "nodes hava a different number of children";
    private static final String connectionDestroyed = "Connection is destroyed";
    private static final String userNoPermissions = "User: {0} doesn't have permission='{1}' on address {2}";
    private static final String serverNotStarted = "Server not started";
    private static final String nodeHaveDifferentNames = "nodes have different node names";
    private static final String incompatibleCLientServer = "Server and client versions incompatible";
    private static final String invalidRetryInterval = "retry interval must be positive, was {0}";
    private static final String failedToCreateSession = "Failed to create session";
    private static final String greaterThanZero1 = "invalid value: {0} count must be greater than 0";
    private static final String greaterThanMinusOne = "{0}  must be equals to -1 or greater than 0 (actual value: {1})";
    private static final String errorSavingBody = "Error saving the message body";
    private static final String nullListener = "Invalid argument null listener";
    private static final String replicationUnhandledDataType = "unhandled data type!";
    private static final String largeMessageControllerInterrupted = "Interrupted awaiting completion in large message controller";
    private static final String bindingTypeNotSpecified = "Binding type not specified";
    private static final String invalidEncodeType = "Invalid type: {0}";
    private static final String invalidFilter = "Invalid filter: {0}";
    private static final String endThreadDump = "End Thread dump";
    private static final String inReceive = "Cannot set MessageHandler - consumer is in receive(...)";
    private static final String noAddress = "No address configured on the Server's Session";
    private static final String queueMisConfigured = "Queue can not be both durable and temporary";
    private static final String invalidType = "Invalid type: {0}";
    private static final String firstNodeNull = "the first node to be compared is null";
    private static final String emptyOrNull = "{0} must neither be null nor empty";
    private static final String nodeHaveDifferentAttNumber = "nodes hava a different number of attributes";
    private static final String nullPassword = "Password cannot be null";
    private static final String invalidManagementParam = "Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {0}";
    private static final String invalidJournalType2 = "Invalid journal type {0}";
    private static final String cannotConnectToStaticConnectors = "Failed to connect to any static connectors";
    private static final String bindingIdNotSpecified = "Binding ID is null";
    private static final String invalidMessageCounterPeriod = "Cannot set Message Counter Sample Period < {0}ms";
    private static final String producerClosed = "Producer is closed";
    private static final String invalidJournal = "Only NIO and AsyncIO are supported journals";
    private static final String queueAlreadyExists = "Queue already exists {0}";
    private static final String noOperation = "no operation {0}/{1}";
    private static final String unknownProtocol = "Unknown protocol {0}";
    private static final String replicationTooManyJournals = "Live Node contains more journals than the backup node. Probably a version match error";
    private static final String backupServerNotInSync = "Backup Server was not yet in sync with live";
    private static final String cannotConnectToStaticConnectors2 = "Failed to connect to any static connectors";
    private static final String noLiveForReplicatedBackup = "Cannot have a replicated backup without configuring its live-server!";
    private static final String unableToCompleteIOOperation = "Unable to complete IO operation - {0}";
    private static final String timedOutSendingPacket = "Timed out waiting for response when sending packet {0}";
    private static final String errorClosingLargeMessage = "Error closing stream from LargeMessageBody";
    private static final String largeMessageLostSession = "The large message lost connection with its session, either because of a rollback or a closed session";
    private static final String connectionsClosedByManagement = "connections for {0} closed by management";
    private static final String serverNotBackupServer = "Connected server is not a backup server";
    private static final String serverDescribe = "Information about server {0}\nCluster Connection:{1}";
    private static final String distancenotSpecified = "Distance is null";
    private static final String timeoutOnLargeMessage = "Timeout waiting for LargeMessage Body";
    private static final String sessionClosed = "Session is closed";
    private static final String disconnected = "The connection was disconnected because of server shutdown";
    private static final String notJournalImpl = "journals are not JournalImpl. You can't set a replicator!";
    private static final String clientSessionClosed = "ClientSession closed while creating session";
    private static final String threadDump = "Thread {0} name = {1} id = {2} group = {3}";
    private static final String invalidMatch = "* can only be at end of match";
    private static final String errorSavingLargeMessageBuffer = "Error on saving Large Message Buffer";
    private static final String errordecodingPassword = "Error decoding password";
    private static final String replicationStartError = "Error trying to start replication";
    private static final String nullHandler = "Invalid argument null handler";
    private static final String acceptorExists = "Acceptor with id {0} already registered";
    private static final String closeListenerCannotBeNull = "Close Listener cannot be null";
    private static final String generatingThreadDump = "Generating thread dump because - {0}";
    private static final String duplicateMetadata = "Metadata {0}={1} had been set already";
    private static final String connectionTimedOutInInitialBroadcast = "Timed out waiting to receive initial broadcast from cluster";
    private static final String noTCForSessionFactory = "Couldn't select a TransportConfiguration to create SessionFactory";
    private static final String mustBeLong = "Element {0} requires a valid Long value, but '{1}' cannot be parsed as a Long";
    private static final String alreadyHaveReplicationServer = "Backup replication server is already connected to another server";
    private static final String mustbeBetween = "{0} must be betwen {1} and {2} inclusive (actual value: {3})";
    private static final String invalidAddressFullPolicyType = "Invalid address full message policy type {0}";
    private static final String noChannelToClose = "Cannot find channel with id {0} to close";
    private static final String secondNodeNull = "the second node to be compared is null";
    private static final String bindingAlreadyExists = "Binding already exists {0}";
    private static final String cannotCreateDir = "Directory {0} does not exist and cannot be created";
    private static final String bindingNotDivert = "Binding {0} is not a divert";
    private static final String mustBeInteger = "Element {0} requires a valid Integer value, but '{1}' cannot be parsed as a Integer";
    private static final String cannotConnectToServers = "Cannot connect to server(s). Tried with all available servers.";
    private static final String connectionTimedOutOnReceiveTopology = "Timed out waiting to receive cluster topology. Group:{0}";
    private static final String unableToValidateUser = "Unable to validate user: {0}";
    private static final String noCodec = "No available codec to decode password!";
    private static final String errorCreatingTransformerClass = "Error instantiating transformer class {0}";
    private static final String invalidNewPriority = "invalid new Priority value: {0}. It must be between 0 and 9 (both included)";
    private static final String channelDisconnected = "Channel disconnected";
    private static final String queueNameIsNull = "Queue name is null";
    private static final String consumerNoReference = "Could not find reference on consumer ID={0}, messageId = {1} queue = {2}";
    private static final String headerSizeTooBig = "Header size ({0}) is too big, use the messageBody for large data, or increase minLargeMessageSize";
    private static final String failListenerCannotBeNull = "Fail Listener cannot be null";
    private static final String noBindingForDivert = "No binding for divert {0}";
    private static final String clusterNameIsNull = "Cluster name is null";
    private static final String nodeIdNull = "node id is null";
    private static final String ioTimeout = "Timeout on waiting I/O completion";
    private static final String invalidCommandID = "Invalid last Received Command ID: {0}";
    private static final String replicationUnhandledFileType = "Unhandled file type {0}";
    private static final String messageHandlerSet = "Cannot call receive(...) - a MessageHandler is set";
    private static final String nettyError = "Exception in Netty transport";
    private static final String consumerClosed = "Consumer is closed";
    private static final String noOperationMapped = "No operation mapped to int {0}";
    private static final String clientExited = "Did not receive data from {0}. It is likely the client has exited or crashed without closing its connection, or the network between the server and client has failed. You also might have configured connection-ttl and client-failure-check-period incorrectly. Please check user manual for more information. The connection will now be closed.";
    private static final String invalidJournalType = "Invalid journal type {0}";
    private static final String notPercent = "{0} must be a valid percentual value between 0 and 100 (actual value: {1})";
    private static final String errorStoppingServer = "error trying to stop {0}";
    private static final String largeMessageNotInitialised = "large-message not initialized on server";
    private static final String autoConvertError = "method autoEncode doesn't know how to convert {0} yet";
    private static final String invalidIndex = "Invalid index {0}";
    private static final String unblockingACall = "Connection failure detected. Unblocking a blocking call that will never get a response";
    private static final String greaterThanZeroOrMinusOne = "{0}  must be equals to -1 or greater or equals to 0 (actual value: {1})";
    private static final String cannotDeleteQueue = "Cannot delete queue {0} on binding {1} - it has consumers = {2}";
    private static final String failedToGetDecoder = "Failed to get decoder";
    private static final String nullMatch = "match can not be null";
    private static final String nullUser = "User cannot be null";
    private static final String connectionTimedOut = "Did not receive data from server for {0}";
    private static final String replicationBackupUpToDate = "Remote Backup can not be up-to-date!";
    private static final String cannotConvertToInt = "Cannot convert to int";
    private static final String mustBeBoolean = "Element {0} requires a valid Boolean value, but '{1}' cannot be parsed as a Boolean";
    private static final String activationForServer = "Activation for server {0}";
    private static final String txRolledBack = "The transaction was rolled back on failover to a backup server";
    private static final String replicationUnhandledError = "unhandled error during replication";
    private static final String clietSessionInternal = "Internal Error! ClientSessionFactoryImpl::createSessionInternal just reached a condition that was not supposed to happen. Please inform this condition to the HornetQ team";
    private static final String invalidWindowSize = "Invalid window size {0}";
    private static final String acceptorNotExists = "Acceptor with id {0} not registered";
    private static final String errorReadingBody = "Error reading the LargeMessageBody";

    protected HornetQMessageBundle_$bundle() {
    }

    protected HornetQMessageBundle_$bundle readResolve() {
        return INSTANCE;
    }

    @Override
    public final IllegalArgumentException attsDontMatch(String name, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119128: " + this.attsDontMatch$str(), name, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attsDontMatch$str() {
        return attsDontMatch;
    }

    @Override
    public final IllegalArgumentException noGetterMethod(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119117: " + this.noGetterMethod$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noGetterMethod$str() {
        return noGetterMethod;
    }

    @Override
    public final IllegalArgumentException mustBeDouble(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119132: " + this.mustBeDouble$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeDouble$str() {
        return mustBeDouble;
    }

    @Override
    public final IllegalArgumentException addressIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119099: " + this.addressIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsNull$str() {
        return addressIsNull;
    }

    @Override
    public final HornetQLargeMessageException errorWritingLargeMessage(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException("HQ119069: " + this.errorWritingLargeMessage$str());
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorWritingLargeMessage$str() {
        return errorWritingLargeMessage;
    }

    @Override
    public final HornetQIllegalStateException journalsNotInSync() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119052: " + this.journalsNotInSync$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String journalsNotInSync$str() {
        return journalsNotInSync;
    }

    @Override
    public final HornetQIllegalStateException consumerDoesntExist(long consumerID) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format("HQ119058: " + this.consumerDoesntExist$str(), consumerID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerDoesntExist$str() {
        return consumerDoesntExist;
    }

    @Override
    public final HornetQTransactionOutcomeUnknownException txOutcomeUnknown() {
        HornetQTransactionOutcomeUnknownException result = new HornetQTransactionOutcomeUnknownException("HQ119073: " + this.txOutcomeUnknown$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String txOutcomeUnknown$str() {
        return txOutcomeUnknown;
    }

    @Override
    public final IllegalArgumentException cannotFindResource(String resourceName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119116: " + this.cannotFindResource$str(), resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindResource$str() {
        return cannotFindResource;
    }

    @Override
    public final IllegalArgumentException oneNodeHasChildren() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119129: " + this.oneNodeHasChildren$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String oneNodeHasChildren$str() {
        return oneNodeHasChildren;
    }

    @Override
    public final IllegalArgumentException noQueueFound(String otherQueueName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119091: " + this.noQueueFound$str(), otherQueueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noQueueFound$str() {
        return noQueueFound;
    }

    @Override
    public final HornetQInternalErrorException failedToInitialiseSessionFactory(Exception e) {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119011: " + this.failedToInitialiseSessionFactory$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToInitialiseSessionFactory$str() {
        return failedToInitialiseSessionFactory;
    }

    @Override
    public final HornetQIllegalStateException messageIdNotAssigned() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119051: " + this.messageIdNotAssigned$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageIdNotAssigned$str() {
        return messageIdNotAssigned;
    }

    @Override
    public final HornetQNonExistentQueueException noSuchQueue(SimpleString queueName) {
        HornetQNonExistentQueueException result = new HornetQNonExistentQueueException(MessageFormat.format("HQ119039: " + this.noSuchQueue$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchQueue$str() {
        return noSuchQueue;
    }

    @Override
    public final IllegalArgumentException routeNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119097: " + this.routeNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String routeNameIsNull$str() {
        return routeNameIsNull;
    }

    @Override
    public final HornetQNonExistentQueueException groupingQueueRemoved(SimpleString chosenClusterName) {
        HornetQNonExistentQueueException result = new HornetQNonExistentQueueException(MessageFormat.format("HQ119038: " + this.groupingQueueRemoved$str(), chosenClusterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String groupingQueueRemoved$str() {
        return groupingQueueRemoved;
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119107: " + this.connectionExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionExists$str() {
        return connectionExists;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119080: " + this.greaterThanZero2$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero2$str() {
        return greaterThanZero2;
    }

    @Override
    public final IllegalArgumentException nodeHasDifferentChildNumber() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119130: " + this.nodeHasDifferentChildNumber$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeHasDifferentChildNumber$str() {
        return nodeHasDifferentChildNumber;
    }

    @Override
    public final HornetQNotConnectedException connectionDestroyed() {
        HornetQNotConnectedException result = new HornetQNotConnectedException("HQ119029: " + this.connectionDestroyed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionDestroyed$str() {
        return connectionDestroyed;
    }

    @Override
    public final HornetQSecurityException userNoPermissions(String username, CheckType checkType, String saddress) {
        HornetQSecurityException result = new HornetQSecurityException(MessageFormat.format("HQ119062: " + this.userNoPermissions$str(), new Object[]{username, checkType, saddress}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNoPermissions$str() {
        return userNoPermissions;
    }

    @Override
    public final HornetQSessionCreationException serverNotStarted() {
        HornetQSessionCreationException result = new HornetQSessionCreationException("HQ119071: " + this.serverNotStarted$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotStarted$str() {
        return serverNotStarted;
    }

    @Override
    public final IllegalArgumentException nodeHaveDifferentNames() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119126: " + this.nodeHaveDifferentNames$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeHaveDifferentNames$str() {
        return nodeHaveDifferentNames;
    }

    @Override
    public final HornetQIncompatibleClientServerException incompatibleCLientServer() {
        HornetQIncompatibleClientServerException result = new HornetQIncompatibleClientServerException("HQ119063: " + this.incompatibleCLientServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleCLientServer$str() {
        return incompatibleCLientServer;
    }

    @Override
    public final IllegalArgumentException invalidRetryInterval(Long size) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119078: " + this.invalidRetryInterval$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRetryInterval$str() {
        return invalidRetryInterval;
    }

    @Override
    public final HornetQInternalErrorException failedToCreateSession(Throwable t) {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119007: " + this.failedToCreateSession$str(), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToCreateSession$str() {
        return failedToCreateSession;
    }

    @Override
    public final IllegalArgumentException greaterThanZero(Integer count) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119088: " + this.greaterThanZero1$str(), count));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZero1$str() {
        return greaterThanZero1;
    }

    @Override
    public final IllegalArgumentException greaterThanMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119082: " + this.greaterThanMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanMinusOne$str() {
        return greaterThanMinusOne;
    }

    @Override
    public final HornetQLargeMessageException errorSavingBody(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException("HQ119064: " + this.errorSavingBody$str());
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorSavingBody$str() {
        return errorSavingBody;
    }

    @Override
    public final IllegalArgumentException nullListener() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119110: " + this.nullListener$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullListener$str() {
        return nullListener;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledDataType() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119020: " + this.replicationUnhandledDataType$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledDataType$str() {
        return replicationUnhandledDataType;
    }

    @Override
    public final HornetQInternalErrorException largeMessageControllerInterrupted(Exception e) {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119010: " + this.largeMessageControllerInterrupted$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageControllerInterrupted$str() {
        return largeMessageControllerInterrupted;
    }

    @Override
    public final IllegalArgumentException bindingTypeNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119100: " + this.bindingTypeNotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingTypeNotSpecified$str() {
        return bindingTypeNotSpecified;
    }

    @Override
    public final IllegalArgumentException invalidEncodeType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119075: " + this.invalidEncodeType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidEncodeType$str() {
        return "Invalid type: {0}";
    }

    @Override
    public final HornetQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        HornetQInvalidFilterExpressionException result = new HornetQInvalidFilterExpressionException(MessageFormat.format("HQ119045: " + this.invalidFilter$str(), filter));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final String endThreadDump() {
        String result = "HQ119004: " + this.endThreadDump$str();
        return result;
    }

    protected String endThreadDump$str() {
        return endThreadDump;
    }

    @Override
    public final HornetQIllegalStateException inReceive() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119047: " + this.inReceive$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String inReceive$str() {
        return inReceive;
    }

    @Override
    public final HornetQIllegalStateException noAddress() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119059: " + this.noAddress$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAddress$str() {
        return noAddress;
    }

    @Override
    public final HornetQInternalErrorException queueMisConfigured() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119009: " + this.queueMisConfigured$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueMisConfigured$str() {
        return queueMisConfigured;
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119074: " + this.invalidType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidType$str() {
        return "Invalid type: {0}";
    }

    @Override
    public final IllegalArgumentException firstNodeNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119124: " + this.firstNodeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String firstNodeNull$str() {
        return firstNodeNull;
    }

    @Override
    public final IllegalArgumentException emptyOrNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119079: " + this.emptyOrNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyOrNull$str() {
        return emptyOrNull;
    }

    @Override
    public final IllegalArgumentException nodeHaveDifferentAttNumber() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119127: " + this.nodeHaveDifferentAttNumber$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeHaveDifferentAttNumber$str() {
        return nodeHaveDifferentAttNumber;
    }

    @Override
    public final IllegalArgumentException nullPassword() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119122: " + this.nullPassword$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullPassword$str() {
        return nullPassword;
    }

    @Override
    public final IllegalArgumentException invalidManagementParam(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119076: " + this.invalidManagementParam$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidManagementParam$str() {
        return invalidManagementParam;
    }

    @Override
    public final IllegalArgumentException invalidJournalType2(JournalType journalType) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119093: " + this.invalidJournalType2$str(), new Object[]{journalType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType2$str() {
        return "Invalid journal type {0}";
    }

    @Override
    public final HornetQNotConnectedException cannotConnectToStaticConnectors(Exception e) {
        HornetQNotConnectedException result = new HornetQNotConnectedException("HQ119027: " + this.cannotConnectToStaticConnectors$str());
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConnectToStaticConnectors$str() {
        return "Failed to connect to any static connectors";
    }

    @Override
    public final IllegalArgumentException bindingIdNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119101: " + this.bindingIdNotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingIdNotSpecified$str() {
        return bindingIdNotSpecified;
    }

    @Override
    public final IllegalArgumentException invalidMessageCounterPeriod(Long period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119089: " + this.invalidMessageCounterPeriod$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessageCounterPeriod$str() {
        return invalidMessageCounterPeriod;
    }

    @Override
    public final HornetQObjectClosedException producerClosed() {
        HornetQObjectClosedException result = new HornetQObjectClosedException("HQ119043: " + this.producerClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String producerClosed$str() {
        return producerClosed;
    }

    @Override
    public final IllegalArgumentException invalidJournal() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119092: " + this.invalidJournal$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournal$str() {
        return invalidJournal;
    }

    @Override
    public final HornetQQueueExistsException queueAlreadyExists(SimpleString queueName) {
        HornetQQueueExistsException result = new HornetQQueueExistsException(MessageFormat.format("HQ119041: " + this.queueAlreadyExists$str(), queueName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueAlreadyExists$str() {
        return queueAlreadyExists;
    }

    @Override
    public final IllegalArgumentException noOperation(String operation, Integer length) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119118: " + this.noOperation$str(), operation, length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noOperation$str() {
        return noOperation;
    }

    @Override
    public final IllegalArgumentException unknownProtocol(ProtocolType protocol) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119112: " + this.unknownProtocol$str(), new Object[]{protocol}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownProtocol$str() {
        return unknownProtocol;
    }

    @Override
    public final HornetQInternalErrorException replicationTooManyJournals() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119017: " + this.replicationTooManyJournals$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationTooManyJournals$str() {
        return replicationTooManyJournals;
    }

    @Override
    public final HornetQIllegalStateException backupServerNotInSync() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119056: " + this.backupServerNotInSync$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupServerNotInSync$str() {
        return backupServerNotInSync;
    }

    @Override
    public final HornetQNotConnectedException cannotConnectToStaticConnectors2() {
        HornetQNotConnectedException result = new HornetQNotConnectedException("HQ119028: " + this.cannotConnectToStaticConnectors2$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConnectToStaticConnectors2$str() {
        return "Failed to connect to any static connectors";
    }

    @Override
    public final IllegalArgumentException noLiveForReplicatedBackup() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119114: " + this.noLiveForReplicatedBackup$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noLiveForReplicatedBackup$str() {
        return noLiveForReplicatedBackup;
    }

    @Override
    public final HornetQInternalErrorException unableToCompleteIOOperation(String message) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119014: " + this.unableToCompleteIOOperation$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCompleteIOOperation$str() {
        return unableToCompleteIOOperation;
    }

    @Override
    public final HornetQConnectionTimedOutException timedOutSendingPacket(Byte type) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format("HQ119033: " + this.timedOutSendingPacket$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String timedOutSendingPacket$str() {
        return timedOutSendingPacket;
    }

    @Override
    public final HornetQLargeMessageException errorClosingLargeMessage(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException("HQ119066: " + this.errorClosingLargeMessage$str());
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorClosingLargeMessage$str() {
        return errorClosingLargeMessage;
    }

    @Override
    public final HornetQIllegalStateException largeMessageLostSession() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119049: " + this.largeMessageLostSession$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageLostSession$str() {
        return largeMessageLostSession;
    }

    @Override
    public final HornetQInternalErrorException connectionsClosedByManagement(String ipAddress) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119012: " + this.connectionsClosedByManagement$str(), ipAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionsClosedByManagement$str() {
        return connectionsClosedByManagement;
    }

    @Override
    public final HornetQIllegalStateException serverNotBackupServer() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119053: " + this.serverNotBackupServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNotBackupServer$str() {
        return serverNotBackupServer;
    }

    @Override
    public final String serverDescribe(String identity, String describe) {
        String result = MessageFormat.format("HQ119005: " + this.serverDescribe$str(), identity, describe);
        return result;
    }

    protected String serverDescribe$str() {
        return serverDescribe;
    }

    @Override
    public final IllegalArgumentException distancenotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119102: " + this.distancenotSpecified$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distancenotSpecified$str() {
        return distancenotSpecified;
    }

    @Override
    public final HornetQLargeMessageException timeoutOnLargeMessage() {
        HornetQLargeMessageException result = new HornetQLargeMessageException("HQ119067: " + this.timeoutOnLargeMessage$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String timeoutOnLargeMessage$str() {
        return timeoutOnLargeMessage;
    }

    @Override
    public final HornetQObjectClosedException sessionClosed() {
        HornetQObjectClosedException result = new HornetQObjectClosedException("HQ119044: " + this.sessionClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionClosed$str() {
        return sessionClosed;
    }

    @Override
    public final HornetQDisconnectedException disconnected() {
        HornetQDisconnectedException result = new HornetQDisconnectedException("HQ119035: " + this.disconnected$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String disconnected$str() {
        return disconnected;
    }

    @Override
    public final HornetQInternalErrorException notJournalImpl() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119013: " + this.notJournalImpl$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notJournalImpl$str() {
        return notJournalImpl;
    }

    @Override
    public final HornetQInternalErrorException clientSessionClosed() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119006: " + this.clientSessionClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientSessionClosed$str() {
        return clientSessionClosed;
    }

    @Override
    public final String threadDump(Thread key, String name, Long id, ThreadGroup threadGroup) {
        String result = MessageFormat.format("HQ119003: " + this.threadDump$str(), key, name, id, threadGroup);
        return result;
    }

    protected String threadDump$str() {
        return threadDump;
    }

    @Override
    public final IllegalArgumentException invalidMatch() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119120: " + this.invalidMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMatch$str() {
        return invalidMatch;
    }

    @Override
    public final HornetQLargeMessageException errorSavingLargeMessageBuffer(Exception handledException) {
        HornetQLargeMessageException result = new HornetQLargeMessageException("HQ119068: " + this.errorSavingLargeMessageBuffer$str());
        result.initCause((Throwable)handledException);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorSavingLargeMessageBuffer$str() {
        return errorSavingLargeMessageBuffer;
    }

    @Override
    public final IllegalArgumentException errordecodingPassword(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException("HQ119136: " + this.errordecodingPassword$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errordecodingPassword$str() {
        return errordecodingPassword;
    }

    @Override
    public final HornetQInternalErrorException replicationStartError(Exception e) {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119023: " + this.replicationStartError$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationStartError$str() {
        return replicationStartError;
    }

    @Override
    public final IllegalArgumentException nullHandler() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119111: " + this.nullHandler$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullHandler$str() {
        return nullHandler;
    }

    @Override
    public final IllegalArgumentException acceptorExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119108: " + this.acceptorExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorExists$str() {
        return acceptorExists;
    }

    @Override
    public final IllegalArgumentException closeListenerCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119105: " + this.closeListenerCannotBeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closeListenerCannotBeNull$str() {
        return closeListenerCannotBeNull;
    }

    @Override
    public final String generatingThreadDump(String reason) {
        String result = MessageFormat.format("HQ119002: " + this.generatingThreadDump$str(), reason);
        return result;
    }

    protected String generatingThreadDump$str() {
        return generatingThreadDump;
    }

    @Override
    public final HornetQDuplicateMetaDataException duplicateMetadata(String key, String data) {
        HornetQDuplicateMetaDataException result = new HornetQDuplicateMetaDataException(MessageFormat.format("HQ119072: " + this.duplicateMetadata$str(), key, data));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateMetadata$str() {
        return duplicateMetadata;
    }

    @Override
    public final HornetQConnectionTimedOutException connectionTimedOutInInitialBroadcast() {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException("HQ119031: " + this.connectionTimedOutInInitialBroadcast$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionTimedOutInInitialBroadcast$str() {
        return connectionTimedOutInInitialBroadcast;
    }

    @Override
    public final HornetQIllegalStateException noTCForSessionFactory() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119050: " + this.noTCForSessionFactory$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noTCForSessionFactory$str() {
        return noTCForSessionFactory;
    }

    @Override
    public final IllegalArgumentException mustBeLong(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119134: " + this.mustBeLong$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeLong$str() {
        return mustBeLong;
    }

    @Override
    public final HornetQIllegalStateException alreadyHaveReplicationServer() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119054: " + this.alreadyHaveReplicationServer$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyHaveReplicationServer$str() {
        return alreadyHaveReplicationServer;
    }

    @Override
    public final IllegalArgumentException mustbeBetween(String name, Integer minPriority, Integer maxPriority, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119084: " + this.mustbeBetween$str(), name, minPriority, maxPriority, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustbeBetween$str() {
        return mustbeBetween;
    }

    @Override
    public final IllegalArgumentException invalidAddressFullPolicyType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119086: " + this.invalidAddressFullPolicyType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAddressFullPolicyType$str() {
        return invalidAddressFullPolicyType;
    }

    @Override
    public final IllegalArgumentException noChannelToClose(Long id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119104: " + this.noChannelToClose$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noChannelToClose$str() {
        return noChannelToClose;
    }

    @Override
    public final IllegalArgumentException secondNodeNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119125: " + this.secondNodeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String secondNodeNull$str() {
        return secondNodeNull;
    }

    @Override
    public final HornetQQueueExistsException bindingAlreadyExists(Binding binding) {
        HornetQQueueExistsException result = new HornetQQueueExistsException(MessageFormat.format("HQ119040: " + this.bindingAlreadyExists$str(), binding));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingAlreadyExists$str() {
        return bindingAlreadyExists;
    }

    @Override
    public final IllegalArgumentException cannotCreateDir(String dir) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119094: " + this.cannotCreateDir$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateDir$str() {
        return cannotCreateDir;
    }

    @Override
    public final HornetQInternalErrorException bindingNotDivert(SimpleString name) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119022: " + this.bindingNotDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bindingNotDivert$str() {
        return bindingNotDivert;
    }

    @Override
    public final IllegalArgumentException mustBeInteger(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119133: " + this.mustBeInteger$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeInteger$str() {
        return mustBeInteger;
    }

    @Override
    public final HornetQNotConnectedException cannotConnectToServers() {
        HornetQNotConnectedException result = new HornetQNotConnectedException("HQ119026: " + this.cannotConnectToServers$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConnectToServers$str() {
        return cannotConnectToServers;
    }

    @Override
    public final HornetQConnectionTimedOutException connectionTimedOutOnReceiveTopology(DiscoveryGroup discoveryGroup) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format("HQ119032: " + this.connectionTimedOutOnReceiveTopology$str(), discoveryGroup));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionTimedOutOnReceiveTopology$str() {
        return connectionTimedOutOnReceiveTopology;
    }

    @Override
    public final HornetQSecurityException unableToValidateUser(String user) {
        HornetQSecurityException result = new HornetQSecurityException(MessageFormat.format("HQ119061: " + this.unableToValidateUser$str(), user));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToValidateUser$str() {
        return unableToValidateUser;
    }

    @Override
    public final IllegalArgumentException noCodec() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119123: " + this.noCodec$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCodec$str() {
        return noCodec;
    }

    @Override
    public final IllegalArgumentException errorCreatingTransformerClass(Exception e, String transformerClassName) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119137: " + this.errorCreatingTransformerClass$str(), transformerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingTransformerClass$str() {
        return errorCreatingTransformerClass;
    }

    @Override
    public final IllegalArgumentException invalidNewPriority(Integer period) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119090: " + this.invalidNewPriority$str(), period));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNewPriority$str() {
        return invalidNewPriority;
    }

    @Override
    public final HornetQNotConnectedException channelDisconnected() {
        HornetQNotConnectedException result = new HornetQNotConnectedException("HQ119025: " + this.channelDisconnected$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelDisconnected$str() {
        return channelDisconnected;
    }

    @Override
    public final IllegalArgumentException queueNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119115: " + this.queueNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueNameIsNull$str() {
        return queueNameIsNull;
    }

    @Override
    public final HornetQIllegalStateException consumerNoReference(Long id, Long messageID, SimpleString name) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format("HQ119057: " + this.consumerNoReference$str(), id, messageID, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerNoReference$str() {
        return consumerNoReference;
    }

    @Override
    public final HornetQIllegalStateException headerSizeTooBig(Integer headerSize) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format("HQ119048: " + this.headerSizeTooBig$str(), headerSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String headerSizeTooBig$str() {
        return headerSizeTooBig;
    }

    @Override
    public final IllegalArgumentException failListenerCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119106: " + this.failListenerCannotBeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failListenerCannotBeNull$str() {
        return failListenerCannotBeNull;
    }

    @Override
    public final HornetQInternalErrorException noBindingForDivert(SimpleString name) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119021: " + this.noBindingForDivert$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noBindingForDivert$str() {
        return noBindingForDivert;
    }

    @Override
    public final IllegalArgumentException clusterNameIsNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119098: " + this.clusterNameIsNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clusterNameIsNull$str() {
        return clusterNameIsNull;
    }

    @Override
    public final IllegalArgumentException nodeIdNull() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119113: " + this.nodeIdNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeIdNull$str() {
        return nodeIdNull;
    }

    @Override
    public final HornetQIOErrorException ioTimeout() {
        HornetQIOErrorException result = new HornetQIOErrorException("HQ119037: " + this.ioTimeout$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioTimeout$str() {
        return ioTimeout;
    }

    @Override
    public final IllegalArgumentException invalidCommandID(Integer lastReceivedCommandID) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119103: " + this.invalidCommandID$str(), lastReceivedCommandID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCommandID$str() {
        return invalidCommandID;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType fileType) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119018: " + this.replicationUnhandledFileType$str(), new Object[]{fileType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledFileType$str() {
        return replicationUnhandledFileType;
    }

    @Override
    public final HornetQIllegalStateException messageHandlerSet() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119046: " + this.messageHandlerSet$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageHandlerSet$str() {
        return messageHandlerSet;
    }

    @Override
    public final HornetQInternalErrorException nettyError() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119015: " + this.nettyError$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nettyError$str() {
        return nettyError;
    }

    @Override
    public final HornetQObjectClosedException consumerClosed() {
        HornetQObjectClosedException result = new HornetQObjectClosedException("HQ119042: " + this.consumerClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerClosed$str() {
        return consumerClosed;
    }

    @Override
    public final IllegalArgumentException noOperationMapped(Integer operation) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119087: " + this.noOperationMapped$str(), operation));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noOperationMapped$str() {
        return noOperationMapped;
    }

    @Override
    public final HornetQConnectionTimedOutException clientExited(String remoteAddress) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format("HQ119034: " + this.clientExited$str(), remoteAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientExited$str() {
        return clientExited;
    }

    @Override
    public final IllegalArgumentException invalidJournalType(String val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119085: " + this.invalidJournalType$str(), val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJournalType$str() {
        return "Invalid journal type {0}";
    }

    @Override
    public final IllegalArgumentException notPercent(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119081: " + this.notPercent$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notPercent$str() {
        return notPercent;
    }

    @Override
    public final HornetQInternalErrorException errorStoppingServer(Exception e, HornetQServer server) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(MessageFormat.format("HQ119024: " + this.errorStoppingServer$str(), server), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorStoppingServer$str() {
        return errorStoppingServer;
    }

    @Override
    public final HornetQIllegalStateException largeMessageNotInitialised() {
        HornetQIllegalStateException result = new HornetQIllegalStateException("HQ119060: " + this.largeMessageNotInitialised$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageNotInitialised$str() {
        return largeMessageNotInitialised;
    }

    public final IllegalArgumentException autoConvertError(Class aClass) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119138: " + this.autoConvertError$str(), aClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String autoConvertError$str() {
        return autoConvertError;
    }

    @Override
    public final IllegalArgumentException invalidIndex(Integer index) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119095: " + this.invalidIndex$str(), index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIndex$str() {
        return invalidIndex;
    }

    @Override
    public final HornetQUnBlockedException unblockingACall() {
        HornetQUnBlockedException result = new HornetQUnBlockedException("HQ119036: " + this.unblockingACall$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unblockingACall$str() {
        return unblockingACall;
    }

    @Override
    public final IllegalArgumentException greaterThanZeroOrMinusOne(String name, Number val) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119083: " + this.greaterThanZeroOrMinusOne$str(), name, val));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String greaterThanZeroOrMinusOne$str() {
        return greaterThanZeroOrMinusOne;
    }

    @Override
    public final HornetQIllegalStateException cannotDeleteQueue(SimpleString name, SimpleString queueName, String s) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format("HQ119055: " + this.cannotDeleteQueue$str(), name, queueName, s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeleteQueue$str() {
        return cannotDeleteQueue;
    }

    @Override
    public final IllegalArgumentException failedToGetDecoder(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException("HQ119135: " + this.failedToGetDecoder$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToGetDecoder$str() {
        return failedToGetDecoder;
    }

    @Override
    public final IllegalArgumentException nullMatch() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119119: " + this.nullMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullMatch$str() {
        return nullMatch;
    }

    @Override
    public final IllegalArgumentException nullUser() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119121: " + this.nullUser$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullUser$str() {
        return nullUser;
    }

    @Override
    public final HornetQConnectionTimedOutException connectionTimedOut(Connection transportConnection) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format("HQ119030: " + this.connectionTimedOut$str(), transportConnection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionTimedOut$str() {
        return connectionTimedOut;
    }

    @Override
    public final HornetQInternalErrorException replicationBackupUpToDate() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119019: " + this.replicationBackupUpToDate$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationBackupUpToDate$str() {
        return replicationBackupUpToDate;
    }

    @Override
    public final IllegalArgumentException cannotConvertToInt() {
        IllegalArgumentException result = new IllegalArgumentException("HQ119096: " + this.cannotConvertToInt$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertToInt$str() {
        return cannotConvertToInt;
    }

    @Override
    public final IllegalArgumentException mustBeBoolean(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119131: " + this.mustBeBoolean$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeBoolean$str() {
        return mustBeBoolean;
    }

    @Override
    public final String activationForServer(HornetQServer server) {
        String result = MessageFormat.format("HQ119001: " + this.activationForServer$str(), server);
        return result;
    }

    protected String activationForServer$str() {
        return activationForServer;
    }

    @Override
    public final HornetQTransactionRolledBackException txRolledBack() {
        HornetQTransactionRolledBackException result = new HornetQTransactionRolledBackException("HQ119070: " + this.txRolledBack$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String txRolledBack$str() {
        return txRolledBack;
    }

    @Override
    public final HornetQInternalErrorException replicationUnhandledError(Exception e) {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119016: " + this.replicationUnhandledError$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String replicationUnhandledError$str() {
        return replicationUnhandledError;
    }

    @Override
    public final HornetQInternalErrorException clietSessionInternal() {
        HornetQInternalErrorException result = new HornetQInternalErrorException("HQ119008: " + this.clietSessionInternal$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clietSessionInternal$str() {
        return clietSessionInternal;
    }

    @Override
    public final IllegalArgumentException invalidWindowSize(Integer size) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119077: " + this.invalidWindowSize$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidWindowSize$str() {
        return invalidWindowSize;
    }

    @Override
    public final IllegalArgumentException acceptorNotExists(Integer id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format("HQ119109: " + this.acceptorNotExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String acceptorNotExists$str() {
        return acceptorNotExists;
    }

    @Override
    public final HornetQLargeMessageException errorReadingBody(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException("HQ119065: " + this.errorReadingBody$str());
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorReadingBody$str() {
        return errorReadingBody;
    }
}

