/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.cluster.BroadcastEndpoint;
import org.hornetq.core.cluster.BroadcastEndpointFactory;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUIDGenerator;

public class BroadcastGroupImpl
implements BroadcastGroup,
Runnable {
    private final String nodeID;
    private final String name;
    private final List<TransportConfiguration> connectors = new ArrayList<TransportConfiguration>();
    private boolean started;
    private ScheduledFuture<?> future;
    private boolean active;
    private boolean loggedBroadcastException = false;
    private final String uniqueID;
    private NotificationService notificationService;
    private long broadcastPeriod;
    private BroadcastEndpoint endpoint;

    public BroadcastGroupImpl(String nodeID, String name, InetAddress localAddress, int localPort, InetAddress groupAddress, int groupPort, boolean active, long broadcastPeriod) throws Exception {
        this(nodeID, name, active, broadcastPeriod, BroadcastEndpointFactory.createUDPEndpoint(groupAddress, groupPort, localAddress, localPort));
    }

    public BroadcastGroupImpl(String nodeID, String name, boolean active, long broadcastPeriod, BroadcastEndpoint endpoint) throws Exception {
        this.nodeID = nodeID;
        this.name = name;
        this.active = active;
        this.broadcastPeriod = broadcastPeriod;
        this.endpoint = endpoint;
        this.uniqueID = UUIDGenerator.getInstance().generateStringUUID();
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.endpoint.openBroadcaster();
        this.started = true;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.BROADCAST_GROUP_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
        try {
            this.endpoint.close();
        }
        catch (Exception e1) {
            HornetQLogger.LOGGER.broadcastGroupClosed(e1);
        }
        this.started = false;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.BROADCAST_GROUP_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.broadcastGroupClosed(e);
            }
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void addConnector(TransportConfiguration tcConfig) {
        this.connectors.add(tcConfig);
    }

    @Override
    public synchronized void removeConnector(TransportConfiguration tcConfig) {
        this.connectors.remove(tcConfig);
    }

    @Override
    public synchronized int size() {
        return this.connectors.size();
    }

    @Override
    public synchronized void activate() {
        this.active = true;
    }

    @Override
    public synchronized void broadcastConnectors() throws Exception {
        if (!this.active) {
            return;
        }
        HornetQBuffer buff = HornetQBuffers.dynamicBuffer((int)4096);
        buff.writeString(this.nodeID);
        buff.writeString(this.uniqueID);
        buff.writeInt(this.connectors.size());
        for (TransportConfiguration tcConfig : this.connectors) {
            tcConfig.encode(buff);
        }
        byte[] data = buff.toByteBuffer().array();
        this.endpoint.broadcast(data);
    }

    @Override
    public void run() {
        if (!this.started) {
            return;
        }
        try {
            this.broadcastConnectors();
            this.loggedBroadcastException = false;
        }
        catch (Exception e) {
            if (!this.loggedBroadcastException) {
                HornetQLogger.LOGGER.errorBroadcastingConnectorConfigs(e);
                this.loggedBroadcastException = true;
            }
            HornetQLogger.LOGGER.debug("Failed to broadcast connector configs...again", e);
        }
    }

    @Override
    public void schedule(ScheduledExecutorService scheduledExecutor) {
        this.future = scheduledExecutor.scheduleWithFixedDelay(this, 0L, this.broadcastPeriod, TimeUnit.MILLISECONDS);
    }
}

