/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.channels.ClosedChannelException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.hornetq.api.core.HornetQAlreadyReplicatingException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.client.impl.TopologyMember;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.AddressSettingsDeployer;
import org.hornetq.core.deployers.impl.BasicUserCredentialsDeployer;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.QueueDeployer;
import org.hornetq.core.deployers.impl.SecurityDeployer;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.SyncSpeedTest;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.postoffice.impl.DivertBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.impl.ChannelImpl;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.remoting.server.impl.RemotingServiceImpl;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.security.impl.SecurityStoreImpl;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MemoryManager;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.ClusterManagerImpl;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.server.group.impl.LocalGroupingHandler;
import org.hornetq.core.server.group.impl.RemoteGroupingHandler;
import org.hornetq.core.server.impl.AIOFileLockNodeManager;
import org.hornetq.core.server.impl.ConnectorsService;
import org.hornetq.core.server.impl.DivertImpl;
import org.hornetq.core.server.impl.FileLockNodeManager;
import org.hornetq.core.server.impl.MemoryManagerImpl;
import org.hornetq.core.server.impl.QueueFactoryImpl;
import org.hornetq.core.server.impl.QuorumManager;
import org.hornetq.core.server.impl.ReplicationError;
import org.hornetq.core.server.impl.ServerInfo;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.impl.ManagementServiceImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.impl.ResourceManagerImpl;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.SecurityFormatter;
import org.hornetq.utils.VersionLoader;

public class HornetQServerImpl
implements HornetQServer {
    public static final String GENERIC_IGNORED_FILTER = "__HQX=-1";
    private volatile SERVER_STATE state = SERVER_STATE.STOPPED;
    private final Version version;
    private final HornetQSecurityManager securityManager;
    private final Configuration configuration;
    private final MBeanServer mbeanServer;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    private volatile ScheduledExecutorService scheduledPool;
    private volatile ExecutorFactory executorFactory;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile HornetQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private volatile ManagementService managementService;
    private volatile ConnectorsService connectorsService;
    private MemoryManager memoryManager;
    private volatile DeploymentManager deploymentManager;
    private Deployer basicUserCredentialsDeployer;
    private Deployer addressSettingsDeployer;
    private Deployer queueDeployer;
    private Deployer securityDeployer;
    private final Map<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final Object initialiseLock = new Object();
    private CountDownLatch initialised = new CountDownLatch(1);
    private final Object startUpLock = new Object();
    private final Object replicationLock = new Object();
    private volatile boolean backupUpToDate = true;
    private ReplicationManager replicationManager;
    private ReplicationEndpoint replicationEndpoint;
    private final Set<ActivateCallback> activateCallbacks = new HashSet<ActivateCallback>();
    private volatile GroupingHandler groupingHandler;
    private NodeManager nodeManager;
    private String identity;
    private Thread backupActivationThread;
    private Activation activation;
    private final ShutdownOnCriticalErrorListener shutdownOnCriticalIO = new ShutdownOnCriticalErrorListener();
    private final Object failbackCheckerGuard = new Object();
    private boolean cancelFailBackChecker;

    public HornetQServerImpl() {
        this(null, null, null);
    }

    public HornetQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public HornetQServerImpl(Configuration configuration, HornetQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer, HornetQSecurityManager securityManager) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>();
        this.securityRepository.setDefault(new HashSet());
    }

    protected NodeManager createNodeManager(String directory) {
        if (this.configuration.getJournalType() == JournalType.ASYNCIO && AsynchronousFileImpl.isLoaded()) {
            return new AIOFileLockNodeManager(directory);
        }
        return new FileLockNodeManager(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        if (this.state != SERVER_STATE.STOPPED) {
            HornetQLogger.LOGGER.debug("Server already started!");
            return;
        }
        Object object = this.failbackCheckerGuard;
        synchronized (object) {
            this.cancelFailBackChecker = false;
        }
        this.state = SERVER_STATE.INITIALIZING;
        HornetQLogger.LOGGER.debug("Starting server " + this);
        OperationContextImpl.clearContext();
        try {
            boolean wasLive;
            this.checkJournalDirectory();
            this.nodeManager = this.createNodeManager(this.configuration.getJournalDirectory());
            this.nodeManager.start();
            HornetQLogger.LOGGER.serverStarting(this.configuration.isBackup() ? "backup" : "live", this.configuration);
            if (this.configuration.isRunSyncSpeedTest()) {
                SyncSpeedTest test = new SyncSpeedTest();
                test.run();
            }
            boolean bl = wasLive = !this.configuration.isBackup();
            if (!this.configuration.isBackup()) {
                this.activation = this.configuration.isSharedStore() && this.configuration.isPersistenceEnabled() ? new SharedStoreLiveActivation() : new SharedNothingLiveActivation();
                this.activation.run();
            }
            if (this.configuration.isBackup()) {
                if (this.configuration.isSharedStore()) {
                    this.activation = new SharedStoreBackupActivation();
                } else {
                    assert (this.replicationEndpoint == null);
                    this.backupUpToDate = false;
                    this.replicationEndpoint = new ReplicationEndpoint(this, this.shutdownOnCriticalIO, wasLive);
                    this.activation = new SharedNothingBackupActivation(wasLive);
                }
                this.backupActivationThread = new Thread((Runnable)this.activation, HornetQMessageBundle.BUNDLE.activationForServer(this));
                this.backupActivationThread.start();
            } else {
                this.state = SERVER_STATE.STARTED;
                HornetQLogger.LOGGER.serverStarted(this.getVersion().getFullVersion(), this.nodeManager.getNodeId(), this.identity != null ? this.identity : "");
            }
            this.connectorsService = new ConnectorsService(this.configuration, this.storageManager, this.scheduledPool, this.postOffice);
            this.connectorsService.start();
        }
        finally {
            OperationContextImpl.clearContext();
        }
    }

    protected void finalize() throws Throwable {
        if (this.state != SERVER_STATE.STOPPED) {
            HornetQLogger.LOGGER.serverFinalisedWIthoutBeingSTopped();
            this.stop();
        }
        super.finalize();
    }

    public void stopTheServer() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    HornetQServerImpl.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.failbackCheckerGuard;
        synchronized (object) {
            this.cancelFailBackChecker = true;
        }
        this.stop(this.configuration.isFailoverOnServerShutdown());
    }

    @Override
    public void threadDump(String reason) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        Map<Thread, StackTraceElement[]> stackTrace = Thread.getAllStackTraces();
        out.println(HornetQMessageBundle.BUNDLE.generatingThreadDump(reason));
        out.println("*******************************************************************************");
        for (Map.Entry<Thread, StackTraceElement[]> el : stackTrace.entrySet()) {
            out.println("===============================================================================");
            out.println(HornetQMessageBundle.BUNDLE.threadDump(el.getKey(), el.getKey().getName(), el.getKey().getId(), el.getKey().getThreadGroup()));
            out.println();
            for (StackTraceElement traceEl : el.getValue()) {
                out.println(traceEl);
            }
        }
        out.println("===============================================================================");
        out.println(HornetQMessageBundle.BUNDLE.endThreadDump());
        out.println("*******************************************************************************");
        HornetQLogger.LOGGER.warn(str.toString());
    }

    @Override
    public void stop(boolean failoverOnServerShutdown) throws Exception {
        this.stop(failoverOnServerShutdown, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean failoverOnServerShutdown, boolean criticalIOError) throws Exception {
        HornetQServerImpl hornetQServerImpl = this;
        synchronized (hornetQServerImpl) {
            if (this.state == SERVER_STATE.STOPPED) {
                return;
            }
            if (this.replicationManager != null) {
                this.remotingService.freeze(this.replicationManager.getBackupTransportConnection());
                final ReplicationManager replicationManager = this.replicationManager;
                this.scheduledPool.schedule(new Runnable(){

                    @Override
                    public void run() {
                        replicationManager.clearReplicationTokens();
                    }
                }, 10L, TimeUnit.SECONDS);
                this.replicationManager.sendLiveIsStopping();
                HornetQServerImpl.stopComponent(this.replicationManager);
            }
            HornetQServerImpl.stopComponent(this.connectorsService);
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                this.groupingHandler = null;
            }
            HornetQServerImpl.stopComponent(this.clusterManager);
        }
        if (this.remotingService != null) {
            this.remotingService.stop(criticalIOError);
        }
        for (ServerSession serverSession : this.sessions.values()) {
            try {
                this.storageManager.setContext(serverSession.getSessionContext());
                serverSession.close(true);
                if (criticalIOError) continue;
                serverSession.waitContextCompletion();
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
            }
        }
        if (this.storageManager != null) {
            this.storageManager.clearContext();
        }
        hornetQServerImpl = this;
        synchronized (hornetQServerImpl) {
            Object object = this.startUpLock;
            synchronized (object) {
                if (this.configuration.isFileDeploymentEnabled()) {
                    HornetQServerImpl.stopComponent(this.basicUserCredentialsDeployer);
                    HornetQServerImpl.stopComponent(this.addressSettingsDeployer);
                    HornetQServerImpl.stopComponent(this.queueDeployer);
                    HornetQServerImpl.stopComponent(this.securityDeployer);
                    HornetQServerImpl.stopComponent(this.deploymentManager);
                }
                if (this.managementService != null) {
                    this.managementService.unregisterServer();
                }
                HornetQServerImpl.stopComponent(this.managementService);
                HornetQServerImpl.stopComponent(this.replicationManager);
                HornetQServerImpl.stopComponent(this.pagingManager);
                HornetQServerImpl.stopComponent(this.replicationEndpoint);
                if (!criticalIOError) {
                    HornetQServerImpl.stopComponent(this.storageManager);
                }
                HornetQServerImpl.stopComponent(this.securityManager);
                HornetQServerImpl.stopComponent(this.resourceManager);
                HornetQServerImpl.stopComponent(this.postOffice);
                if (this.scheduledPool != null) {
                    this.scheduledPool.shutdownNow();
                }
                HornetQServerImpl.stopComponent(this.memoryManager);
                if (this.threadPool != null) {
                    this.threadPool.shutdown();
                    try {
                        if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                            HornetQLogger.LOGGER.timedOutStoppingThreadpool(this.threadPool);
                            for (Runnable r : this.threadPool.shutdownNow()) {
                                HornetQLogger.LOGGER.debug("Cancelled the execution of " + r);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.scheduledPool = null;
                this.threadPool = null;
                if (this.securityStore != null) {
                    this.securityStore.stop();
                }
                this.threadPool = null;
                this.scheduledPool = null;
                this.pagingManager = null;
                this.securityStore = null;
                this.resourceManager = null;
                this.replicationManager = null;
                this.replicationEndpoint = null;
                this.postOffice = null;
                this.queueFactory = null;
                this.resourceManager = null;
                this.messagingServerControl = null;
                this.memoryManager = null;
                this.sessions.clear();
                this.state = SERVER_STATE.STOPPED;
                Object object2 = this.initialiseLock;
                synchronized (object2) {
                    if (this.initialised.getCount() < 1L) {
                        this.initialised = new CountDownLatch(1);
                    }
                }
            }
            SimpleString simpleString = this.getNodeID();
            if (this.activation != null) {
                this.activation.close(failoverOnServerShutdown);
            }
            if (this.backupActivationThread != null) {
                this.backupActivationThread.join(30000L);
                if (this.backupActivationThread.isAlive()) {
                    HornetQLogger.LOGGER.backupActivationDidntFinish(this);
                    this.backupActivationThread.interrupt();
                }
            }
            HornetQServerImpl.stopComponent(this.nodeManager);
            this.nodeManager = null;
            this.addressSettingsRepository.clearListeners();
            this.addressSettingsRepository.clearCache();
            if (this.identity != null) {
                HornetQLogger.LOGGER.serverStopped("identity=" + this.identity + ",version=" + this.getVersion().getFullVersion(), simpleString);
            } else {
                HornetQLogger.LOGGER.serverStopped(this.getVersion().getFullVersion(), simpleString);
            }
        }
    }

    private static void stopComponent(HornetQComponent component) throws Exception {
        if (component != null) {
            component.stop();
        }
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println(HornetQMessageBundle.BUNDLE.serverDescribe(this.identity, this.getClusterManager().describe()));
        return str.toString();
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public HornetQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public boolean isStarted() {
        return this.state == SERVER_STATE.STARTED;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback) throws Exception {
        if (this.securityStore != null) {
            this.securityStore.authenticate(username, password);
        }
        ServerSessionImpl session = new ServerSessionImpl(name, username, password, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback);
        this.sessions.put(name, session);
        return session;
    }

    private synchronized ReplicationEndpoint connectToReplicationEndpoint(Channel channel) throws Exception {
        if (!this.configuration.isBackup()) {
            throw HornetQMessageBundle.BUNDLE.serverNotBackupServer();
        }
        channel.setHandler(this.replicationEndpoint);
        if (this.replicationEndpoint.getChannel() != null) {
            throw HornetQMessageBundle.BUNDLE.alreadyHaveReplicationServer();
        }
        this.replicationEndpoint.setChannel(channel);
        return this.replicationEndpoint;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public boolean lookupSession(String key, String value) {
        Set<ServerSession> allSessions = this.getSessions();
        for (ServerSession session : allSessions) {
            String metaValue = session.getMetaData(key);
            if (metaValue == null || !metaValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<ServerSession> getSessions(String connectionID) {
        Set<Map.Entry<String, ServerSession>> sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry<String, ServerSession> sessionEntry : sessionEntries) {
            ServerSession serverSession = sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public synchronized Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialised() {
        Object object = this.initialiseLock;
        synchronized (object) {
            return this.initialised.getCount() < 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForInitialization(long timeout, TimeUnit unit) throws InterruptedException {
        CountDownLatch latch;
        Object object = this.initialiseLock;
        synchronized (object) {
            latch = this.initialised;
        }
        return latch.await(timeout, unit);
    }

    @Override
    public HornetQServerControlImpl getHornetQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnections().size();
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeManager == null ? null : this.nodeManager.getNodeId();
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, durable, temporary, false);
    }

    @Override
    public Queue locateQueue(SimpleString queueName) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            return null;
        }
        Bindable queue = binding.getBindable();
        if (!(queue instanceof Queue)) {
            throw new IllegalStateException("locateQueue should only be used to locate queues");
        }
        return (Queue)binding.getBindable();
    }

    @Override
    public Queue deployQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        HornetQLogger.LOGGER.deployQueue(queueName);
        return this.createQueue(address, queueName, filterString, durable, temporary, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, ServerSession session) throws Exception {
        PageSubscription subs;
        this.addressSettingsRepository.clearCache();
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw HornetQMessageBundle.BUNDLE.noSuchQueue(queueName);
        }
        Queue queue = (Queue)binding.getBindable();
        if (queue.getConsumerCount() != 0) {
            HornetQMessageBundle.BUNDLE.cannotDeleteQueue(queue.getName(), queueName, binding.getClass().getName());
        }
        if (session != null) {
            if (queue.isDurable()) {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_DURABLE_QUEUE, session);
            } else {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_NON_DURABLE_QUEUE, session);
            }
        }
        this.postOffice.removeBinding(queueName);
        queue.deleteAllReferences();
        if (queue.isDurable()) {
            this.storageManager.deleteQueueBinding(queue.getID());
        }
        if (queue.getPageSubscription() != null) {
            queue.getPageSubscription().close();
        }
        if ((subs = queue.getPageSubscription()) != null) {
            subs.cleanupEntries(true);
        }
    }

    @Override
    public synchronized void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public synchronized void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        this.groupingHandler = groupingHandler;
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    @Override
    public ConnectorsService getConnectorsService() {
        return this.connectorsService;
    }

    @Override
    public void deployDivert(DivertConfiguration config) throws Exception {
        if (config.getName() == null) {
            HornetQLogger.LOGGER.divertWithNoName();
            return;
        }
        if (config.getAddress() == null) {
            HornetQLogger.LOGGER.divertWithNoAddress();
            return;
        }
        if (config.getForwardingAddress() == null) {
            HornetQLogger.LOGGER.divertWithNoForwardingAddress();
            return;
        }
        SimpleString sName = new SimpleString(config.getName());
        if (this.postOffice.getBinding(sName) != null) {
            HornetQLogger.LOGGER.divertBindingNotExists(sName);
            return;
        }
        SimpleString sAddress = new SimpleString(config.getAddress());
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        DivertImpl divert = new DivertImpl(new SimpleString(config.getForwardingAddress()), sName, new SimpleString(config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager);
        DivertBinding binding = new DivertBinding(this.storageManager.generateUniqueID(), sAddress, divert);
        this.postOffice.addBinding(binding);
        this.managementService.registerDivert(divert, config);
    }

    @Override
    public void destroyDivert(SimpleString name) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null) {
            throw HornetQMessageBundle.BUNDLE.noBindingForDivert(name);
        }
        if (!(binding instanceof DivertBinding)) {
            throw HornetQMessageBundle.BUNDLE.bindingNotDivert(name);
        }
        this.postOffice.removeBinding(name);
    }

    @Override
    public void deployBridge(BridgeConfiguration config) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.deployBridge(config, true);
        }
    }

    @Override
    public void destroyBridge(String name) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.destroyBridge(name);
        }
    }

    @Override
    public ServerSession getSessionByID(String sessionName) {
        return this.sessions.get(sessionName);
    }

    public String toString() {
        if (this.identity != null) {
            return "HornetQServerImpl::" + this.identity;
        }
        return "HornetQServerImpl::" + (this.nodeManager != null ? "serverUUID=" + this.nodeManager.getUUID() : "");
    }

    public void replaceQueueFactory(QueueFactory factory) {
        this.queueFactory = factory;
    }

    private PagingManager createPagingManager() {
        return new PagingManagerImpl(new PagingStoreFactoryNIO(this.configuration.getPagingDirectory(), this.configuration.getJournalBufferSize_NIO(), this.scheduledPool, this.executorFactory, this.configuration.isJournalSyncNonTransactional(), this.shutdownOnCriticalIO), this.storageManager, this.addressSettingsRepository);
    }

    private StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            return new JournalStorageManager(this.configuration, this.executorFactory, this.shutdownOnCriticalIO);
        }
        return new NullStorageManager();
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    private synchronized void initialisePart1() throws Exception {
        if (this.state == SERVER_STATE.STOPPED) {
            return;
        }
        HornetQThreadFactory tFactory = new HornetQThreadFactory("HornetQ-server-" + this.toString(), false, HornetQServerImpl.getThisClassLoader());
        this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? Executors.newCachedThreadPool((ThreadFactory)tFactory) : Executors.newFixedThreadPool(this.configuration.getThreadPoolMaxSize(), (ThreadFactory)tFactory);
        this.executorFactory = new OrderedExecutorFactory(this.threadPool);
        this.scheduledPool = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), (ThreadFactory)new HornetQThreadFactory("HornetQ-scheduled-threads", false, HornetQServerImpl.getThisClassLoader()));
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManagerImpl(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.deploymentManager = new FileDeploymentManager(this.configuration.getFileDeployerScanPeriod());
        }
        this.callPreActiveCallbacks();
        this.storageManager = this.createStorageManager();
        if ("HORNETQ.CLUSTER.ADMIN.USER".equals(this.configuration.getClusterUser()) && "CHANGE ME!!".equals(this.configuration.getClusterPassword())) {
            HornetQLogger.LOGGER.clusterSecurityRisk();
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService);
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl((int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getMessageExpiryThreadPriority(), this.configuration.isWildcardRoutingEnabled(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.clusterManager = new ClusterManagerImpl(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.nodeManager.getUUID(), this.configuration.isBackup(), this.configuration.isClustered());
        this.clusterManager.deploy();
        this.remotingService = new RemotingServiceImpl(this.clusterManager, this.configuration, this, this.managementService, this.scheduledPool);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.configuration.isBackup());
        if (this.configuration.isFileDeploymentEnabled()) {
            this.addressSettingsDeployer = new AddressSettingsDeployer(this.deploymentManager, this.addressSettingsRepository);
            this.addressSettingsDeployer.start();
        }
        this.deployAddressSettingsFromConfiguration();
        this.storageManager.start();
        if (this.securityManager != null) {
            this.securityManager.start();
        }
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        if (this.configuration.isFileDeploymentEnabled()) {
            this.basicUserCredentialsDeployer = new BasicUserCredentialsDeployer(this.deploymentManager, this.securityManager);
            this.basicUserCredentialsDeployer.start();
            if (this.securityManager != null) {
                this.securityDeployer = new SecurityDeployer(this.deploymentManager, this.securityRepository);
                this.securityDeployer.start();
            }
        }
        this.deploySecurityFromConfiguration();
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
    }

    private synchronized void initialisePart2() throws Exception {
        if (this.state == SERVER_STATE.STOPPED) {
            return;
        }
        this.pagingManager.reloadStores();
        JournalLoadInformation[] journalInfo = this.loadJournals();
        this.compareJournals(journalInfo);
        final ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    HornetQLogger.LOGGER.dumpServerInfo(dumper.dump());
                }
            }, 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.queueDeployer = new QueueDeployer(this.deploymentManager, this);
            this.queueDeployer.start();
        } else {
            this.deployQueuesFromConfiguration();
        }
        this.callActivateCallbacks();
        this.deployDiverts();
        if (this.deploymentManager != null) {
            this.deploymentManager.start();
        }
        this.clusterManager.start();
        this.remotingService.start();
        this.initialised.countDown();
    }

    private void compareJournals(JournalLoadInformation[] journalInfo) throws Exception {
        if (this.replicationManager != null) {
            this.replicationManager.compareJournals(journalInfo);
        }
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        for (CoreQueueConfiguration config : this.configuration.getQueueConfigurations()) {
            this.deployQueue(SimpleString.toSimpleString((String)config.getAddress()), SimpleString.toSimpleString((String)config.getName()), SimpleString.toSimpleString((String)config.getFilterString()), config.isDurable(), false);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressesSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private JournalLoadInformation[] loadJournals() throws Exception {
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos);
        this.recoverStoredConfigs();
        HashMap<Long, Queue> queues = new HashMap<Long, Queue>();
        HashMap<Long, QueueBindingInfo> queueBindingInfosMap = new HashMap<Long, QueueBindingInfo>();
        for (QueueBindingInfo queueBindingInfo : queueBindingInfos) {
            queueBindingInfosMap.put(queueBindingInfo.getId(), queueBindingInfo);
            if (queueBindingInfo.getFilterString() != null && queueBindingInfo.getFilterString().toString().equals(GENERIC_IGNORED_FILTER)) continue;
            Filter filter = FilterImpl.createFilter(queueBindingInfo.getFilterString());
            PageSubscription pageSubscription = this.pagingManager.getPageStore(queueBindingInfo.getAddress()).getCursorProvider().createSubscription(queueBindingInfo.getId(), filter, true);
            Queue queue = this.queueFactory.createQueue(queueBindingInfo.getId(), queueBindingInfo.getAddress(), queueBindingInfo.getQueueName(), filter, pageSubscription, true, false);
            LocalQueueBinding binding = new LocalQueueBinding(queueBindingInfo.getAddress(), queue, this.nodeManager.getNodeId());
            queues.put(queueBindingInfo.getId(), queue);
            this.postOffice.addBinding(binding);
            this.managementService.registerAddress(queueBindingInfo.getAddress());
            this.managementService.registerQueue(queue, queueBindingInfo.getAddress(), this.storageManager);
        }
        for (GroupingInfo groupingInfo : groupingInfos) {
            if (this.groupingHandler == null) continue;
            this.groupingHandler.addGroupBinding(new GroupBinding(groupingInfo.getId(), groupingInfo.getGroupId(), groupingInfo.getClusterName()));
        }
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        HashSet<Pair<Long, Long>> pendingLargeMessages = new HashSet<Pair<Long, Long>>();
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queues, queueBindingInfosMap, duplicateIDMap, pendingLargeMessages);
        for (Map.Entry entry : duplicateIDMap.entrySet()) {
            SimpleString address = (SimpleString)entry.getKey();
            DuplicateIDCache cache = this.postOffice.getDuplicateIDCache(address);
            if (!this.configuration.isPersistIDCache()) continue;
            cache.load((List)entry.getValue());
        }
        for (Pair pair : pendingLargeMessages) {
            HornetQLogger.LOGGER.deletingPendingMessage((Pair<Long, Long>)pair);
            LargeServerMessage msg = this.storageManager.createLargeMessage();
            msg.setMessageID((Long)pair.getB());
            msg.setPendingRecordID((Long)pair.getA());
            msg.setDurable(true);
            msg.deleteFile();
        }
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        List<PersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (PersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
        List<PersistedRoles> roles = this.storageManager.recoverPersistedRoles();
        for (PersistedRoles roleItem : roles) {
            Set<Role> setRoles = SecurityFormatter.createSecurity(roleItem.getSendRoles(), roleItem.getConsumeRoles(), roleItem.getCreateDurableQueueRoles(), roleItem.getDeleteDurableQueueRoles(), roleItem.getCreateNonDurableQueueRoles(), roleItem.getDeleteNonDurableQueueRoles(), roleItem.getManageRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    private Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean ignoreIfExists) throws Exception {
        QueueBinding binding = (QueueBinding)this.postOffice.getBinding(queueName);
        if (binding != null) {
            if (ignoreIfExists) {
                return binding.getQueue();
            }
            throw HornetQMessageBundle.BUNDLE.queueAlreadyExists(queueName);
        }
        Filter filter = FilterImpl.createFilter(filterString);
        long txID = this.storageManager.generateUniqueID();
        long queueID = this.storageManager.generateUniqueID();
        PageSubscription pageSubscription = filterString != null && filterString.toString().equals(GENERIC_IGNORED_FILTER) ? null : this.pagingManager.getPageStore(address).getCursorProvider().createSubscription(queueID, filter, durable);
        Queue queue = this.queueFactory.createQueue(queueID, address, queueName, filter, pageSubscription, durable, temporary);
        binding = new LocalQueueBinding(address, queue, this.nodeManager.getNodeId());
        if (durable) {
            this.storageManager.addQueueBinding(txID, binding);
        }
        try {
            this.postOffice.addBinding(binding);
            if (durable) {
                this.storageManager.commitBindings(txID);
            }
        }
        catch (Exception e) {
            if (durable) {
                this.storageManager.rollbackBindings(txID);
            }
            queue.close();
            pageSubscription.close();
            throw e;
        }
        this.managementService.registerAddress(address);
        this.managementService.registerQueue(queue, address, this.storageManager);
        return queue;
    }

    private void deployDiverts() throws Exception {
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            this.deployDivert(config);
        }
    }

    private void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupingHandler groupingHandler = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout()) : new RemoteGroupingHandler(this.managementService, config.getName(), config.getAddress(), config.getTimeout());
            this.groupingHandler = groupingHandler;
            this.managementService.addNotificationListener(groupingHandler);
        }
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            transformer = (Transformer)this.instantiateInstance(transformerClassName);
        }
        return transformer;
    }

    private Object instantiateInstance(String className) {
        return HornetQServerImpl.safeInitNewInstance(className);
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private void checkJournalDirectory() {
        File journalDir = new File(this.configuration.getJournalDirectory());
        if (!journalDir.exists()) {
            if (this.configuration.isCreateJournalDir()) {
                journalDir.mkdirs();
            } else {
                throw HornetQMessageBundle.BUNDLE.cannotCreateDir(journalDir.getAbsolutePath());
            }
        }
    }

    private void startFailbackChecker() {
        this.scheduledPool.scheduleAtFixedRate(new FailbackChecker(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplication(CoreRemotingConnection rc, final ClusterConnection clusterConnection, final Pair<TransportConfiguration, TransportConfiguration> pair, final boolean isFailBackRequest) throws HornetQException {
        if (this.replicationManager != null) {
            throw new HornetQAlreadyReplicatingException();
        }
        if (!this.isStarted()) {
            throw new IllegalStateException();
        }
        Object object = this.replicationLock;
        synchronized (object) {
            if (this.replicationManager != null) {
                throw new HornetQAlreadyReplicatingException();
            }
            ReplicationFailureListener listener = new ReplicationFailureListener();
            rc.addCloseListener(listener);
            rc.addFailureListener(listener);
            this.replicationManager = new ReplicationManager(rc, this.executorFactory);
            this.replicationManager.start();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HornetQServerImpl.this.storageManager.startReplication(HornetQServerImpl.this.replicationManager, HornetQServerImpl.this.pagingManager, HornetQServerImpl.this.getNodeID().toString(), isFailBackRequest && HornetQServerImpl.this.configuration.isAllowAutoFailBack());
                        clusterConnection.nodeAnnounced(System.currentTimeMillis(), HornetQServerImpl.this.getNodeID().toString(), (Pair<TransportConfiguration, TransportConfiguration>)pair, true);
                        if (isFailBackRequest && HornetQServerImpl.this.configuration.isAllowAutoFailBack()) {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Thread.sleep(5000L);
                                        HornetQServerImpl.this.stop(true);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }).start();
                        }
                    }
                    catch (Exception e) {
                        HornetQLogger.LOGGER.errorStartingReplication(e);
                        try {
                            if (HornetQServerImpl.this.replicationManager != null) {
                                HornetQServerImpl.this.replicationManager.stop();
                            }
                        }
                        catch (Exception hqe) {
                            HornetQLogger.LOGGER.errorStoppingReplication(hqe);
                        }
                        finally {
                            Object object = HornetQServerImpl.this.replicationLock;
                            synchronized (object) {
                                HornetQServerImpl.this.replicationManager = null;
                            }
                        }
                    }
                }
            });
            t.start();
        }
    }

    public boolean isRemoteBackupUpToDate() {
        return this.backupUpToDate;
    }

    public void setRemoteBackupUpToDate() {
        this.clusterManager.announceBackup();
        this.backupUpToDate = true;
    }

    public void remoteFailOver() throws HornetQException {
        if (!this.configuration.isBackup() || this.configuration.isSharedStore()) {
            throw new HornetQInternalErrorException();
        }
        if (!this.backupUpToDate) {
            return;
        }
        if (this.activation instanceof SharedNothingBackupActivation) {
            ((SharedNothingBackupActivation)this.activation).failOver();
        }
    }

    private final class ReplicationFailureListener
    implements FailureListener,
    CloseListener {
        private ReplicationFailureListener() {
        }

        @Override
        public void connectionFailed(HornetQException exception, boolean failedOver) {
            this.connectionClosed();
        }

        @Override
        public void connectionClosed() {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = HornetQServerImpl.this.replicationLock;
                    synchronized (object) {
                        if (HornetQServerImpl.this.replicationManager != null) {
                            HornetQServerImpl.this.storageManager.stopReplication();
                            HornetQServerImpl.this.replicationManager = null;
                        }
                    }
                }
            });
        }
    }

    private final class SharedNothingLiveActivation
    implements Activation {
        private SharedNothingLiveActivation() {
        }

        @Override
        public void run() {
            try {
                if (HornetQServerImpl.this.configuration.isClustered() && this.isNodeIdUsed()) {
                    HornetQServerImpl.this.configuration.setBackup(true);
                    return;
                }
                HornetQServerImpl.this.initialisePart1();
                HornetQServerImpl.this.initialisePart2();
                if (HornetQServerImpl.this.identity != null) {
                    HornetQLogger.LOGGER.serverIsLive(HornetQServerImpl.this.identity);
                } else {
                    HornetQLogger.LOGGER.serverIsLive();
                }
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.initializationError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isNodeIdUsed() throws Exception {
            SimpleString nodeId0;
            if (HornetQServerImpl.this.configuration.getFailBackConnectors().isEmpty()) {
                return false;
            }
            try {
                nodeId0 = HornetQServerImpl.this.nodeManager.readNodeId();
            }
            catch (HornetQIllegalStateException e) {
                nodeId0 = null;
            }
            ServerLocator locator = null;
            ClientSessionFactory factory = null;
            try {
                TransportConfiguration[] tpArray = HornetQServerImpl.this.configuration.getFailBackConnectors().toArray(new TransportConfiguration[1]);
                locator = (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA(tpArray);
                locator.setReconnectAttempts(0);
                try {
                    factory = locator.connect();
                }
                catch (HornetQNotConnectedException notConnected) {
                    boolean bl = false;
                    if (factory != null) {
                        factory.close();
                    }
                    if (locator != null) {
                        locator.close();
                    }
                    return bl;
                }
                Thread.sleep(5000L);
                Topology topology = locator.getTopology();
                if (topology.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                if (nodeId0 != null) {
                    TopologyMember node = topology.getMember(nodeId0.toString());
                    if (node != null) {
                        boolean bl = true;
                        return bl;
                    }
                    HornetQServerImpl.this.stopTheServer();
                    throw new HornetQException("Fail-back servers found but node is different ('local nodeId'=" + nodeId0 + ")");
                }
                boolean bl = !topology.isEmpty();
                return bl;
            }
            finally {
                if (factory != null) {
                    factory.close();
                }
                if (locator != null) {
                    locator.close();
                }
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
            if (nodeManagerInUse != null) {
                if (permanently) {
                    nodeManagerInUse.crashLiveServer();
                } else {
                    nodeManagerInUse.pauseLiveServer();
                }
            }
        }
    }

    private final class SharedNothingBackupActivation
    implements Activation,
    ClusterTopologyListener {
        private volatile ServerLocatorInternal serverLocator0;
        private volatile boolean failedToConnect;
        private volatile QuorumManager quorumManager;
        private final boolean attemptFailBack;
        private static final int MAX_TOPOLOGY_WAIT = 60;
        private final CountDownLatch latch = new CountDownLatch(1);
        private String nodeID;
        private Object liveConnector;
        private boolean closed;

        public SharedNothingBackupActivation(boolean attemptFailBack) {
            this.attemptFailBack = attemptFailBack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object liveConnectorName;
                ClientSessionFactoryInternal liveServerSessionFactory;
                Object liveConnectorName2;
                this.moveServerData();
                TransportConfiguration[] tp = null;
                if (this.attemptFailBack) {
                    tp = HornetQServerImpl.this.configuration.getFailBackConnectors().toArray(new TransportConfiguration[1]);
                } else {
                    liveConnectorName2 = HornetQServerImpl.this.configuration.getLiveConnectorName();
                    if (liveConnectorName2 == null) {
                        throw HornetQMessageBundle.BUNDLE.noLiveForReplicatedBackup();
                    }
                    tp = new TransportConfiguration[]{HornetQServerImpl.this.configuration.getConnectorConfigurations().get(liveConnectorName2)};
                }
                liveConnectorName2 = HornetQServerImpl.this;
                synchronized (liveConnectorName2) {
                    HornetQServerImpl.this.state = SERVER_STATE.STARTED;
                }
                liveConnectorName2 = this;
                synchronized (liveConnectorName2) {
                    block38: {
                        if (!this.closed) break block38;
                        return;
                    }
                    this.serverLocator0 = (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA(tp);
                }
                this.serverLocator0.setReconnectAttempts(-1);
                this.serverLocator0.setInitialConnectAttempts(-1);
                this.serverLocator0.addInterceptor(new ReplicationError(HornetQServerImpl.this));
                if (!this.attemptFailBack) {
                    this.serverLocator0.addClusterTopologyListener(this);
                }
                if ((liveServerSessionFactory = this.serverLocator0.connect()) == null) {
                    throw new RuntimeException("Could not estabilish the connection");
                }
                if (!this.attemptFailBack) {
                    liveConnectorName = HornetQServerImpl.this.configuration.getLiveConnectorName();
                    this.liveConnector = HornetQServerImpl.this.configuration.getConnectorConfigurations().get(liveConnectorName);
                    this.latch.await(60L, TimeUnit.SECONDS);
                    if (this.nodeID == null) {
                        throw new RuntimeException("Could not estabilish the connection");
                    }
                    this.serverLocator0.removeClusterTopologyListener(this);
                    HornetQServerImpl.this.nodeManager.setNodeID(this.nodeID);
                }
                HornetQServerImpl.this.nodeManager.startBackup();
                HornetQServerImpl.this.initialisePart1();
                HornetQServerImpl.this.clusterManager.start();
                liveConnectorName = this;
                synchronized (liveConnectorName) {
                    block39: {
                        if (!this.closed) break block39;
                        return;
                    }
                    this.quorumManager = new QuorumManager(HornetQServerImpl.this, this.serverLocator0, HornetQServerImpl.this.threadPool, HornetQServerImpl.this.getIdentity());
                }
                HornetQServerImpl.this.replicationEndpoint.setQuorumManager(this.quorumManager);
                HornetQServerImpl.this.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            liveServerSessionFactory.setReconnectAttempts(1);
                            SharedNothingBackupActivation.this.quorumManager.setSessionFactory(liveServerSessionFactory);
                            CoreRemotingConnection liveConnection = liveServerSessionFactory.getConnection();
                            SharedNothingBackupActivation.this.quorumManager.addAsFailureListenerOf(liveConnection);
                            Channel pingChannel = liveConnection.getChannel(ChannelImpl.CHANNEL_ID.PING.id, -1);
                            Channel replicationChannel = liveConnection.getChannel(ChannelImpl.CHANNEL_ID.REPLICATION.id, -1);
                            HornetQServerImpl.this.connectToReplicationEndpoint(replicationChannel);
                            HornetQServerImpl.this.replicationEndpoint.start();
                            HornetQServerImpl.this.clusterManager.announceReplicatingBackupToLive(pingChannel, SharedNothingBackupActivation.this.attemptFailBack);
                        }
                        catch (Exception e) {
                            HornetQLogger.LOGGER.replicationStartProblem(e);
                            SharedNothingBackupActivation.this.failedToConnect = true;
                            SharedNothingBackupActivation.this.quorumManager.causeExit();
                            try {
                                if (HornetQServerImpl.this.state != SERVER_STATE.STOPPED) {
                                    HornetQServerImpl.this.stopTheServer();
                                }
                                return;
                            }
                            catch (Exception e1) {
                                throw new RuntimeException(e1);
                            }
                        }
                    }
                });
                HornetQLogger.LOGGER.backupServerStarted(HornetQServerImpl.this.version.getFullVersion(), HornetQServerImpl.this.nodeManager.getNodeId());
                HornetQServerImpl.this.state = SERVER_STATE.STARTED;
                if (this.failedToConnect) {
                    return;
                }
                QuorumManager.BACKUP_ACTIVATION signal = this.quorumManager.waitForStatusChange();
                liveServerSessionFactory.close();
                this.serverLocator0.close();
                HornetQServerImpl.stopComponent(HornetQServerImpl.this.replicationEndpoint);
                if (this.failedToConnect || !HornetQServerImpl.this.isStarted() || signal == QuorumManager.BACKUP_ACTIVATION.STOP) {
                    return;
                }
                if (!HornetQServerImpl.this.isRemoteBackupUpToDate()) {
                    throw HornetQMessageBundle.BUNDLE.backupServerNotInSync();
                }
                HornetQServerImpl.this.configuration.setBackup(false);
                Object object = HornetQServerImpl.this.startUpLock;
                synchronized (object) {
                    block40: {
                        if (HornetQServerImpl.this.isStarted()) break block40;
                        return;
                    }
                    HornetQLogger.LOGGER.becomingLive(HornetQServerImpl.this);
                    HornetQServerImpl.this.nodeManager.stopBackup();
                    HornetQServerImpl.this.storageManager.start();
                    HornetQServerImpl.this.initialisePart2();
                    HornetQServerImpl.this.clusterManager.activate();
                }
            }
            catch (Exception e) {
                if ((e instanceof InterruptedException || e instanceof IllegalStateException) && !HornetQServerImpl.this.isStarted()) {
                    return;
                }
                HornetQLogger.LOGGER.initializationError(e);
                e.printStackTrace();
            }
            finally {
                if (this.serverLocator0 != null) {
                    this.serverLocator0.close();
                }
            }
        }

        private void moveServerData() {
            String[] dataDirs = new String[]{HornetQServerImpl.this.configuration.getBindingsDirectory(), HornetQServerImpl.this.configuration.getJournalDirectory(), HornetQServerImpl.this.configuration.getPagingDirectory(), HornetQServerImpl.this.configuration.getLargeMessagesDirectory()};
            boolean allEmpty = true;
            int lowestSuffixForMovedData = 1;
            for (String dir : dataDirs) {
                File fDir = new File(dir);
                if (fDir.isDirectory() && fDir.list().length > 0) {
                    allEmpty = false;
                }
                String sanitizedPath = fDir.getPath();
                while (new File(sanitizedPath + lowestSuffixForMovedData).exists()) {
                    ++lowestSuffixForMovedData;
                }
            }
            if (allEmpty) {
                return;
            }
            for (String dir0 : dataDirs) {
                File dir = new File(dir0);
                File newPath = new File(dir.getPath() + lowestSuffixForMovedData);
                if (!dir.exists() || !dir.renameTo(newPath)) continue;
                HornetQLogger.LOGGER.backupMovingDataAway(dir0, newPath.getPath());
                dir.mkdir();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(boolean permanently) throws Exception {
            SharedNothingBackupActivation sharedNothingBackupActivation = this;
            synchronized (sharedNothingBackupActivation) {
                if (this.quorumManager != null) {
                    this.quorumManager.causeExit();
                }
                if (this.serverLocator0 != null) {
                    this.serverLocator0.close();
                }
                this.closed = true;
            }
            if (HornetQServerImpl.this.configuration.isBackup()) {
                long timeout = 30000L;
                long start = System.currentTimeMillis();
                NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
                while (HornetQServerImpl.this.backupActivationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
                    if (nodeManagerInUse != null) {
                        nodeManagerInUse.interrupt();
                    }
                    HornetQServerImpl.this.backupActivationThread.interrupt();
                    Thread.sleep(1000L);
                }
                if (System.currentTimeMillis() - start >= timeout) {
                    HornetQLogger.LOGGER.backupActivationProblem();
                }
                if (nodeManagerInUse != null) {
                    nodeManagerInUse.stopBackup();
                }
            }
        }

        public void failOver() {
            this.quorumManager.failOver();
        }

        @Override
        public void nodeUP(long eventUID, String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
            if (this.liveConnector.equals(connectorPair.getA())) {
                this.nodeID = nodeID;
                this.latch.countDown();
            }
        }

        @Override
        public void nodeDown(long eventUID, String nodeID) {
        }
    }

    private static interface Activation
    extends Runnable {
        public void close(boolean var1) throws Exception;
    }

    private final class ShutdownOnCriticalErrorListener
    implements IOCriticalErrorListener {
        boolean failedAlready = false;

        private ShutdownOnCriticalErrorListener() {
        }

        public synchronized void onIOException(HornetQExceptionType code, String message, SequentialFile file) {
            if (!this.failedAlready) {
                this.failedAlready = true;
                HornetQLogger.LOGGER.ioErrorShutdownServer(code, message);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            HornetQServerImpl.this.stop(true, true);
                        }
                        catch (Exception e) {
                            HornetQLogger.LOGGER.errorStoppingServer(e);
                        }
                    }
                }.start();
            }
        }
    }

    private final class SharedStoreBackupActivation
    implements Activation {
        private SharedStoreBackupActivation() {
        }

        @Override
        public void run() {
            try {
                HornetQServerImpl.this.nodeManager.startBackup();
                HornetQServerImpl.this.initialisePart1();
                HornetQServerImpl.this.clusterManager.start();
                HornetQServerImpl.this.state = SERVER_STATE.STARTED;
                HornetQLogger.LOGGER.backupServerStarted(HornetQServerImpl.this.version.getFullVersion(), HornetQServerImpl.this.nodeManager.getNodeId());
                HornetQServerImpl.this.nodeManager.awaitLiveNode();
                HornetQServerImpl.this.configuration.setBackup(false);
                if (HornetQServerImpl.this.state != SERVER_STATE.STARTED) {
                    return;
                }
                HornetQServerImpl.this.initialisePart2();
                HornetQServerImpl.this.clusterManager.activate();
                HornetQLogger.LOGGER.backupServerIsLive();
                HornetQServerImpl.this.nodeManager.releaseBackup();
                if (HornetQServerImpl.this.configuration.isAllowAutoFailBack()) {
                    HornetQServerImpl.this.startFailbackChecker();
                }
            }
            catch (InterruptedException e) {
            }
            catch (ClosedChannelException e) {
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof InterruptedException)) {
                    HornetQLogger.LOGGER.initializationError(e);
                }
            }
            catch (Throwable e) {
                HornetQLogger.LOGGER.initializationError(e);
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
            if (HornetQServerImpl.this.configuration.isBackup()) {
                long timeout = 30000L;
                long start = System.currentTimeMillis();
                while (HornetQServerImpl.this.backupActivationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
                    if (nodeManagerInUse != null) {
                        nodeManagerInUse.interrupt();
                    }
                    HornetQServerImpl.this.backupActivationThread.interrupt();
                    HornetQServerImpl.this.backupActivationThread.join(1000L);
                }
                if (System.currentTimeMillis() - start >= timeout) {
                    HornetQServerImpl.this.threadDump("Timed out waiting for backup activation to exit");
                }
                if (nodeManagerInUse != null) {
                    nodeManagerInUse.stopBackup();
                }
            } else if (nodeManagerInUse != null) {
                if (permanently) {
                    nodeManagerInUse.crashLiveServer();
                } else {
                    nodeManagerInUse.pauseLiveServer();
                }
            }
        }
    }

    private final class SharedStoreLiveActivation
    implements Activation {
        private SharedStoreLiveActivation() {
        }

        @Override
        public void run() {
            try {
                HornetQLogger.LOGGER.awaitingLiveLock();
                HornetQServerImpl.this.checkJournalDirectory();
                if (HornetQLogger.LOGGER.isDebugEnabled()) {
                    HornetQLogger.LOGGER.debug("First part initialization on " + this);
                }
                HornetQServerImpl.this.initialisePart1();
                if (HornetQServerImpl.this.nodeManager.isBackupLive()) {
                    if (HornetQLogger.LOGGER.isDebugEnabled()) {
                        HornetQLogger.LOGGER.debug("announcing backup to the former live" + this);
                    }
                    HornetQServerImpl.this.clusterManager.announceBackup();
                    Thread.sleep(HornetQServerImpl.this.configuration.getFailbackDelay());
                }
                HornetQServerImpl.this.nodeManager.startLiveNode();
                if (HornetQServerImpl.this.state == SERVER_STATE.STOPPED) {
                    return;
                }
                HornetQServerImpl.this.initialisePart2();
                HornetQLogger.LOGGER.serverIsLive();
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.initializationError(e);
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
            if (nodeManagerInUse != null) {
                if (permanently) {
                    nodeManagerInUse.crashLiveServer();
                } else {
                    nodeManagerInUse.pauseLiveServer();
                }
            }
        }
    }

    private class FailbackChecker
    implements Runnable {
        private boolean restarting = false;

        private FailbackChecker() {
        }

        @Override
        public void run() {
            try {
                if (!this.restarting && HornetQServerImpl.this.nodeManager.isAwaitingFailback()) {
                    HornetQLogger.LOGGER.awaitFailBack();
                    this.restarting = true;
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                HornetQLogger.LOGGER.debug(HornetQServerImpl.this + "::Stopping live node in favor of failback");
                                HornetQServerImpl.this.stop(true);
                                Thread.sleep(HornetQServerImpl.this.configuration.getFailbackDelay());
                                Object object = HornetQServerImpl.this.failbackCheckerGuard;
                                synchronized (object) {
                                    if (HornetQServerImpl.this.cancelFailBackChecker) {
                                        return;
                                    }
                                    HornetQServerImpl.this.configuration.setBackup(true);
                                    HornetQLogger.LOGGER.debug(HornetQServerImpl.this + "::Starting backup node now after failback");
                                    HornetQServerImpl.this.start();
                                }
                            }
                            catch (Exception e) {
                                HornetQLogger.LOGGER.serverRestartWarning();
                            }
                        }
                    });
                    t.start();
                }
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.serverRestartWarning(e);
            }
        }
    }

    static enum SERVER_STATE {
        INITIALIZING,
        STARTED,
        STOPPED;

    }
}

