/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.spi.core.protocol.RemotingConnection;

final class ReplicationError
implements Interceptor {
    private final HornetQServer server;

    public ReplicationError(HornetQServer server) {
        this.server = server;
    }

    @Override
    public boolean intercept(Packet packet, RemotingConnection connection) throws HornetQException {
        if (packet.getType() != 116) {
            return true;
        }
        HornetQLogger.LOGGER.errorRegisteringBackup();
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw HornetQMessageBundle.BUNDLE.errorStoppingServer(e, this.server);
        }
        return false;
    }
}

