/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.utils.SizeFormatterUtil;

public class ServerInfo {
    private final HornetQServer server;
    private final PagingManager pagingManager;

    public ServerInfo(HornetQServer server, PagingManager pagingManager) {
        this.server = server;
        this.pagingManager = pagingManager;
    }

    public String dump() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long availableMemory = freeMemory + maxMemory - totalMemory;
        double availableMemoryPercent = 100.0 * (double)availableMemory / (double)maxMemory;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        StringBuilder info = new StringBuilder("\n**** Server Dump ****\n");
        info.append(String.format("date:            %s%n", new Date()));
        info.append(String.format("free memory:      %s%n", SizeFormatterUtil.sizeof(freeMemory)));
        info.append(String.format("max memory:       %s%n", SizeFormatterUtil.sizeof(maxMemory)));
        info.append(String.format("total memory:     %s%n", SizeFormatterUtil.sizeof(totalMemory)));
        info.append(String.format("available memory: %.2f%%%n", availableMemoryPercent));
        info.append(this.appendPagingInfos());
        info.append(String.format("# of thread:     %d%n", threadMXBean.getThreadCount()));
        info.append(String.format("# of conns:      %d%n", this.server.getConnectionCount()));
        info.append("********************\n");
        return info.toString();
    }

    private String appendPagingInfos() {
        StringBuilder info = new StringBuilder();
        for (SimpleString storeName : this.pagingManager.getStoreNames()) {
            try {
                PagingStore pageStore = this.pagingManager.getPageStore(storeName);
                info.append(String.format("\t%s: %s%n", storeName, SizeFormatterUtil.sizeof(pageStore.getPageSizeBytes() * (long)pageStore.getNumberOfPages())));
            }
            catch (Exception e) {
                info.append(String.format("\t%s: %s%n", storeName, e.getMessage()));
            }
        }
        return info.toString();
    }
}

