/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.InputStream;
import java.util.Date;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.MessageReferenceImpl;
import org.hornetq.utils.MemorySize;
import org.hornetq.utils.TypedProperties;

public class ServerMessageImpl
extends MessageImpl
implements ServerMessage {
    private int durableRefCount;
    private int refCount;
    private PagingStore pagingStore;
    private static final int memoryOffset = MemorySize.is64bitArch() ? 352 : 232;
    private volatile int memoryEstimate = -1;

    public ServerMessageImpl() {
    }

    public ServerMessageImpl(long messageID, int initialMessageBufferSize) {
        super(initialMessageBufferSize);
        this.messageID = messageID;
    }

    protected ServerMessageImpl(ServerMessageImpl other) {
        super(other);
    }

    protected ServerMessageImpl(ServerMessageImpl other, TypedProperties properties) {
        super(other, properties);
    }

    @Override
    public boolean isServerMessage() {
        return true;
    }

    @Override
    public void setMessageID(long id) {
        this.messageID = id;
    }

    @Override
    public MessageReference createReference(Queue queue) {
        MessageReferenceImpl ref = new MessageReferenceImpl(this, queue);
        return ref;
    }

    @Override
    public boolean hasInternalProperties() {
        return this.properties.hasInternalProperties();
    }

    @Override
    public synchronized int incrementRefCount() throws Exception {
        ++this.refCount;
        if (this.pagingStore != null) {
            if (this.refCount == 1) {
                this.pagingStore.addSize(this.getMemoryEstimate() + MessageReferenceImpl.getMemoryEstimate());
            } else {
                this.pagingStore.addSize(MessageReferenceImpl.getMemoryEstimate());
            }
        }
        return this.refCount;
    }

    @Override
    public synchronized int decrementRefCount() throws Exception {
        int count = --this.refCount;
        if (this.pagingStore != null) {
            if (count == 0) {
                this.pagingStore.addSize(-this.getMemoryEstimate() - MessageReferenceImpl.getMemoryEstimate());
            } else {
                this.pagingStore.addSize(-MessageReferenceImpl.getMemoryEstimate());
            }
        }
        return count;
    }

    @Override
    public synchronized int incrementDurableRefCount() {
        return ++this.durableRefCount;
    }

    @Override
    public synchronized int decrementDurableRefCount() {
        return --this.durableRefCount;
    }

    @Override
    public synchronized int getRefCount() {
        return this.refCount;
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = memoryOffset + this.buffer.capacity() + this.properties.getMemoryOffset();
        }
        return this.memoryEstimate;
    }

    @Override
    public ServerMessage copy(long newID) {
        ServerMessageImpl m = new ServerMessageImpl(this);
        m.setMessageID(newID);
        return m;
    }

    @Override
    public void finishCopy() throws Exception {
    }

    @Override
    public ServerMessage copy() {
        return new ServerMessageImpl(this);
    }

    @Override
    public ServerMessage makeCopyForExpiryOrDLA(long newID, boolean expiry) throws Exception {
        ServerMessage copy = this.copy(newID);
        copy.finishCopy();
        copy.setOriginalHeaders(this, expiry);
        return copy;
    }

    @Override
    public void setOriginalHeaders(ServerMessage other, boolean expiry) {
        if (other.containsProperty(Message.HDR_ORIG_MESSAGE_ID)) {
            this.putStringProperty(Message.HDR_ORIGINAL_ADDRESS, other.getSimpleStringProperty(Message.HDR_ORIGINAL_ADDRESS));
            this.putLongProperty(Message.HDR_ORIG_MESSAGE_ID, (long)other.getLongProperty(Message.HDR_ORIG_MESSAGE_ID));
        } else {
            SimpleString originalQueue = other.getAddress();
            this.putStringProperty(Message.HDR_ORIGINAL_ADDRESS, originalQueue);
            this.putLongProperty(Message.HDR_ORIG_MESSAGE_ID, other.getMessageID());
        }
        this.setExpiration(0L);
        if (expiry) {
            long actualExpiryTime = System.currentTimeMillis();
            this.putLongProperty(Message.HDR_ACTUAL_EXPIRY_TIME, actualExpiryTime);
        }
        this.bufferValid = false;
    }

    @Override
    public void setPagingStore(PagingStore pagingStore) {
        this.pagingStore = pagingStore;
        this.address = pagingStore.getAddress();
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pagingStore;
    }

    @Override
    public boolean storeIsPaging() {
        if (this.pagingStore != null) {
            return this.pagingStore.isPaging();
        }
        return false;
    }

    public String toString() {
        return "ServerMessage[messageID=" + this.messageID + ",priority=" + this.getPriority() + ", bodySize=" + this.getBodyBuffer().capacity() + ",expiration=" + (this.getExpiration() != 0L ? new Date(this.getExpiration()) : Integer.valueOf(0)) + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]@" + System.identityHashCode(this);
    }

    @Override
    public InputStream getBodyInputStream() {
        return null;
    }

    @Override
    public void encodeMessageIDToBuffer() {
        this.buffer.setLong(this.buffer.getInt(13) + 4, this.messageID);
    }

    @Override
    public byte[] getDuplicateIDBytes() {
        Object duplicateID = this.getDuplicateProperty();
        if (duplicateID == null) {
            return null;
        }
        if (duplicateID instanceof SimpleString) {
            return ((SimpleString)duplicateID).getData();
        }
        return (byte[])duplicateID;
    }

    @Override
    public Object getDuplicateProperty() {
        return this.getObjectProperty(Message.HDR_DUPLICATE_DETECTION_ID);
    }
}

