/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.settings.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.HierarchicalRepositoryChangeListener;
import org.hornetq.core.settings.Mergeable;
import org.hornetq.core.settings.impl.Match;

public class HierarchicalObjectRepository<T>
implements HierarchicalRepository<T> {
    private T defaultmatch;
    private final Map<String, Match<T>> matches = new HashMap<String, Match<T>>();
    private final Set<String> immutables = new HashSet<String>();
    private final MatchComparator matchComparator = new MatchComparator();
    private final Map<String, T> cache = new ConcurrentHashMap<String, T>();
    private final ArrayList<HierarchicalRepositoryChangeListener> listeners = new ArrayList();

    @Override
    public void addMatch(String match, T value) {
        this.addMatch(match, value, false);
    }

    @Override
    public void addMatch(String match, T value, boolean immutableMatch) {
        this.clearCache();
        if (immutableMatch) {
            this.immutables.add(match);
        }
        Match.verify(match);
        Match<T> match1 = new Match<T>(match);
        match1.setValue(value);
        this.matches.put(match, match1);
        this.onChange();
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    @Override
    public T getMatch(String match) {
        T value;
        T cacheResult = this.cache.get(match);
        if (cacheResult != null) {
            return cacheResult;
        }
        HashMap<String, Match<T>> possibleMatches = this.getPossibleMatches(match);
        List<Match<T>> orderedMatches = this.sort(possibleMatches);
        T actualMatch = this.merge(orderedMatches);
        T t = value = actualMatch != null ? actualMatch : this.defaultmatch;
        if (value != null) {
            this.cache.put(match, value);
        }
        return value;
    }

    private T merge(List<Match<T>> orderedMatches) {
        Object actualMatch = null;
        for (Match<T> match : orderedMatches) {
            if (actualMatch == null || !Mergeable.class.isAssignableFrom(actualMatch.getClass())) {
                actualMatch = match.getValue();
                if (Mergeable.class.isAssignableFrom(actualMatch.getClass())) continue;
                break;
            }
            ((Mergeable)actualMatch).merge(match.getValue());
        }
        return (T)actualMatch;
    }

    private List<Match<T>> sort(Map<String, Match<T>> possibleMatches) {
        ArrayList<String> keys = new ArrayList<String>(possibleMatches.keySet());
        Collections.sort(keys, this.matchComparator);
        ArrayList<Match<T>> matches = new ArrayList<Match<T>>();
        for (String key : keys) {
            matches.add(possibleMatches.get(key));
        }
        return matches;
    }

    @Override
    public void removeMatch(String match) {
        boolean isImmutable = this.immutables.contains(match);
        if (isImmutable) {
            HornetQLogger.LOGGER.debug("Cannot remove match " + match + " since it came from a main config");
        } else {
            this.matches.remove(match);
            this.clearCache();
            this.onChange();
        }
    }

    @Override
    public void registerListener(HierarchicalRepositoryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unRegisterListener(HierarchicalRepositoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setDefault(T defaultValue) {
        this.clearCache();
        this.defaultmatch = defaultValue;
    }

    @Override
    public void clear() {
        this.clearCache();
        this.listeners.clear();
        this.matches.clear();
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    private void onChange() {
        for (HierarchicalRepositoryChangeListener listener : this.listeners) {
            try {
                listener.onChange();
            }
            catch (Throwable e) {
                HornetQLogger.LOGGER.errorCallingRepoListener(e);
            }
        }
    }

    private HashMap<String, Match<T>> getPossibleMatches(String match) {
        HashMap<String, Match<T>> possibleMatches = new HashMap<String, Match<T>>();
        for (String key : this.matches.keySet()) {
            if (!this.matches.get(key).getPattern().matcher(match).matches()) continue;
            possibleMatches.put(key, this.matches.get(key));
        }
        return possibleMatches;
    }

    private static class MatchComparator
    implements Comparator<String> {
        private MatchComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.contains("#") && !o2.contains("#")) {
                return 1;
            }
            if (!o1.contains("#") && o2.contains("#")) {
                return -1;
            }
            if (o1.contains("#") && o2.contains("#")) {
                return o2.length() - o1.length();
            }
            if (o1.contains("*") && !o2.contains("*")) {
                return 1;
            }
            if (!o1.contains("*") && o2.contains("*")) {
                return -1;
            }
            if (o1.contains("*") && o2.contains("*")) {
                String[] leftSplits = o1.split("\\.");
                String[] rightSplits = o2.split("\\.");
                for (int i = 0; i < leftSplits.length; ++i) {
                    String left = leftSplits[i];
                    if (!left.equals("*")) continue;
                    if (rightSplits.length < i || !rightSplits[i].equals("*")) {
                        return -1;
                    }
                    return 1;
                }
            }
            return o1.length() - o2.length();
        }
    }
}

