/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.LargeMessageBufferImpl;
import org.hornetq.core.list.PriorityLinkedList;
import org.hornetq.core.list.impl.PriorityLinkedListImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.Channel;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.utils.Future;
import org.hornetq.utils.TokenBucketLimiter;

public class ClientConsumerImpl
implements ClientConsumerInternal {
    private static final Logger log = Logger.getLogger(ClientConsumerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final long CLOSE_TIMEOUT_MILLISECONDS = 10000L;
    public static final int NUM_PRIORITIES = 10;
    public static final SimpleString FORCED_DELIVERY_MESSAGE = new SimpleString("_hornetq.forced.delivery.seq");
    private final ClientSessionInternal session;
    private final Channel channel;
    private final long id;
    private final SimpleString filterString;
    private final SimpleString queueName;
    private final boolean browseOnly;
    private final Executor sessionExecutor;
    private final int clientWindowSize;
    private final int ackBatchSize;
    private final PriorityLinkedList<ClientMessageInternal> buffer = new PriorityLinkedListImpl<ClientMessageInternal>(10);
    private final Runner runner = new Runner();
    private LargeMessageBufferImpl currentLargeMessageBuffer;
    private ClientMessageInternal largeMessageReceived;
    private final TokenBucketLimiter rateLimiter;
    private volatile Thread receiverThread;
    private volatile Thread onMessageThread;
    private volatile MessageHandler handler;
    private volatile boolean closing;
    private volatile boolean closed;
    private volatile int creditsToSend;
    private volatile boolean slowConsumerInitialCreditSent = false;
    private volatile Exception lastException;
    private volatile int ackBytes;
    private volatile ClientMessage lastAckedMessage;
    private boolean stopped = false;
    private final AtomicLong forceDeliveryCount = new AtomicLong(0L);
    private final SessionQueueQueryResponseMessage queueInfo;

    public ClientConsumerImpl(ClientSessionInternal session, long id, SimpleString queueName, SimpleString filterString, boolean browseOnly, int clientWindowSize, int ackBatchSize, TokenBucketLimiter rateLimiter, Executor executor, Channel channel, SessionQueueQueryResponseMessage queueInfo) {
        this.id = id;
        this.queueName = queueName;
        this.filterString = filterString;
        this.browseOnly = browseOnly;
        this.channel = channel;
        this.session = session;
        this.rateLimiter = rateLimiter;
        this.sessionExecutor = executor;
        this.clientWindowSize = clientWindowSize;
        this.ackBatchSize = ackBatchSize;
        this.queueInfo = queueInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientMessage receive(long timeout, boolean forcingDelivery) throws HornetQException {
        this.checkClosed();
        if (this.largeMessageReceived != null) {
            this.largeMessageReceived.discardLargeBody();
            this.largeMessageReceived = null;
        }
        if (this.rateLimiter != null) {
            this.rateLimiter.limit();
        }
        if (this.handler != null) {
            throw new HornetQException(104, "Cannot call receive(...) - a MessageHandler is set");
        }
        if (this.clientWindowSize == 0) {
            this.startSlowConsumer();
        }
        this.receiverThread = Thread.currentThread();
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        boolean deliveryForced = false;
        long start = -1L;
        long toWait = timeout;
        try {
            ClientConsumerImpl clientConsumerImpl;
            block24: {
                ClientMessageInternal m;
                block25: {
                    while (true) {
                        m = null;
                        clientConsumerImpl = this;
                        synchronized (clientConsumerImpl) {
                            while ((this.stopped || (m = this.buffer.removeFirst()) == null) && !this.closed && toWait > 0L) {
                                if (start == -1L) {
                                    start = System.currentTimeMillis();
                                }
                                if (m == null && forcingDelivery) {
                                    if (this.stopped) break;
                                    if (!deliveryForced) {
                                        this.session.forceDelivery(this.id, this.forceDeliveryCount.incrementAndGet());
                                        deliveryForced = true;
                                    }
                                }
                                try {
                                    this.wait(toWait);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (m != null || this.closed) break;
                                long now = System.currentTimeMillis();
                                toWait -= now - start;
                                start = now;
                            }
                        }
                        if (m == null) break block24;
                        this.session.workDone();
                        if (m.containsProperty(FORCED_DELIVERY_MESSAGE)) {
                            long seq = m.getLongProperty(FORCED_DELIVERY_MESSAGE);
                            if (seq < this.forceDeliveryCount.longValue()) continue;
                            ClientMessage clientMessage = null;
                            return clientMessage;
                        }
                        boolean expired = m.isExpired();
                        this.flowControlBeforeConsumption(m);
                        if (!expired) break block25;
                        m.discardLargeBody();
                        this.session.expire(this.id, m.getMessageID());
                        if (this.clientWindowSize == 0) {
                            this.startSlowConsumer();
                        }
                        if (toWait <= 0L) break;
                    }
                    ClientMessage clientMessage = null;
                    return clientMessage;
                }
                if (m.isLargeMessage()) {
                    this.largeMessageReceived = m;
                }
                ClientMessageInternal clientMessageInternal = m;
                return clientMessageInternal;
            }
            clientConsumerImpl = null;
            return clientConsumerImpl;
        }
        finally {
            this.receiverThread = null;
        }
    }

    public ClientMessage receive(long timeout) throws HornetQException {
        return this.receive(timeout, false);
    }

    public ClientMessage receive() throws HornetQException {
        return this.receive(0L, false);
    }

    public ClientMessage receiveImmediate() throws HornetQException {
        return this.receive(0L, true);
    }

    public MessageHandler getMessageHandler() throws HornetQException {
        this.checkClosed();
        return this.handler;
    }

    public synchronized void setMessageHandler(MessageHandler theHandler) throws HornetQException {
        boolean noPreviousHandler;
        this.checkClosed();
        if (this.receiverThread != null) {
            throw new HornetQException(104, "Cannot set MessageHandler - consumer is in receive(...)");
        }
        boolean bl = noPreviousHandler = this.handler == null;
        if (this.handler != theHandler && this.clientWindowSize == 0) {
            this.startSlowConsumer();
        }
        this.handler = theHandler;
        if (this.handler != null && noPreviousHandler) {
            this.requeueExecutors();
        } else if (this.handler == null && !noPreviousHandler) {
            this.waitForOnMessageToComplete();
        }
    }

    public void close() throws HornetQException {
        this.doCleanUp(true);
    }

    public void cleanUp() {
        try {
            this.doCleanUp(false);
        }
        catch (HornetQException e) {
            log.warn("problem cleaning up: " + this);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws HornetQException {
        this.waitForOnMessageToComplete();
        ClientConsumerImpl clientConsumerImpl = this;
        synchronized (clientConsumerImpl) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
        }
    }

    public void clearAtFailover() {
        this.clearBuffer();
        this.lastAckedMessage = null;
        this.creditsToSend = 0;
    }

    public synchronized void start() {
        this.stopped = false;
        this.requeueExecutors();
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public SessionQueueQueryResponseMessage getQueueInfo() {
        return this.queueInfo;
    }

    public long getID() {
        return this.id;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    public synchronized void handleMessage(ClientMessageInternal message) throws Exception {
        if (this.closing) {
            return;
        }
        ClientMessageInternal messageToHandle = message;
        messageToHandle.onReceipt(this);
        this.buffer.addLast(messageToHandle, messageToHandle.getPriority());
        if (this.handler != null) {
            if (!this.stopped) {
                this.queueExecutor();
            }
        } else {
            this.notify();
        }
    }

    public synchronized void handleLargeMessage(SessionReceiveLargeMessage packet) throws Exception {
        if (this.closing) {
            return;
        }
        this.flowControl(packet.getPacketSize(), false);
        ClientMessageImpl currentChunkMessage = new ClientMessageImpl();
        currentChunkMessage.setDeliveryCount(packet.getDeliveryCount());
        currentChunkMessage.decodeHeadersAndProperties(HornetQBuffers.wrappedBuffer(packet.getLargeMessageHeader()));
        currentChunkMessage.setLargeMessage(true);
        File largeMessageCache = null;
        if (this.session.isCacheLargeMessageClient()) {
            largeMessageCache = File.createTempFile("tmp-large-message-" + currentChunkMessage.getMessageID() + "-", ".tmp");
            largeMessageCache.deleteOnExit();
        }
        this.currentLargeMessageBuffer = new LargeMessageBufferImpl(this, packet.getLargeMessageSize(), 60, largeMessageCache);
        currentChunkMessage.setBuffer(this.currentLargeMessageBuffer);
        currentChunkMessage.setFlowControlSize(0);
        this.handleMessage(currentChunkMessage);
    }

    public synchronized void handleLargeMessageContinuation(SessionReceiveContinuationMessage chunk) throws Exception {
        if (this.closing) {
            return;
        }
        this.currentLargeMessageBuffer.addPacket(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws HornetQException {
        ClientConsumerImpl clientConsumerImpl = this;
        synchronized (clientConsumerImpl) {
            for (ClientMessageInternal message : this.buffer) {
                this.flowControlBeforeConsumption(message);
            }
            this.clearBuffer();
        }
        this.waitForOnMessageToComplete();
    }

    public int getClientWindowSize() {
        return this.clientWindowSize;
    }

    public int getBufferSize() {
        return this.buffer.size();
    }

    public void acknowledge(ClientMessage message) throws HornetQException {
        this.ackBytes += message.getEncodeSize();
        if (this.ackBytes >= this.ackBatchSize) {
            this.doAck(message);
        } else {
            this.lastAckedMessage = message;
        }
    }

    public void flushAcks() throws HornetQException {
        if (this.lastAckedMessage != null) {
            this.doAck(this.lastAckedMessage);
        }
    }

    public void flowControl(int messageBytes, boolean discountSlowConsumer) throws HornetQException {
        if (this.clientWindowSize >= 0) {
            this.creditsToSend += messageBytes;
            if (this.creditsToSend >= this.clientWindowSize) {
                if (this.clientWindowSize == 0 && discountSlowConsumer) {
                    if (trace) {
                        log.trace("Sending " + this.creditsToSend + " -1, for slow consumer");
                    }
                    this.slowConsumerInitialCreditSent = false;
                    int credits = this.creditsToSend - 1;
                    this.creditsToSend = 0;
                    this.sendCredits(credits);
                } else {
                    if (trace) {
                        log.trace("Sending " + messageBytes + " from flow-control");
                    }
                    int credits = this.creditsToSend;
                    this.creditsToSend = 0;
                    this.sendCredits(credits);
                }
            }
        }
    }

    private void startSlowConsumer() {
        if (!this.slowConsumerInitialCreditSent) {
            if (trace) {
                log.trace("Sending 1 credit to start delivering of one message to slow consumer");
            }
            this.slowConsumerInitialCreditSent = true;
            this.sendCredits(1);
        }
    }

    private void requeueExecutors() {
        for (int i = 0; i < this.buffer.size(); ++i) {
            this.queueExecutor();
        }
    }

    private void queueExecutor() {
        if (trace) {
            log.trace("Adding Runner on Executor for delivery");
        }
        this.sessionExecutor.execute(this.runner);
    }

    private void sendCredits(int credits) {
        this.channel.send(new SessionConsumerFlowCreditMessage(this.id, credits));
    }

    private void waitForOnMessageToComplete() {
        if (this.handler == null) {
            return;
        }
        if (Thread.currentThread() == this.onMessageThread) {
            return;
        }
        Future future = new Future();
        this.sessionExecutor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Timed out waiting for handler to complete processing");
        }
    }

    private void checkClosed() throws HornetQException {
        if (this.closed) {
            throw new HornetQException(102, "Consumer is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnMessage() throws Exception {
        if (this.closing || this.stopped) {
            return;
        }
        this.session.workDone();
        MessageHandler theHandler = this.handler;
        if (theHandler != null) {
            ClientMessageInternal message;
            if (this.rateLimiter != null) {
                this.rateLimiter.limit();
            }
            ClientConsumerImpl clientConsumerImpl = this;
            synchronized (clientConsumerImpl) {
                message = this.buffer.removeFirst();
            }
            if (message != null) {
                boolean expired = message.isExpired();
                this.flowControlBeforeConsumption(message);
                if (!expired) {
                    this.onMessageThread = Thread.currentThread();
                    if (trace) {
                        log.trace("Calling handler.onMessage");
                    }
                    theHandler.onMessage(message);
                    if (trace) {
                        log.trace("Handler.onMessage done");
                    }
                    if (message.isLargeMessage()) {
                        message.discardLargeBody();
                    }
                } else {
                    this.session.expire(this.id, message.getMessageID());
                }
                if (this.clientWindowSize == 0) {
                    this.startSlowConsumer();
                }
            }
        }
    }

    private void flowControlBeforeConsumption(ClientMessageInternal message) throws HornetQException {
        if (message.getFlowControlSize() != 0) {
            this.flowControl(message.getFlowControlSize(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanUp(boolean sendCloseMessage) throws HornetQException {
        try {
            if (this.closed) {
                return;
            }
            this.closing = true;
            this.waitForOnMessageToComplete();
            if (this.currentLargeMessageBuffer != null) {
                this.currentLargeMessageBuffer.cancel();
                this.currentLargeMessageBuffer = null;
            }
            this.closed = true;
            ClientConsumerImpl clientConsumerImpl = this;
            synchronized (clientConsumerImpl) {
                if (this.receiverThread != null) {
                    this.notify();
                }
                this.handler = null;
                this.receiverThread = null;
            }
            this.flushAcks();
            this.clearBuffer();
            if (sendCloseMessage) {
                this.channel.sendBlocking(new SessionConsumerCloseMessage(this.id));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.session.removeConsumer(this);
    }

    private void clearBuffer() {
        this.buffer.clear();
    }

    private void doAck(ClientMessage message) throws HornetQException {
        this.ackBytes = 0;
        this.lastAckedMessage = null;
        this.session.acknowledge(this.id, message.getMessageID());
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        public void run() {
            try {
                ClientConsumerImpl.this.callOnMessage();
            }
            catch (Exception e) {
                log.error("Failed to call onMessage()", e);
                ClientConsumerImpl.this.lastException = e;
            }
        }
    }
}

