/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.list.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hornetq.core.list.PriorityLinkedList;
import org.hornetq.utils.concurrent.Deque;
import org.hornetq.utils.concurrent.LinkedBlockingDeque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityLinkedListImpl<T>
implements PriorityLinkedList<T> {
    private final List<Deque<T>> levels;
    private final int priorities;
    private int size;

    public PriorityLinkedListImpl(int priorities) {
        this.priorities = priorities;
        this.levels = new ArrayList<Deque<T>>();
        for (int i = 0; i < priorities; ++i) {
            this.levels.add(new LinkedBlockingDeque());
        }
    }

    @Override
    public void addFirst(T t, int priority) {
        this.levels.get(priority).addFirst(t);
        ++this.size;
    }

    @Override
    public void addLast(T t, int priority) {
        this.levels.get(priority).addLast(t);
        ++this.size;
    }

    @Override
    public T removeFirst() {
        T t = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            Deque<T> ll = this.levels.get(i);
            if (ll.isEmpty()) continue;
            t = ll.removeFirst();
            break;
        }
        if (t != null) {
            --this.size;
        }
        return t;
    }

    @Override
    public T peekFirst() {
        T t = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            Deque<T> ll = this.levels.get(i);
            if (!ll.isEmpty()) {
                t = ll.getFirst();
            }
            if (t != null) break;
        }
        return t;
    }

    @Override
    public List<T> getAll() {
        ArrayList<T> all = new ArrayList<T>();
        for (int i = this.priorities - 1; i >= 0; --i) {
            Deque<T> list = this.levels.get(i);
            all.addAll(list);
        }
        return all;
    }

    @Override
    public void clear() {
        for (Deque<T> list : this.levels) {
            list.clear();
        }
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new PriorityLinkedListIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PriorityLinkedListIterator
    implements Iterator<T> {
        private int index;
        private Iterator<T> currentIter;

        PriorityLinkedListIterator() {
            this.index = PriorityLinkedListImpl.this.levels.size() - 1;
            this.currentIter = ((Deque)PriorityLinkedListImpl.this.levels.get(this.index)).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIter.hasNext()) {
                return true;
            }
            while (this.index >= 0 && this.index != 0 && !this.currentIter.hasNext()) {
                --this.index;
                this.currentIter = ((Deque)PriorityLinkedListImpl.this.levels.get(this.index)).iterator();
            }
            return this.currentIter.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIter.next();
        }

        @Override
        public void remove() {
            this.currentIter.remove();
            PriorityLinkedListImpl.this.size--;
        }
    }
}

