/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.Packet;
import org.hornetq.core.remoting.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.CreateReplicationSessionMessage;
import org.hornetq.core.remoting.impl.wireformat.CreateSessionMessage;
import org.hornetq.core.remoting.impl.wireformat.CreateSessionResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.remoting.impl.wireformat.NullResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;
import org.hornetq.core.remoting.impl.wireformat.PacketsConfirmedMessage;
import org.hornetq.core.remoting.impl.wireformat.Ping;
import org.hornetq.core.remoting.impl.wireformat.ReattachSessionMessage;
import org.hornetq.core.remoting.impl.wireformat.ReattachSessionResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationAddMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationAddTXMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationCommitMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationCompareDataMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationDeleteMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationDeleteTXMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationLargeMessageBeingMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationLargemessageEndMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationPageEventMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationPageWriteMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationPrepareMessage;
import org.hornetq.core.remoting.impl.wireformat.ReplicationResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.RollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionBindingQueryResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionCloseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionCommitMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionExpiredMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.remoting.impl.wireformat.SessionProducerCreditsMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionReceiveMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAStartMessage;

public class PacketDecoder {
    private static final Logger log = Logger.getLogger(PacketDecoder.class);

    public Packet decode(HornetQBuffer in) {
        PacketImpl packet;
        byte packetType = in.readByte();
        switch (packetType) {
            case 10: {
                packet = new Ping();
                break;
            }
            case 11: {
                packet = new PacketImpl(11);
                break;
            }
            case 20: {
                packet = new HornetQExceptionMessage();
                break;
            }
            case 22: {
                packet = new PacketsConfirmedMessage();
                break;
            }
            case 30: {
                packet = new CreateSessionMessage();
                break;
            }
            case 31: {
                packet = new CreateSessionResponseMessage();
                break;
            }
            case 32: {
                packet = new ReattachSessionMessage();
                break;
            }
            case 33: {
                packet = new ReattachSessionResponseMessage();
                break;
            }
            case 69: {
                packet = new SessionCloseMessage();
                break;
            }
            case 40: {
                packet = new SessionCreateConsumerMessage();
                break;
            }
            case 41: {
                packet = new SessionAcknowledgeMessage();
                break;
            }
            case 42: {
                packet = new SessionExpiredMessage();
                break;
            }
            case 43: {
                packet = new SessionCommitMessage();
                break;
            }
            case 44: {
                packet = new RollbackMessage();
                break;
            }
            case 45: {
                packet = new SessionQueueQueryMessage();
                break;
            }
            case 46: {
                packet = new SessionQueueQueryResponseMessage();
                break;
            }
            case 34: {
                packet = new CreateQueueMessage();
                break;
            }
            case 35: {
                packet = new SessionDeleteQueueMessage();
                break;
            }
            case 49: {
                packet = new SessionBindingQueryMessage();
                break;
            }
            case 50: {
                packet = new SessionBindingQueryResponseMessage();
                break;
            }
            case 51: {
                packet = new SessionXAStartMessage();
                break;
            }
            case 52: {
                packet = new SessionXAEndMessage();
                break;
            }
            case 53: {
                packet = new SessionXACommitMessage();
                break;
            }
            case 54: {
                packet = new SessionXAPrepareMessage();
                break;
            }
            case 55: {
                packet = new SessionXAResponseMessage();
                break;
            }
            case 56: {
                packet = new SessionXARollbackMessage();
                break;
            }
            case 57: {
                packet = new SessionXAJoinMessage();
                break;
            }
            case 58: {
                packet = new PacketImpl(58);
                break;
            }
            case 59: {
                packet = new SessionXAResumeMessage();
                break;
            }
            case 60: {
                packet = new SessionXAForgetMessage();
                break;
            }
            case 61: {
                packet = new PacketImpl(61);
                break;
            }
            case 62: {
                packet = new SessionXAGetInDoubtXidsResponseMessage();
                break;
            }
            case 63: {
                packet = new SessionXASetTimeoutMessage();
                break;
            }
            case 64: {
                packet = new SessionXASetTimeoutResponseMessage();
                break;
            }
            case 65: {
                packet = new PacketImpl(65);
                break;
            }
            case 66: {
                packet = new SessionXAGetTimeoutResponseMessage();
                break;
            }
            case 67: {
                packet = new PacketImpl(67);
                break;
            }
            case 68: {
                packet = new PacketImpl(68);
                break;
            }
            case 70: {
                packet = new SessionConsumerFlowCreditMessage();
                break;
            }
            case 71: {
                packet = new SessionSendMessage();
                break;
            }
            case 72: {
                packet = new SessionSendLargeMessage();
                break;
            }
            case 75: {
                packet = new SessionReceiveMessage();
                break;
            }
            case 76: {
                packet = new SessionReceiveLargeMessage();
                break;
            }
            case 74: {
                packet = new SessionConsumerCloseMessage();
                break;
            }
            case 21: {
                packet = new NullResponseMessage();
                break;
            }
            case 77: {
                packet = new SessionReceiveContinuationMessage();
                break;
            }
            case 73: {
                packet = new SessionSendContinuationMessage();
                break;
            }
            case 79: {
                packet = new SessionRequestProducerCreditsMessage();
                break;
            }
            case 80: {
                packet = new SessionProducerCreditsMessage();
                break;
            }
            case 36: {
                packet = new CreateReplicationSessionMessage();
                break;
            }
            case 91: {
                packet = new ReplicationAddMessage();
                break;
            }
            case 92: {
                packet = new ReplicationAddTXMessage();
                break;
            }
            case 93: {
                packet = new ReplicationDeleteMessage();
                break;
            }
            case 94: {
                packet = new ReplicationDeleteTXMessage();
                break;
            }
            case 95: {
                packet = new ReplicationPrepareMessage();
                break;
            }
            case 96: {
                packet = new ReplicationCommitMessage();
                break;
            }
            case 90: {
                packet = new ReplicationResponseMessage();
                break;
            }
            case 97: {
                packet = new ReplicationPageWriteMessage();
                break;
            }
            case 98: {
                packet = new ReplicationPageEventMessage();
                break;
            }
            case 99: {
                packet = new ReplicationLargeMessageBeingMessage();
                break;
            }
            case 100: {
                packet = new ReplicationLargemessageEndMessage();
                break;
            }
            case 101: {
                packet = new ReplicationLargeMessageWriteMessage();
                break;
            }
            case 102: {
                packet = new ReplicationCompareDataMessage();
                break;
            }
            case 78: {
                packet = new SessionForceConsumerDelivery();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + packetType);
            }
        }
        packet.decode(in);
        return packet;
    }
}

