/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.hornetq.api.core.HornetQException;
import org.hornetq.utils.DefaultSensitiveStringCodec;
import org.hornetq.utils.SensitiveDataCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordMaskingUtil {
    public static SensitiveDataCodec<String> getCodec(String codecDesc) throws HornetQException {
        SensitiveDataCodec<String> codecInstance = null;
        String[] parts = codecDesc.split(";");
        if (parts.length < 1) {
            throw new HornetQException(104, "Invalid PasswordCodec value: " + codecDesc);
        }
        final String codecClassName = parts[0];
        codecInstance = AccessController.doPrivileged(new PrivilegedAction<SensitiveDataCodec<String>>(){

            @Override
            public SensitiveDataCodec<String> run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(codecClassName);
                    return (SensitiveDataCodec)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error instantiating codec \"" + codecClassName + "\"", e);
                }
            }
        });
        if (parts.length > 1) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                String[] keyVal = parts[i].split("=");
                if (keyVal.length != 2) {
                    throw new HornetQException(104, "invalid property: " + parts[i]);
                }
                props.put(keyVal[0], keyVal[1]);
            }
            codecInstance.init(props);
        }
        return codecInstance;
    }

    public static SensitiveDataCodec<String> getDefaultCodec() {
        return new DefaultSensitiveStringCodec();
    }
}

