/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterTopologyChangeMessage_V2
extends ClusterTopologyChangeMessage {
    private long uniqueEventID;

    public ClusterTopologyChangeMessage_V2(long uniqueEventID, String nodeID, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        super((byte)114);
        this.nodeID = nodeID;
        this.pair = pair;
        this.last = last;
        this.exit = false;
        this.uniqueEventID = uniqueEventID;
    }

    public ClusterTopologyChangeMessage_V2(long uniqueEventID, String nodeID) {
        super((byte)114);
        this.exit = true;
        this.nodeID = nodeID;
        this.uniqueEventID = uniqueEventID;
    }

    public ClusterTopologyChangeMessage_V2() {
        super((byte)114);
    }

    public long getUniqueEventID() {
        return this.uniqueEventID;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeBoolean(this.exit);
        buffer.writeString(this.nodeID);
        buffer.writeLong(this.uniqueEventID);
        if (!this.exit) {
            if (this.pair.getA() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getA()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            if (this.pair.getB() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getB()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(this.last);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.exit = buffer.readBoolean();
        this.nodeID = buffer.readString();
        this.uniqueEventID = buffer.readLong();
        if (!this.exit) {
            TransportConfiguration b;
            TransportConfiguration a;
            boolean hasLive = buffer.readBoolean();
            if (hasLive) {
                a = new TransportConfiguration();
                a.decode(buffer);
            } else {
                a = null;
            }
            boolean hasBackup = buffer.readBoolean();
            if (hasBackup) {
                b = new TransportConfiguration();
                b.decode(buffer);
            } else {
                b = null;
            }
            this.pair = new Pair<TransportConfiguration, TransportConfiguration>(a, b);
            this.last = buffer.readBoolean();
        }
    }
}

