/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.ServerSessionPacketHandler;
import org.hornetq.core.protocol.core.impl.HornetQPacketHandler;
import org.hornetq.core.protocol.core.impl.RemotingConnectionImpl;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreProtocolManager
implements ProtocolManager {
    private final HornetQServer server;
    private final List<Interceptor> interceptors;
    private Map<String, ServerSessionPacketHandler> sessionHandlers = new ConcurrentHashMap<String, ServerSessionPacketHandler>();

    public CoreProtocolManager(HornetQServer server, List<Interceptor> interceptors) {
        this.server = server;
        this.interceptors = interceptors;
    }

    @Override
    public ConnectionEntry createConnectionEntry(Connection connection) {
        final Configuration config = this.server.getConfiguration();
        final RemotingConnectionImpl rc = new RemotingConnectionImpl(connection, this.interceptors, config.isAsyncConnectionExecutionEnabled() ? this.server.getExecutorFactory().getExecutor() : null, this.server.getNodeID());
        Channel channel1 = rc.getChannel(1L, -1);
        HornetQPacketHandler handler = new HornetQPacketHandler(this, this.server, channel1, rc);
        channel1.setHandler(handler);
        long ttl = 60000L;
        if (config.getConnectionTTLOverride() != -1L) {
            ttl = config.getConnectionTTLOverride();
        }
        final ConnectionEntry entry = new ConnectionEntry(rc, System.currentTimeMillis(), ttl);
        final Channel channel0 = rc.getChannel(0L, -1);
        channel0.setHandler(new ChannelHandler(){

            public void handlePacket(Packet packet) {
                if (packet.getType() == 10) {
                    Ping ping = (Ping)packet;
                    if (config.getConnectionTTLOverride() == -1L) {
                        entry.ttl = ping.getConnectionTTL();
                    }
                    channel0.send(packet);
                } else if (packet.getType() == 112) {
                    SubscribeClusterTopologyUpdatesMessage msg = (SubscribeClusterTopologyUpdatesMessage)packet;
                    final ClusterTopologyListener listener = new ClusterTopologyListener(){

                        @Override
                        public void nodeUP(String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
                            channel0.send(new ClusterTopologyChangeMessage(nodeID, connectorPair, last));
                        }

                        @Override
                        public void nodeDown(String nodeID) {
                            channel0.send(new ClusterTopologyChangeMessage(nodeID));
                        }
                    };
                    final boolean isCC = msg.isClusterConnection();
                    CoreProtocolManager.this.server.getClusterManager().addClusterTopologyListener(listener, isCC);
                    rc.addCloseListener(new CloseListener(){

                        public void connectionClosed() {
                            CoreProtocolManager.this.server.getClusterManager().removeClusterTopologyListener(listener, isCC);
                        }
                    });
                } else if (packet.getType() == 111) {
                    NodeAnnounceMessage msg = (NodeAnnounceMessage)packet;
                    Pair<Object, TransportConfiguration> pair = msg.isBackup() ? new Pair<Object, TransportConfiguration>(null, msg.getConnector()) : new Pair<TransportConfiguration, Object>(msg.getConnector(), null);
                    CoreProtocolManager.this.server.getClusterManager().notifyNodeUp(msg.getNodeID(), pair, false, true);
                }
            }
        });
        return entry;
    }

    public ServerSessionPacketHandler getSessionHandler(String sessionName) {
        return this.sessionHandlers.get(sessionName);
    }

    public void addSessionHandler(String name, ServerSessionPacketHandler handler) {
        this.sessionHandlers.put(name, handler);
    }

    @Override
    public void removeHandler(String name) {
        this.sessionHandlers.remove(name);
    }

    @Override
    public void handleBuffer(RemotingConnection connection, HornetQBuffer buffer) {
    }

    @Override
    public int isReadyToHandle(HornetQBuffer buffer) {
        return -1;
    }
}

