/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.logging.Logger;

public class HornetQThreadFactory
implements ThreadFactory {
    private static final Logger log = Logger.getLogger(HornetQThreadFactory.class);
    private final ThreadGroup group;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final int threadPriority;
    private final boolean daemon;
    private final ClassLoader tccl;

    public HornetQThreadFactory(String groupName, boolean daemon, ClassLoader tccl) {
        this(groupName, 5, daemon, tccl);
    }

    public HornetQThreadFactory(String groupName, int threadPriority, boolean daemon, ClassLoader tccl) {
        this.group = new ThreadGroup(groupName + "-" + System.identityHashCode(this));
        this.threadPriority = threadPriority;
        this.tccl = tccl;
        this.daemon = daemon;
    }

    public Thread newThread(Runnable command) {
        final Thread t = System.getSecurityManager() == null ? new Thread(this.group, command, "Thread-" + this.threadCount.getAndIncrement() + " (group:" + this.group.getName() + ")") : new Thread(command, "Thread-" + this.threadCount.getAndIncrement());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                t.setDaemon(HornetQThreadFactory.this.daemon);
                t.setPriority(HornetQThreadFactory.this.threadPriority);
                return null;
            }
        });
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    t.setContextClassLoader(HornetQThreadFactory.this.tccl);
                    return null;
                }
            });
        }
        catch (AccessControlException e) {
            log.warn("Missing privileges to set Thread Context Class Loader on Thread Factory. Using current Thread Context Class Loader");
        }
        return t;
    }
}

