/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client;

import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Interceptor;
import org.hornetq.core.protocol.core.Packet;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.w3c.dom.Node;

@MessageLogger(projectCode="HQ")
public interface HornetQClientLogger
extends BasicLogger {
    public static final HornetQClientLogger LOGGER = (HornetQClientLogger)Logger.getMessageLogger(HornetQClientLogger.class, (String)HornetQClientLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=211014, value="**** Dumping session creation stacks ****", format=Message.Format.MESSAGE_FORMAT)
    public void dumpingSessionStacks();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=211015, value="session created", format=Message.Format.MESSAGE_FORMAT)
    public void dumpingSessionStack(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212016, value="{0}", format=Message.Format.MESSAGE_FORMAT)
    public void warn(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212017, value="Error on clearing messages", format=Message.Format.MESSAGE_FORMAT)
    public void errorClearingMessages(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212018, value="Timed out waiting for handler to complete processing", format=Message.Format.MESSAGE_FORMAT)
    public void timeOutWaitingForProcessing();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212019, value="Unable to close session", format=Message.Format.MESSAGE_FORMAT)
    public void unableToCloseSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212020, value="Failed to connect to server.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToConnectToServer();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212021, value="Tried {0} times to connect. Now giving up on reconnecting it.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToConnectToServer(Integer var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212022, value="Waiting {0} milliseconds before next retry. RetryInterval={1} and multiplier={2}", format=Message.Format.MESSAGE_FORMAT)
    public void waitingForRetry(Long var1, Long var2, Double var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212023, value="connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we will deal with it anyway.", format=Message.Format.MESSAGE_FORMAT)
    public void createConnectorException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212024, value="I am closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void factoryLeftOpen(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212025, value="resetting session after failure", format=Message.Format.MESSAGE_FORMAT)
    public void resettingSessionAfterFailure();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212026, value="Server is starting, retry to create the session {0}", format=Message.Format.MESSAGE_FORMAT)
    public void retryCreateSessionSeverStarting(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212027, value="committing transaction after failover occurred, any non persistent messages may be lost", format=Message.Format.MESSAGE_FORMAT)
    public void commitAfterFailover();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212028, value="failover occured during commit throwing XAException.XA_RETRY", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringCommit();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212029, value="failover occurred during prepare re-trying", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringPrepare();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212030, value="failover occurred during prepare rolling back", format=Message.Format.MESSAGE_FORMAT)
    public void failoverDuringPrepareRollingBack();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212031, value="failover occurred during prepare rolling back", format=Message.Format.MESSAGE_FORMAT)
    public void errorDuringPrepare(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212032, value="I am closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void clientSessionNotClosed(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212033, value="error adding packet", format=Message.Format.MESSAGE_FORMAT)
    public void errorAddingPacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212034, value="error calling cancel", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingCancel(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212035, value="error reading index", format=Message.Format.MESSAGE_FORMAT)
    public void errorReadingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212036, value="error setting index", format=Message.Format.MESSAGE_FORMAT)
    public void errorSettingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212037, value="error resetting index", format=Message.Format.MESSAGE_FORMAT)
    public void errorReSettingIndex(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212038, value="error reading LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorReadingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212039, value="error closing LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212040, value="Exception during finalization for LargeMessage file cache", format=Message.Format.MESSAGE_FORMAT)
    public void errorFinalisingCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212041, value="did not connect the cluster connection to other nodes", format=Message.Format.MESSAGE_FORMAT)
    public void errorConnectingToNodes(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212042, value="Timed out waiting for pool to terminate", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutWaitingForTermination();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212043, value="Timed out waiting for scheduled pool to terminate", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutWaitingForScheduledPoolTermination();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212044, value="error starting server locator", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingLocator(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212045, value="Closing a Server Locator left open. Please make sure you close all Server Locators explicitly before letting them go out of scope! {0}", format=Message.Format.MESSAGE_FORMAT)
    public void serverLocatorNotClosed(@Cause Exception var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212046, value="error sending topology", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingTopology(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212047, value="error sending topology", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingTopologyNodedown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212048, value="Timed out waiting to stop discovery thread", format=Message.Format.MESSAGE_FORMAT)
    public void timedOutStoppingDiscovery();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212049, value="unable to send notification when discovery group is stopped", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingNotifOnDiscoveryStop(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212050, value="There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its live node. nodeID={0}", format=Message.Format.MESSAGE_FORMAT)
    public void multipleServersBroadcastingSameNode(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212051, value="error receiving packet in discovery", format=Message.Format.MESSAGE_FORMAT)
    public void errorReceivingPAcketInDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212103, value="Can not find packet to clear: {0} last received command id first stored command id {1}", format=Message.Format.MESSAGE_FORMAT)
    public void cannotFindPacketToClear(Integer var1, Integer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212107, value="Connection failure has been detected: {0} [code={1}]", format=Message.Format.MESSAGE_FORMAT)
    public void connectionFailureDetected(String var1, HornetQExceptionType var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212108, value="Failure in calling interceptor: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingInterceptor(@Cause Throwable var1, Interceptor var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212113, value="Unexpected Netty Version was expecting {0} using {1} Version.ID", format=Message.Format.MESSAGE_FORMAT)
    public void unexpectedNettyVersion(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212119, value="Timed out waiting for netty ssl close future to complete", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutClosingSSL();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212120, value="Timed out waiting for netty channel to close", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutClosingNettyChannel();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212121, value="Timed out waiting for packet to be flushed", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutFlushingPacket();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212151, value="Property {0} must be an Integer, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotInteger(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212152, value="Property {0} must be an Long, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotLong(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212153, value="Property {0} must be an Boolean, it is {1}", format=Message.Format.MESSAGE_FORMAT)
    public void propertyNotBoolean(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212154, value="Cannot find hornetq-version.properties on classpath: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void noVersionOnClasspath(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212155, value="Warning: JVM allocated more data what would make results invalid {0}:{1}", format=Message.Format.MESSAGE_FORMAT)
    public void jvmAllocatedMoreMemory(Long var1, Long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212159, value="local-bind-address specified for broadcast group but no local-bind-port specified so socket will NOT be bound to a local address/port", format=Message.Format.MESSAGE_FORMAT)
    public void broadcastGroupBindError();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212213, value="Could not bind to {0} ({1} address); make sure your discovery group-address is of the same type as the IP stack (IPv4 or IPv6).\nIgnoring discovery group-address, but this may lead to cross talking.", format=Message.Format.MESSAGE_FORMAT)
    public void ioDiscoveryError(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=212215, value="Compressed large message tried to read {0} bytes from stream {1}", format=Message.Format.MESSAGE_FORMAT)
    public void compressedLargeMessageError(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214001, value="Failed to call onMessage", format=Message.Format.MESSAGE_FORMAT)
    public void onMessageError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214003, value="failed to cleanup session", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCleanupSession(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214004, value="Failed to execute failure listener", format=Message.Format.MESSAGE_FORMAT)
    public void failedToExecuteListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214005, value="Failed to handle failover", format=Message.Format.MESSAGE_FORMAT)
    public void failedToHandleFailover(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214006, value="XA end operation failed ", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingEnd(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214007, value="XA start operation failed {0} code:{1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingStart(String var1, Integer var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214008, value="Session is not XA", format=Message.Format.MESSAGE_FORMAT)
    public void sessionNotXA();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214009, value="Received exception asynchronously from server", format=Message.Format.MESSAGE_FORMAT)
    public void receivedExceptionAsynchronously(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214010, value="Failed to handle packet", format=Message.Format.MESSAGE_FORMAT)
    public void failedToHandlePacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214011, value="Failed to stop discovery group", format=Message.Format.MESSAGE_FORMAT)
    public void failedToStopDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214013, value="Failed to receive datagram", format=Message.Format.MESSAGE_FORMAT)
    public void failedToReceiveDatagramInDiscovery(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214014, value="Failed to call discovery listener", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCallListenerInDiscovery(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214035, value="Unexpected error handling packet {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorHandlingPacket(@Cause Throwable var1, Packet var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214036, value="Failed to decode packet", format=Message.Format.MESSAGE_FORMAT)
    public void errorDecodingPacket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214037, value="Failed to execute failure listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingFailureListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214044, value="Failed to execute connection life cycle listener", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingLifeCycleListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214045, value="Failed to create netty connection", format=Message.Format.MESSAGE_FORMAT)
    public void errorCreatingNettyConnection(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214075, value="Caught unexpected Throwable", format=Message.Format.MESSAGE_FORMAT)
    public void caughtunexpectedThrowable(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214076, value="Failed to invoke getTextContent() on node {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnXMLTransform(@Cause Throwable var1, Node var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214077, value="Invalid configuration", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnXMLTransformInvalidConf(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214081, value="Exception happened while stopping Discovery BroadcastEndpoint {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStoppingDiscoveryBroadcastEndpoint(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=214084, value="Invalid concurrent session usage. Sessions are not supposed to be used by more than one thread concurrently.", format=Message.Format.MESSAGE_FORMAT)
    public void invalidConcurrentSessionUsage(@Cause Throwable var1);
}

