/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.BroadcastEndpoint;
import org.hornetq.api.core.BroadcastEndpointFactory;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.cluster.DiscoveryEntry;
import org.hornetq.core.cluster.DiscoveryListener;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.utils.TypedProperties;

public final class DiscoveryGroup
implements HornetQComponent {
    private static final boolean isTrace = HornetQClientLogger.LOGGER.isTraceEnabled();
    private final List<DiscoveryListener> listeners = new ArrayList<DiscoveryListener>();
    private final String name;
    private Thread thread;
    private boolean received;
    private final Object waitLock = new Object();
    private final Map<String, DiscoveryEntry> connectors = new ConcurrentHashMap<String, DiscoveryEntry>();
    private final long timeout;
    private volatile boolean started;
    private final String nodeID;
    private final Map<String, String> uniqueIDMap = new HashMap<String, String>();
    private final BroadcastEndpoint endpoint;
    private final NotificationService notificationService;

    public DiscoveryGroup(String nodeID, String name, long timeout, BroadcastEndpointFactory endpointFactory, NotificationService service) throws Exception {
        this.nodeID = nodeID;
        this.name = name;
        this.timeout = timeout;
        this.endpoint = endpointFactory.createBroadcastEndpoint();
        this.notificationService = service;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.endpoint.openClient();
        this.started = true;
        this.thread = new Thread((Runnable)new DiscoveryRunnable(), "hornetq-discovery-group-thread-" + this.name);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.DISCOVERY_GROUP_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
        try {
            this.endpoint.close(false);
        }
        catch (Exception e1) {
            HornetQClientLogger.LOGGER.errorStoppingDiscoveryBroadcastEndpoint(this.endpoint, e1);
        }
        try {
            this.thread.interrupt();
            this.thread.join(10000L);
            if (this.thread.isAlive()) {
                HornetQClientLogger.LOGGER.timedOutStoppingDiscovery();
            }
        }
        catch (InterruptedException e) {
            throw new HornetQInterruptedException((Throwable)e);
        }
        this.thread = null;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.DISCOVERY_GROUP_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                HornetQClientLogger.LOGGER.errorSendingNotifOnDiscoveryStop(e);
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public String getName() {
        return this.name;
    }

    public synchronized List<DiscoveryEntry> getDiscoveryEntries() {
        ArrayList<DiscoveryEntry> list = new ArrayList<DiscoveryEntry>(this.connectors.values());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForBroadcast(long timeout) {
        Object object = this.waitLock;
        synchronized (object) {
            long start = System.currentTimeMillis();
            long toWait = timeout;
            while (this.started && !this.received && (toWait > 0L || timeout == 0L)) {
                try {
                    this.waitLock.wait(toWait);
                }
                catch (InterruptedException e) {
                    throw new HornetQInterruptedException((Throwable)e);
                }
                if (timeout == 0L) continue;
                long now = System.currentTimeMillis();
                toWait -= now - start;
                start = now;
            }
            boolean ret = this.received;
            this.received = false;
            return ret;
        }
    }

    private void checkUniqueID(String originatingNodeID, String uniqueID) {
        String currentUniqueID = this.uniqueIDMap.get(originatingNodeID);
        if (currentUniqueID == null) {
            this.uniqueIDMap.put(originatingNodeID, uniqueID);
        } else if (!currentUniqueID.equals(uniqueID)) {
            HornetQClientLogger.LOGGER.multipleServersBroadcastingSameNode(originatingNodeID);
            this.uniqueIDMap.put(originatingNodeID, uniqueID);
        }
    }

    public synchronized void registerListener(DiscoveryListener listener) {
        this.listeners.add(listener);
        if (!this.connectors.isEmpty()) {
            listener.connectorsChanged(this.getDiscoveryEntries());
        }
    }

    public synchronized void unregisterListener(DiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    private void callListeners() {
        for (DiscoveryListener listener : this.listeners) {
            try {
                listener.connectorsChanged(this.getDiscoveryEntries());
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.failedToCallListenerInDiscovery(t);
            }
        }
    }

    private boolean checkExpiration() {
        boolean changed = false;
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, DiscoveryEntry>> iter = this.connectors.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, DiscoveryEntry> entry = iter.next();
            if (entry.getValue().getLastUpdate() + this.timeout > now) continue;
            if (isTrace) {
                HornetQClientLogger.LOGGER.trace("Timed out node on discovery:" + entry.getValue());
            }
            iter.remove();
            changed = true;
        }
        return changed;
    }

    class DiscoveryRunnable
    implements Runnable {
        DiscoveryRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                byte[] data = null;
                while (DiscoveryGroup.this.started) {
                    try {
                        data = DiscoveryGroup.this.endpoint.receiveBroadcast();
                        if (data == null) {
                            if (!DiscoveryGroup.this.started) return;
                            HornetQClientLogger.LOGGER.warn("Unexpected null data received from DiscoveryEndpoint");
                            return;
                        }
                    }
                    catch (Exception e) {
                        if (!DiscoveryGroup.this.started) {
                            return;
                        }
                        HornetQClientLogger.LOGGER.errorReceivingPAcketInDiscovery(e);
                    }
                    HornetQBuffer buffer = HornetQBuffers.wrappedBuffer((byte[])data);
                    String originatingNodeID = buffer.readString();
                    String uniqueID = buffer.readString();
                    DiscoveryGroup.this.checkUniqueID(originatingNodeID, uniqueID);
                    if (DiscoveryGroup.this.nodeID.equals(originatingNodeID)) {
                        if (!DiscoveryGroup.this.checkExpiration()) continue;
                        DiscoveryGroup.this.callListeners();
                        continue;
                    }
                    int size = buffer.readInt();
                    boolean changed = false;
                    DiscoveryEntry[] entriesRead = new DiscoveryEntry[size];
                    for (int i = 0; i < size; ++i) {
                        Object connector = new TransportConfiguration();
                        ((TransportConfiguration)connector).decode(buffer);
                        entriesRead[i] = new DiscoveryEntry(originatingNodeID, (TransportConfiguration)connector, System.currentTimeMillis());
                    }
                    DiscoveryGroup i = DiscoveryGroup.this;
                    // MONITORENTER : i
                    for (DiscoveryEntry entry : entriesRead) {
                        if (DiscoveryGroup.this.connectors.put(originatingNodeID, entry) != null) continue;
                        changed = true;
                    }
                    changed = changed || DiscoveryGroup.this.checkExpiration();
                    // MONITOREXIT : i
                    if (changed && DiscoveryGroup.this.started) {
                        if (isTrace) {
                            HornetQClientLogger.LOGGER.trace("Connectors changed on Discovery:");
                            for (Object connector : DiscoveryGroup.this.connectors.values()) {
                                HornetQClientLogger.LOGGER.trace(connector);
                            }
                        }
                        DiscoveryGroup.this.callListeners();
                    }
                    Object object = DiscoveryGroup.this.waitLock;
                    // MONITORENTER : object
                    DiscoveryGroup.this.received = true;
                    DiscoveryGroup.this.waitLock.notifyAll();
                    // MONITOREXIT : object
                }
                return;
            }
            catch (Exception e) {
                HornetQClientLogger.LOGGER.failedToReceiveDatagramInDiscovery(e);
            }
        }
    }
}

