/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfigurationCompatibilityHelper;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.utils.UUIDGenerator;

public final class DiscoveryGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 8657206421727863400L;
    private String name = UUIDGenerator.getInstance().generateStringUUID();
    private long refreshTimeout = 10000L;
    private long discoveryInitialWaitTimeout = 10000L;
    private transient String localBindAddress = null;
    private transient int localBindPort = -1;
    private String groupAddress = null;
    private int groupPort = -1;
    private transient BroadcastEndpointFactoryConfiguration endpointFactoryConfiguration;

    public String getName() {
        return this.name;
    }

    public long getRefreshTimeout() {
        return this.refreshTimeout;
    }

    public DiscoveryGroupConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public DiscoveryGroupConfiguration setRefreshTimeout(long refreshTimeout) {
        this.refreshTimeout = refreshTimeout;
        return this;
    }

    public long getDiscoveryInitialWaitTimeout() {
        return this.discoveryInitialWaitTimeout;
    }

    public DiscoveryGroupConfiguration setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
        return this;
    }

    public BroadcastEndpointFactoryConfiguration getBroadcastEndpointFactoryConfiguration() {
        return this.endpointFactoryConfiguration;
    }

    public DiscoveryGroupConfiguration setBroadcastEndpointFactoryConfiguration(BroadcastEndpointFactoryConfiguration endpointFactoryConfiguration) {
        this.endpointFactoryConfiguration = endpointFactoryConfiguration;
        if (endpointFactoryConfiguration instanceof DiscoveryGroupConfigurationCompatibilityHelper) {
            DiscoveryGroupConfigurationCompatibilityHelper dgcch = (DiscoveryGroupConfigurationCompatibilityHelper)((Object)endpointFactoryConfiguration);
            this.localBindAddress = dgcch.getLocalBindAddress();
            this.localBindPort = dgcch.getLocalBindPort();
            this.groupAddress = dgcch.getGroupAddress();
            this.groupPort = dgcch.getGroupPort();
        }
        return this;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.groupPort < 0) {
            out.writeObject(this.endpointFactoryConfiguration);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.endpointFactoryConfiguration = this.groupPort < 0 ? (BroadcastEndpointFactoryConfiguration)in.readObject() : new UDPBroadcastGroupConfiguration().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort).setLocalBindAddress(this.localBindAddress).setLocalBindPort(this.localBindPort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryGroupConfiguration that = (DiscoveryGroupConfiguration)o;
        if (this.discoveryInitialWaitTimeout != that.discoveryInitialWaitTimeout) {
            return false;
        }
        if (this.refreshTimeout != that.refreshTimeout) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (int)(this.refreshTimeout ^ this.refreshTimeout >>> 32);
        result = 31 * result + (int)(this.discoveryInitialWaitTimeout ^ this.discoveryInitialWaitTimeout >>> 32);
        return result;
    }

    public String toString() {
        return "DiscoveryGroupConfiguration{name='" + this.name + '\'' + ", refreshTimeout=" + this.refreshTimeout + ", discoveryInitialWaitTimeout=" + this.discoveryInitialWaitTimeout + '}';
    }
}

