/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQPropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.utils.UUID;

public interface Message {
    public static final SimpleString HDR_ACTUAL_EXPIRY_TIME = new SimpleString("_HQ_ACTUAL_EXPIRY");
    public static final SimpleString HDR_ORIGINAL_ADDRESS = new SimpleString("_HQ_ORIG_ADDRESS");
    public static final SimpleString HDR_ORIGINAL_QUEUE = new SimpleString("_HQ_ORIG_QUEUE");
    public static final SimpleString HDR_ORIG_MESSAGE_ID = new SimpleString("_HQ_ORIG_MESSAGE_ID");
    public static final SimpleString HDR_GROUP_ID = new SimpleString("_HQ_GROUP_ID");
    public static final SimpleString HDR_LARGE_COMPRESSED = new SimpleString("_HQ_LARGE_COMPRESSED");
    public static final SimpleString HDR_LARGE_BODY_SIZE = new SimpleString("_HQ_LARGE_SIZE");
    public static final SimpleString HDR_SCHEDULED_DELIVERY_TIME = new SimpleString("_HQ_SCHED_DELIVERY");
    public static final SimpleString HDR_DUPLICATE_DETECTION_ID = new SimpleString("_HQ_DUPL_ID");
    public static final SimpleString HDR_LAST_VALUE_NAME = new SimpleString("_HQ_LVQ_NAME");
    public static final byte DEFAULT_TYPE = 0;
    public static final byte OBJECT_TYPE = 2;
    public static final byte TEXT_TYPE = 3;
    public static final byte BYTES_TYPE = 4;
    public static final byte MAP_TYPE = 5;
    public static final byte STREAM_TYPE = 6;

    public long getMessageID();

    public UUID getUserID();

    public Message setUserID(UUID var1);

    public SimpleString getAddress();

    public Message setAddress(SimpleString var1);

    public byte getType();

    public boolean isDurable();

    public Message setDurable(boolean var1);

    public long getExpiration();

    public boolean isExpired();

    public Message setExpiration(long var1);

    public long getTimestamp();

    public Message setTimestamp(long var1);

    public byte getPriority();

    public Message setPriority(byte var1);

    public int getEncodeSize();

    public boolean isLargeMessage();

    public HornetQBuffer getBodyBuffer();

    public Message writeBodyBufferBytes(byte[] var1);

    public Message writeBodyBufferString(String var1);

    public HornetQBuffer getBodyBufferCopy();

    public Message putBooleanProperty(SimpleString var1, boolean var2);

    public Message putBooleanProperty(String var1, boolean var2);

    public Message putByteProperty(SimpleString var1, byte var2);

    public Message putByteProperty(String var1, byte var2);

    public Message putBytesProperty(SimpleString var1, byte[] var2);

    public Message putBytesProperty(String var1, byte[] var2);

    public Message putShortProperty(SimpleString var1, short var2);

    public Message putShortProperty(String var1, short var2);

    public Message putCharProperty(SimpleString var1, char var2);

    public Message putCharProperty(String var1, char var2);

    public Message putIntProperty(SimpleString var1, int var2);

    public Message putIntProperty(String var1, int var2);

    public Message putLongProperty(SimpleString var1, long var2);

    public Message putLongProperty(String var1, long var2);

    public Message putFloatProperty(SimpleString var1, float var2);

    public Message putFloatProperty(String var1, float var2);

    public Message putDoubleProperty(SimpleString var1, double var2);

    public Message putDoubleProperty(String var1, double var2);

    public Message putStringProperty(SimpleString var1, SimpleString var2);

    public Message putStringProperty(String var1, String var2);

    public Message putObjectProperty(SimpleString var1, Object var2) throws HornetQPropertyConversionException;

    public Message putObjectProperty(String var1, Object var2) throws HornetQPropertyConversionException;

    public Object removeProperty(SimpleString var1);

    public Object removeProperty(String var1);

    public boolean containsProperty(SimpleString var1);

    public boolean containsProperty(String var1);

    public Boolean getBooleanProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public Boolean getBooleanProperty(String var1) throws HornetQPropertyConversionException;

    public Byte getByteProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public Byte getByteProperty(String var1) throws HornetQPropertyConversionException;

    public Double getDoubleProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public Double getDoubleProperty(String var1) throws HornetQPropertyConversionException;

    public Integer getIntProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public Integer getIntProperty(String var1) throws HornetQPropertyConversionException;

    public Long getLongProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public Long getLongProperty(String var1) throws HornetQPropertyConversionException;

    public Object getObjectProperty(SimpleString var1);

    public Object getObjectProperty(String var1);

    public Short getShortProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public Short getShortProperty(String var1) throws HornetQPropertyConversionException;

    public Float getFloatProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public Float getFloatProperty(String var1) throws HornetQPropertyConversionException;

    public String getStringProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public String getStringProperty(String var1) throws HornetQPropertyConversionException;

    public SimpleString getSimpleStringProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public SimpleString getSimpleStringProperty(String var1) throws HornetQPropertyConversionException;

    public byte[] getBytesProperty(SimpleString var1) throws HornetQPropertyConversionException;

    public byte[] getBytesProperty(String var1) throws HornetQPropertyConversionException;

    public Set<SimpleString> getPropertyNames();

    public Map<String, Object> toMap();
}

